/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.connection.internal.ui.filter;

import java.util.Iterator;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wst.rdb.connection.internal.ui.filter.RDBFilterWizardPage;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionFilter;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionFilterImpl;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;

public class SchemaFilterWizardPage
extends RDBFilterWizardPage {
    private ConnectionInfo connectionInfo;

    public SchemaFilterWizardPage(String pageName) {
        super(pageName);
    }

    protected ConnectionFilter getConnectionFilter() {
        ConnectionFilter connFilter = null;
        if (this.connectionInfo != null) {
            connFilter = this.connectionInfo.getFilter("DatatoolsSchemaFilterPredicate");
        }
        return connFilter;
    }

    protected void populateSelectionTable() {
        ConnectionFilter filter = this.getConnectionFilter();
        this.setConnectionFilter(null);
        if (this.connectionInfo != null) {
            Database sdb = this.connectionInfo.getSharedDatabase();
            if (sdb != null) {
                ((ICatalogObject)sdb).refresh();
                this.selectionTable.removeAll();
                if (this.connectionInfo != null) {
                    Iterator schemas = sdb.getSchemas().iterator();
                    while (schemas.hasNext()) {
                        TableItem tableItem = new TableItem(this.selectionTable, 0);
                        tableItem.setText(((SQLObject)schemas.next()).getName());
                    }
                    this.isSelectionListPopulated = true;
                }
            }
            this.setConnectionFilter(filter);
            ((ICatalogObject)this.connectionInfo.getSharedDatabase()).refresh();
        }
    }

    public void setConnectionInfo(ConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
        this.initializeValues();
    }

    public void applyFilter() {
        if (this.connectionInfo != null) {
            ConnectionFilterImpl connFilter = null;
            if (this.isFilterSpecified()) {
                connFilter = new ConnectionFilterImpl();
                connFilter.setPredicate(this.getPredicate());
            }
            this.setConnectionFilter((ConnectionFilter)connFilter);
        }
    }

    public void setConnectionFilter(ConnectionFilter connFilter) {
        if (this.connectionInfo != null) {
            if (connFilter == null) {
                this.connectionInfo.removeFilter("DatatoolsSchemaFilterPredicate");
            } else {
                this.connectionInfo.addFilter("DatatoolsSchemaFilterPredicate", connFilter);
            }
        }
    }
}

