/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.server.internal.ui.explorer.content;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionManager;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionManagerListener;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionSharingListener;
import org.eclipse.wst.rdb.server.internal.ui.explorer.content.ConnectionNodeUtil;
import org.eclipse.wst.rdb.server.internal.ui.explorer.content.ServerExplorerConnectionSharingListener;
import org.eclipse.wst.rdb.server.internal.ui.explorer.content.ServerExplorerInitializer;
import org.eclipse.wst.rdb.server.internal.ui.explorer.content.ServerNotFoundException;
import org.eclipse.wst.rdb.server.internal.ui.services.IServicesManager;

public class ServerExplorerConnectionManagedListener
implements ConnectionManagerListener {
    private static final IServicesManager manager = IServicesManager.INSTANCE;
    private static final ConnectionManager connectionManager = RDBCorePlugin.getDefault().getConnectionManager();
    private Map sharingListenerMap = new HashMap();

    private ConnectionInfo getConnectionInfo(String name) {
        Iterator iterator = this.sharingListenerMap.keySet().iterator();
        while (iterator.hasNext()) {
            ConnectionInfo info = (ConnectionInfo)iterator.next();
            if (!info.getName().equals(name)) continue;
            return info;
        }
        return null;
    }

    private void removeConnectionFromMap(ConnectionInfo info) {
        if (this.sharingListenerMap.containsKey(info)) {
            ConnectionSharingListener listener = (ConnectionSharingListener)this.sharingListenerMap.get(info);
            info.removeConnectionSharingListener(listener);
            this.sharingListenerMap.remove(info);
        }
    }

    public void dispose() {
        ConnectionInfo[] infos = RDBCorePlugin.getDefault().getConnectionManager().getAllNamedConnectionInfo();
        int i = 0;
        int n = infos.length;
        while (i < n) {
            ConnectionInfo info = infos[i];
            if (info.getSharedDatabase() != null) {
                info.removeSharedDatabase();
            }
            if (info.getSharedConnection() != null) {
                info.removeSharedConnection();
            }
            this.removeConnectionFromMap(infos[i]);
            ++i;
        }
    }

    public void connectionInfoCreated(final ConnectionInfo info) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (!ServerExplorerConnectionManagedListener.this.sharingListenerMap.containsKey(info)) {
                    ServerExplorerConnectionSharingListener listener = new ServerExplorerConnectionSharingListener();
                    info.addConnectionSharingListener((ConnectionSharingListener)listener);
                    ServerExplorerConnectionManagedListener.this.sharingListenerMap.put(info, listener);
                    new ServerExplorerInitializer().displayNewConnection(info.getName(), info);
                }
            }
        });
    }

    public void connectionInfoRemoved(final String name) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ConnectionInfo info = ServerExplorerConnectionManagedListener.this.getConnectionInfo(name);
                ServerExplorerConnectionManagedListener.this.removeConnectionFromMap(info);
                if (info != null) {
                    try {
                        IConnectionNode node = ConnectionNodeUtil.getConnectionNode(info);
                        IServicesManager.INSTANCE.getServerExplorerContentService().deleteServer(new IConnectionNode[]{node});
                    }
                    catch (ServerNotFoundException serverNotFoundException) {}
                }
            }
        });
    }

    public void connectionInfoRenamed(String previousName, ConnectionInfo info) {
    }

    public void connected(final ConnectionInfo info, Connection connection) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                new ServerExplorerInitializer().displayNewConnection(info.getName(), info);
            }
        });
    }

    public void disconnected(final ConnectionInfo info, Connection connection) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    IConnectionNode connectionNode = ConnectionNodeUtil.getConnectionNode(info);
                    IServicesManager.INSTANCE.getServerExplorerContentService().disconnectServers(new IConnectionNode[]{connectionNode});
                }
                catch (ServerNotFoundException serverNotFoundException) {}
            }
        });
    }
}

