/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.InternalValidatorManager;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.TaskListUtility;
import org.eclipse.wst.validation.internal.ValidationConfiguration;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.operations.IResourceUtil;
import org.eclipse.wst.validation.internal.operations.WorkbenchReporter;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public final class ValidatorManager {
    private static ValidatorManager inst = null;
    private static IResourceUtil _resourceUtil = null;
    private static final Class RESOURCEUTIL_DEFAULTCLASS;
    private static Class _resourceUtilClass;
    private static final Set EMPTY_SET;
    private Set _suspendedProjects = new HashSet();
    private boolean _suspendAllValidation = false;
    private static Class _messageLimitOwner;
    private String[] _internalOwners = new String[0];
    public static HashMap messageLimitProjectMap;
    public static HashMap messageLimitMessageProjectMap;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.validation.internal.operations.DefaultResourceUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _resourceUtilClass = RESOURCEUTIL_DEFAULTCLASS = clazz;
        EMPTY_SET = Collections.EMPTY_SET;
        _messageLimitOwner = null;
        messageLimitProjectMap = null;
        messageLimitMessageProjectMap = null;
    }

    private ValidatorManager() {
        this.addInternalOwner(this.getMessageLimitOwner());
    }

    public void disableAllValidators(IProject currentProject, IProgressMonitor monitor) {
        this.setEnabledValidators(currentProject, EMPTY_SET, monitor);
    }

    public static void addProjectBuildValidationSupport(IProject project) {
        if (project == null) {
            return;
        }
        boolean isBuilderAdded = false;
        try {
            IProjectDescription description = project.getDescription();
            ICommand[] commands = description.getBuildSpec();
            if (commands != null) {
                int i = 0;
                while (i < commands.length) {
                    String builderName = commands[i].getBuilderName();
                    if (builderName != null && builderName.equals("org.eclipse.wst.validation.validationbuilder")) {
                        isBuilderAdded = true;
                        break;
                    }
                    ++i;
                }
            }
            if (!isBuilderAdded) {
                ICommand newCommand = description.newCommand();
                newCommand.setBuilderName("org.eclipse.wst.validation.validationbuilder");
                ICommand[] newCommands = null;
                if (commands != null) {
                    newCommands = new ICommand[commands.length + 1];
                    System.arraycopy(commands, 0, newCommands, 0, commands.length);
                    newCommands[commands.length] = newCommand;
                } else {
                    newCommands = new ICommand[]{newCommand};
                }
                description.setBuildSpec(newCommands);
                project.setDescription(description, null);
            }
        }
        catch (CoreException coreException) {
            return;
        }
    }

    public static boolean doesProjectSupportBuildValidation(IProject project) {
        boolean canRunAV = false;
        if (project == null) {
            return canRunAV;
        }
        try {
            IProjectDescription description = project.getDescription();
            ICommand[] commands = description.getBuildSpec();
            if (commands == null) {
                return canRunAV;
            }
            int i = 0;
            while (i < commands.length) {
                String builderName = commands[i].getBuilderName();
                if (builderName != null && builderName.equals("org.eclipse.wst.validation.validationbuilder")) {
                    canRunAV = true;
                    break;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
        return canRunAV;
    }

    public void enableAllValidators(IProject project, IProgressMonitor monitor) {
        block2: {
            try {
                ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
                prjp.setEnabledValidators(prjp.getValidators());
            }
            catch (InvocationTargetException exc) {
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block2;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("ValidatorManager::enableAllValidators(" + project.getName() + ")");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
                if (exc.getTargetException() == null) break block2;
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
    }

    public Set getProjectConfiguredIncrementalValidators(IProject project) {
        try {
            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
            return InternalValidatorManager.wrapInSet(prjp.getIncrementalValidators());
        }
        catch (InvocationTargetException exc) {
            Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("ValidatorManager::getProjectConfiguredIncrementalValidators(" + project.getName() + ")");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
                if (exc.getTargetException() != null) {
                    entry.setTargetException((Throwable)exc);
                    logger.write(Level.SEVERE, (Object)entry);
                }
            }
            return Collections.EMPTY_SET;
        }
    }

    public Set getProjectConfiguredValidatorMetaData(IProject project) {
        try {
            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
            return InternalValidatorManager.wrapInSet(prjp.getValidators());
        }
        catch (InvocationTargetException exc) {
            Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("ValidatorManager::getProjectConfiguredValidatorMetaData(" + project.getName() + ")");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
                if (exc.getTargetException() != null) {
                    entry.setTargetException((Throwable)exc);
                    logger.write(Level.SEVERE, (Object)entry);
                }
            }
            return Collections.EMPTY_SET;
        }
    }

    public Set getProjectEnabledIncrementalValidators(IProject project) {
        try {
            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
            return InternalValidatorManager.wrapInSet(prjp.getEnabledIncrementalValidators(true));
        }
        catch (InvocationTargetException exc) {
            Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceIdentifier("ValidatorManager::getProjectEnabledIncrementalValidators" + project.getName() + ")");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
                if (exc.getTargetException() != null) {
                    entry.setTargetException((Throwable)exc);
                    logger.write(Level.SEVERE, (Object)entry);
                }
            }
            return Collections.EMPTY_SET;
        }
    }

    public Collection getProjectEnabledNonIncrementalValidators(IProject project) {
        try {
            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
            return InternalValidatorManager.wrapInSet(prjp.getEnabledIncrementalValidators(false));
        }
        catch (InvocationTargetException exc) {
            Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceIdentifier("ValidatorManager::getProjectEnabledNonIncrementalValidators" + project.getName() + ")");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
                if (exc.getTargetException() != null) {
                    entry.setTargetException((Throwable)exc);
                    logger.write(Level.SEVERE, (Object)entry);
                }
            }
            return Collections.EMPTY_SET;
        }
    }

    public Set getProjectEnabledValidators(IProject project) {
        return this.getEnabledValidators(project);
    }

    public static ValidatorManager getManager() {
        if (inst == null) {
            inst = new ValidatorManager();
        }
        return inst;
    }

    public static IResourceUtil getResourceUtil() {
        if (_resourceUtil == null) {
            if (_resourceUtilClass == null) {
                _resourceUtilClass = RESOURCEUTIL_DEFAULTCLASS;
            }
            try {
                _resourceUtil = (IResourceUtil)_resourceUtilClass.newInstance();
            }
            catch (ClassCastException classCastException) {
                _resourceUtil = null;
            }
            catch (InstantiationException instantiationException) {
                _resourceUtil = null;
            }
            catch (IllegalAccessException illegalAccessException) {
                _resourceUtil = null;
            }
        }
        return _resourceUtil;
    }

    public IMarker[] getValidationTasks(int severity, IProject project) {
        return this.getValidationTasks((IResource)project, severity);
    }

    public IMarker[] getValidationTasks(IResource resource, int severity) {
        return TaskListUtility.getValidationTasks(resource, severity);
    }

    public IMarker[] getValidationTasks(IResource resource, String[] validatorNames) {
        return TaskListUtility.getValidationTasks(resource, validatorNames);
    }

    public int getMaximumMessagesAllowed(IProject project) {
        try {
            return ConfigurationManager.getManager().getProjectConfiguration(project).getMaximumNumberOfMessages();
        }
        catch (InvocationTargetException exc) {
            Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceIdentifier("ValidatorManager.getMaximumMessagesAllowed(" + project.getName() + ")");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
                if (exc.getTargetException() != null) {
                    entry.setTargetException((Throwable)exc);
                    logger.write(Level.SEVERE, (Object)entry);
                }
            }
            return ValidationConfiguration.getMaximumNumberOfMessagesDefault();
        }
    }

    public ValidatorMetaData getValidatorMetaData(IValidator validator) {
        return ValidationRegistryReader.getReader().getValidatorMetaData(validator);
    }

    public Set getIncrementalValidators(Collection vmds) {
        if (vmds == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<ValidatorMetaData> result = new HashSet<ValidatorMetaData>();
        Iterator iterator = vmds.iterator();
        while (iterator.hasNext()) {
            ValidatorMetaData vmd = (ValidatorMetaData)iterator.next();
            if (!vmd.isIncremental()) continue;
            result.add(vmd);
        }
        return result;
    }

    public boolean isApplicableTo(String validatorId, IResource res) {
        if (validatorId == null || res == null) {
            return false;
        }
        ValidatorMetaData vmd = ValidationRegistryReader.getReader().getValidatorMetaData(validatorId);
        if (vmd == null) {
            return false;
        }
        if (!ValidationRegistryReader.getReader().isConfiguredOnProject(vmd, res.getProject())) {
            return false;
        }
        return vmd.isApplicableTo(res);
    }

    public boolean isAutoValidate(IProject project) {
        return this.isAutoValidate(project, this.isGlobalAutoBuildEnabled());
    }

    public boolean isAutoValidateChecked(IProject project) {
        return this.isAutoValidate(project);
    }

    public boolean isAutoValidateChecked(IProject project, boolean isGlobalAutoBuildOn) {
        return this.isAutoValidate(project, isGlobalAutoBuildOn);
    }

    public boolean isAutoValidate(IProject project, boolean isGlobalAutoBuildOn) {
        block5: {
            try {
                boolean isAutoValidate = ConfigurationManager.getManager().getProjectConfiguration(project).isAutoValidate();
                if (isAutoValidate) break block5;
                return false;
            }
            catch (InvocationTargetException exc) {
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (logger.isLoggingLevel(Level.SEVERE)) {
                    LogEntry entry = ValidationPlugin.getLogEntry();
                    entry.setSourceIdentifier("ValidatorManager.canAutoValidateButtonBeEnabled(" + project.getName() + ")");
                    entry.setTargetException((Throwable)exc);
                    logger.write(Level.SEVERE, (Object)entry);
                    if (exc.getTargetException() != null) {
                        entry.setTargetException((Throwable)exc);
                        logger.write(Level.SEVERE, (Object)entry);
                    }
                }
                return ValidationConfiguration.getAutoValidateDefault();
            }
        }
        return this.canAutoValidateButtonBeEnabled(project, isGlobalAutoBuildOn);
    }

    public boolean canAutoValidateButtonBeEnabled(IProject project) {
        return this.canAutoValidateButtonBeEnabled(project, this.isGlobalAutoBuildEnabled());
    }

    public Set getEnabledIncrementalValidators(IProject project) {
        try {
            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
            Object[] vmds = prjp.getEnabledIncrementalValidators(true);
            return InternalValidatorManager.wrapInSet(vmds);
        }
        catch (InvocationTargetException exc) {
            Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceIdentifier("ValidatorManager::getEnabledIncrementalValidators" + project.getName() + ")");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
                if (exc.getTargetException() != null) {
                    entry.setTargetException((Throwable)exc);
                    logger.write(Level.SEVERE, (Object)entry);
                }
            }
            return Collections.EMPTY_SET;
        }
    }

    public Set getProjectConfiguredValidators(IProject project, Object[] enabledVal, boolean getIncremental) {
        if (project == null || enabledVal == null || enabledVal.length == 0) {
            return Collections.EMPTY_SET;
        }
        HashSet<ValidatorMetaData> val = new HashSet<ValidatorMetaData>();
        int i = 0;
        while (i < enabledVal.length) {
            ValidatorMetaData vmd = (ValidatorMetaData)enabledVal[i];
            if (vmd.isConfiguredOnProject(project) && (!getIncremental || vmd.isIncremental())) {
                val.add(vmd);
            }
            ++i;
        }
        return val;
    }

    public boolean containsIncrementalValidators(Object[] enabledVal) {
        if (enabledVal == null || enabledVal.length == 0) {
            return false;
        }
        int i = 0;
        while (i < enabledVal.length) {
            ValidatorMetaData vmd = (ValidatorMetaData)enabledVal[i];
            if (vmd.isIncremental()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected Set getEnabledValidators(IProject project) {
        try {
            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
            Object[] vmds = prjp.getEnabledValidators();
            return InternalValidatorManager.wrapInSet(vmds);
        }
        catch (InvocationTargetException exc) {
            Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceIdentifier("ValidatorManager::getEnabledValidators" + project.getName() + ")");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
                if (exc.getTargetException() != null) {
                    entry.setTargetException((Throwable)exc);
                    logger.write(Level.SEVERE, (Object)entry);
                }
            }
            return Collections.EMPTY_SET;
        }
    }

    public void updateTaskList(IProject project) {
        block5: {
            try {
                ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
                ValidatorMetaData[] vmds = prjp.getDisabledValidators();
                int i = 0;
                while (i < vmds.length) {
                    ValidatorMetaData vmd = vmds[i];
                    WorkbenchReporter.removeAllMessages((IResource)project, vmd.getValidatorNames(), null);
                    ++i;
                }
                if (prjp.numberOfEnabledValidators() > 0) {
                    ValidatorManager.getManager().checkMessageLimit(project, false);
                } else {
                    ValidatorManager.getManager().removeMessageLimitExceeded(project);
                }
            }
            catch (InvocationTargetException exc) {
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block5;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceIdentifier("ValidatorManager.updateTaskList(" + project.getName() + ")");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
                if (exc.getTargetException() == null) break block5;
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
    }

    public boolean canAutoValidateButtonBeEnabled(IProject project, boolean isGlobalAutoBuildOn) {
        try {
            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
            boolean incrementalValEnabled = prjp.numberOfEnabledIncrementalValidators() > 0;
            return this.canAutoValidateButtonBeEnabled(project, isGlobalAutoBuildOn, incrementalValEnabled);
        }
        catch (InvocationTargetException exc) {
            Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceIdentifier("ValidatorManager::canAutoValidateButtonBeEnabled" + project.getName() + ")");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
                if (exc.getTargetException() != null) {
                    entry.setTargetException((Throwable)exc);
                    logger.write(Level.SEVERE, (Object)entry);
                }
            }
            return false;
        }
    }

    public boolean canAutoValidateButtonBeEnabled(IProject project, boolean isGlobalAutoBuildOn, boolean incrementalValEnabled) {
        boolean doesProjectSupportAutoValidate = ValidatorManager.doesProjectSupportBuildValidation(project);
        return doesProjectSupportAutoValidate && isGlobalAutoBuildOn && incrementalValEnabled;
    }

    public boolean isEnabled(IProject project, String validatorName) {
        try {
            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
            return prjp.isEnabled(validatorName);
        }
        catch (InvocationTargetException exc) {
            Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceIdentifier("ValidatorManager.isEnabled(" + project.getName() + ", " + validatorName + ")");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
                if (exc.getTargetException() != null) {
                    entry.setTargetException((Throwable)exc);
                    logger.write(Level.SEVERE, (Object)entry);
                }
            }
            return false;
        }
    }

    public boolean isEnabled(IProject project, ValidatorMetaData vmd) {
        try {
            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
            return prjp.isEnabled(vmd);
        }
        catch (InvocationTargetException exc) {
            Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceIdentifier("ValidatorManager::isEnabled" + project.getName() + ")");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
                if (exc.getTargetException() != null) {
                    entry.setTargetException((Throwable)exc);
                    logger.write(Level.SEVERE, (Object)entry);
                }
            }
            return false;
        }
    }

    public boolean isConfigured(IProject project, ValidatorMetaData vmd) {
        return ValidationRegistryReader.getReader().isConfiguredOnProject(vmd, project);
    }

    public boolean isGlobalAutoBuildEnabled() {
        return ResourcesPlugin.getWorkspace().isAutoBuilding();
    }

    public int numberProjectEnabledValidators(IProject project) {
        if (project == null) {
            return 0;
        }
        try {
            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
            return prjp.numberOfEnabledValidators();
        }
        catch (InvocationTargetException exc) {
            Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceIdentifier("ValidatorManager::numberProjectEnabledValidators" + project.getName() + ")");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
                if (exc.getTargetException() != null) {
                    entry.setTargetException((Throwable)exc);
                    logger.write(Level.SEVERE, (Object)entry);
                }
            }
            return 0;
        }
    }

    public void setAutoValidate(IProject project, boolean auto) {
        block2: {
            try {
                ConfigurationManager.getManager().getProjectConfiguration(project).setAutoValidate(auto);
            }
            catch (InvocationTargetException exc) {
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block2;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceIdentifier("ValidatorManager.setAutoValidate(" + project.getName() + ", " + auto + ")");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
                if (exc.getTargetException() == null) break block2;
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
    }

    public void suspendValidation(IProject project, boolean suspend) {
        if (project == null) {
            return;
        }
        if (!project.exists()) {
            return;
        }
        if (suspend) {
            this._suspendedProjects.add(project);
        } else {
            this._suspendedProjects.remove(project);
        }
    }

    public void suspendAllValidation(boolean suspend) {
        this._suspendAllValidation = suspend;
    }

    public boolean isSuspended() {
        return this._suspendAllValidation;
    }

    public boolean isSuspended(IProject project) {
        if (project == null) {
            return false;
        }
        if (this._suspendAllValidation) {
            return true;
        }
        return this._suspendedProjects.contains(project);
    }

    public boolean isProjectSuspended(IProject project) {
        if (project == null) {
            return false;
        }
        return this._suspendedProjects.contains(project);
    }

    public void setEnabledValidators(IProject project, Set vmdsSet, IProgressMonitor monitor) {
        block4: {
            try {
                ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
                ValidatorMetaData[] vmds = null;
                if (vmdsSet == null) {
                    vmds = new ValidatorMetaData[]{};
                } else {
                    vmds = new ValidatorMetaData[vmdsSet.size()];
                    vmdsSet.toArray(vmds);
                }
                prjp.setEnabledValidators(vmds);
                this.updateTaskList(project);
            }
            catch (InvocationTargetException exc) {
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block4;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceIdentifier("ValidatorManager.setEnabledValidators(" + project.getName() + ", Set, IProgressMonitor)");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
                if (exc.getTargetException() == null) break block4;
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
    }

    public static void setResourceUtilClass(Class clazz) {
        _resourceUtilClass = clazz;
    }

    public boolean isMessageLimitExceeded(IResource resource) {
        block9: {
            int numValTasks;
            int numExceeded;
            int max;
            IProject project;
            block10: {
                if (resource == null) {
                    return false;
                }
                if (!resource.exists()) {
                    return false;
                }
                project = resource.getProject();
                if (this.isNoMessageLimit(project)) {
                    return false;
                }
                ValidatorManager.initializeMessageLimitProjectMap(project);
                Object messagesAddedForProject = messageLimitProjectMap.get(project);
                int valTasks = (Integer)messagesAddedForProject;
                ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
                max = prjp.getMaximumNumberOfMessages();
                ValidatorManager.initializeMessageLimitMessageProjectMap();
                Object messageLimitMessageAdded = messageLimitMessageProjectMap.get(project);
                boolean isMessageLimitMessageAdded = false;
                if (messageLimitMessageAdded != null) {
                    isMessageLimitMessageAdded = (Boolean)messageLimitMessageAdded;
                }
                if (valTasks < max && !isMessageLimitMessageAdded) break block9;
                IMarker[] exceededTasks = this.getLimitMessage(project);
                numExceeded = exceededTasks == null ? 0 : exceededTasks.length;
                numValTasks = valTasks - numExceeded;
                if (numValTasks <= max) break block10;
                return true;
            }
            try {
                if (numExceeded > 0 && numValTasks == max) {
                    return true;
                }
            }
            catch (InvocationTargetException exc) {
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block9;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceIdentifier("ValidatorManager.setEnabledValidators(" + project.getName() + ", Set, IProgressMonitor)");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
                if (exc.getTargetException() == null) break block9;
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
        return false;
    }

    public static void initializeMessageLimitProjectMap(IProject project) {
        if (messageLimitProjectMap == null) {
            messageLimitProjectMap = new HashMap();
        }
        if (messageLimitProjectMap.get(project) == null) {
            messageLimitProjectMap.put(project, new Integer(0));
        }
    }

    public static void setMessageLimitMessageForProject(IProject project) {
        ValidatorManager.initializeMessageLimitMessageProjectMap();
        messageLimitMessageProjectMap.put(project, Boolean.TRUE);
    }

    private static void initializeMessageLimitMessageProjectMap() {
        if (messageLimitMessageProjectMap == null) {
            messageLimitMessageProjectMap = new HashMap();
        }
    }

    public void setNoMessageLimit(IProject project) {
        this.setMessageLimit(project, -1);
    }

    public boolean isNoMessageLimit(IProject project) {
        block4: {
            try {
                ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
                int max = prjp.getMaximumNumberOfMessages();
                if (max == -1) {
                    return true;
                }
            }
            catch (InvocationTargetException exc) {
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block4;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceIdentifier("ValidatorManager.setEnabledValidators(" + project.getName() + ", Set, IProgressMonitor)");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
                if (exc.getTargetException() == null) break block4;
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
        return false;
    }

    public void setMessageLimit(IProject project, int limit) {
        block4: {
            try {
                if (limit == -1 || limit >= 0) {
                    ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
                    if (!prjp.doesProjectOverride()) {
                        prjp.setDoesProjectOverride(true);
                    }
                    prjp.setMaximumNumberOfMessages(limit);
                }
            }
            catch (InvocationTargetException exc) {
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block4;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceIdentifier("ValidatorManager.setMessageLimit(" + project.getName() + ", " + limit + ")");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
                if (exc.getTargetException() == null) break block4;
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
    }

    public boolean checkMessageLimit(IProject project) {
        return this.checkMessageLimit(project, true);
    }

    public boolean checkMessageLimit(IProject project, Iterator iterator) {
        return this.checkMessageLimit(project, false);
    }

    public boolean checkMessageLimit(IProject project, boolean removeExceededMessage) {
        boolean result;
        block13: {
            if (project == null) {
                return true;
            }
            if (!this.isMessageLimitExceeded((IResource)project)) {
                if (removeExceededMessage) {
                    this.removeMessageLimitExceeded(project);
                }
                return true;
            }
            result = true;
            try {
                ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
                int max = prjp.getMaximumNumberOfMessages();
                IMarker[] markers = this.getValidationTasksWithoutLimitMessage(project);
                int numExceededMarkers = markers.length - max;
                if (numExceededMarkers >= 0) {
                    block12: {
                        int index = max >= 0 ? max : 0;
                        IMarker[] removeMarkers = new IMarker[numExceededMarkers];
                        System.arraycopy(markers, index, removeMarkers, 0, numExceededMarkers);
                        try {
                            ResourcesPlugin.getWorkspace().deleteMarkers(removeMarkers);
                        }
                        catch (CoreException exc) {
                            Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                            if (!logger.isLoggingLevel(Level.SEVERE)) break block12;
                            LogEntry entry = ValidationPlugin.getLogEntry();
                            entry.setSourceID("ValidatorManager.checkMessageLimit(" + project.getName() + ")");
                            entry.setTargetException((Throwable)exc);
                            logger.write(Level.SEVERE, (Object)entry);
                        }
                    }
                    result = false;
                    if (max > 0) {
                        this.addMessageLimitExceeded(project);
                    }
                    break block13;
                }
                if (removeExceededMessage) {
                    this.removeMessageLimitExceeded(project);
                }
            }
            catch (InvocationTargetException exc) {
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (logger.isLoggingLevel(Level.SEVERE)) {
                    LogEntry entry = ValidationPlugin.getLogEntry();
                    entry.setSourceIdentifier("ValidatorManager.checkMessageLimit(" + project.getName() + ")");
                    entry.setTargetException((Throwable)exc);
                    logger.write(Level.SEVERE, (Object)entry);
                    if (exc.getTargetException() != null) {
                        entry.setTargetException((Throwable)exc);
                        logger.write(Level.SEVERE, (Object)entry);
                    }
                }
                return true;
            }
        }
        return result;
    }

    public boolean checkMessageLimit(IProject project, Iterator iterator, boolean removeExceededMessage) {
        return this.checkMessageLimit(project, removeExceededMessage);
    }

    private IMarker[] getLimitMessage(IProject project) {
        IMarker[] exceededMessage = TaskListUtility.getValidationTasks((IResource)project, WorkbenchReporter.getUniqueId(this.getMessageLimitOwner()));
        if (exceededMessage != null && exceededMessage.length != 0) {
            return exceededMessage;
        }
        return null;
    }

    private boolean isLimitMessage(IMarker marker) {
        if (marker == null) {
            return false;
        }
        return TaskListUtility.isOwner(marker, WorkbenchReporter.getUniqueId(this.getMessageLimitOwner()));
    }

    private IMarker[] getValidationTasksWithoutLimitMessage(IProject project) {
        IMarker[] allTasks = TaskListUtility.getValidationTasks((IResource)project, 7);
        if (allTasks == null || allTasks.length == 0) {
            return null;
        }
        IMarker[] validatorMessages = new IMarker[allTasks.length];
        int count = 0;
        int i = 0;
        while (i < allTasks.length) {
            IMarker marker = allTasks[i];
            if (!this.isLimitMessage(marker)) {
                validatorMessages[count++] = marker;
            }
            ++i;
        }
        IMarker[] result = new IMarker[count];
        System.arraycopy(validatorMessages, 0, result, 0, count);
        return result;
    }

    public boolean removeMessageLimitExceeded(IProject project) {
        block3: {
            IMarker[] exceededMessage = this.getLimitMessage(project);
            if (exceededMessage != null) {
                try {
                    ResourcesPlugin.getWorkspace().deleteMarkers(exceededMessage);
                    return true;
                }
                catch (CoreException exc) {
                    Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                    if (!logger.isLoggingLevel(Level.SEVERE)) break block3;
                    LogEntry entry = ValidationPlugin.getLogEntry();
                    entry.setSourceID("ValidatorManager.removeMessageLimitExceeded(" + project.getName() + ")");
                    entry.setTargetException((Throwable)exc);
                    logger.write(Level.SEVERE, (Object)entry);
                }
            }
        }
        return false;
    }

    public boolean wasValidationTerminated(IProject project) {
        IMarker[] exceededMessage = this.getLimitMessage(project);
        return exceededMessage != null;
    }

    private Class getMessageLimitOwner() {
        if (_messageLimitOwner == null) {
            _messageLimitOwner = this.getClass();
        }
        return _messageLimitOwner;
    }

    public boolean isInternalOwner(String owner) {
        if (owner == null) {
            return false;
        }
        int i = 0;
        while (i < this._internalOwners.length) {
            String internalOwner = this._internalOwners[i];
            if (owner.equals(internalOwner)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addInternalOwner(Class clazz) {
        if (clazz == null) {
            return;
        }
        String[] tempInternalOwners = new String[this._internalOwners.length + 1];
        if (this._internalOwners.length > 0) {
            System.arraycopy(this._internalOwners, 0, tempInternalOwners, 0, this._internalOwners.length);
        }
        tempInternalOwners[this._internalOwners.length] = WorkbenchReporter.getUniqueId(clazz);
        this._internalOwners = tempInternalOwners;
    }

    public void addMessageLimitExceeded(IProject project, Iterator iterator) {
        this.addMessageLimitExceeded(project);
    }

    public void addMessageLimitExceeded(IProject project) {
        IMarker[] exceededMessage = this.getLimitMessage(project);
        if (exceededMessage == null) {
            Message message = new Message("validate_base", 4, "VBF_TASK_WARN_MESSAGE_LIMIT_VAL");
            WorkbenchReporter.addMessage((IResource)project, this.getMessageLimitOwner(), message);
        }
    }
}

