/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.outline;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.ui.views.contentoutline.ContentOutlineConfiguration;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditor;
import org.eclipse.wst.wsdl.ui.internal.actions.WSDLMenuListener;
import org.eclipse.wst.wsdl.ui.internal.outline.ExtensibleOutlineProvider;
import org.eclipse.wst.wsdl.ui.internal.text.WSDLModelAdapter;
import org.eclipse.wst.wsdl.ui.internal.util.OpenOnSelectionHelper;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSDLContentOutlineConfiguration
extends ContentOutlineConfiguration {
    private ExtensibleOutlineProvider fOutlineProvider = null;
    private KeyListener[] fKeyListeners = null;
    private IMenuListener fMenuListener = null;
    private WSDLEditor fEditor = null;
    static /* synthetic */ Class class$0;

    private ExtensibleOutlineProvider getOutlineProvider() {
        if (this.fOutlineProvider == null) {
            this.fOutlineProvider = new ExtensibleOutlineProvider(this.getWSDLEditor());
        }
        return this.fOutlineProvider;
    }

    public IContentProvider getContentProvider(TreeViewer viewer) {
        return this.getOutlineProvider();
    }

    public ILabelProvider getLabelProvider(TreeViewer viewer) {
        return this.getOutlineProvider();
    }

    public KeyListener[] getKeyListeners(TreeViewer viewer) {
        if (this.fKeyListeners == null) {
            final TreeViewer finalViewer = viewer;
            KeyAdapter keyListener = new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    Object object;
                    ISelection selection;
                    if (e.keyCode == 0x100000C && WSDLContentOutlineConfiguration.this.getWSDLEditor() != null && (selection = WSDLContentOutlineConfiguration.this.getWSDLEditor().getSelectionManager().getSelection()) instanceof IStructuredSelection && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof EObject) {
                        OpenOnSelectionHelper helper = new OpenOnSelectionHelper(WSDLContentOutlineConfiguration.this.getDefinition(finalViewer));
                        helper.openEditor((EObject)object);
                    }
                }
            };
            this.fKeyListeners = new KeyListener[]{keyListener};
        }
        return this.fKeyListeners;
    }

    public IMenuListener getMenuListener(TreeViewer viewer) {
        if (this.fMenuListener == null && this.getWSDLEditor() != null) {
            this.fMenuListener = new WSDLMenuListener(this.getWSDLEditor(), this.getWSDLEditor().getSelectionManager());
        }
        return this.fMenuListener;
    }

    public ISelection getSelection(TreeViewer viewer, ISelection selection) {
        ISelection sel = selection;
        if (selection instanceof IStructuredSelection) {
            ArrayList<Object> wsdlSelections = new ArrayList<Object>();
            Iterator i = ((IStructuredSelection)selection).iterator();
            while (i.hasNext()) {
                Object domNode = i.next();
                Object wsdlNode = this.getWSDLNode(domNode, viewer);
                if (wsdlNode == null) continue;
                wsdlSelections.add(wsdlNode);
            }
            if (!wsdlSelections.isEmpty()) {
                sel = new StructuredSelection(wsdlSelections);
            }
        }
        return sel;
    }

    private Definition getDefinition(TreeViewer viewer) {
        IDOMDocument domDoc;
        Definition definition = null;
        Object model = null;
        if (viewer != null) {
            model = viewer.getInput();
        }
        if (model instanceof IDOMModel && (domDoc = ((IDOMModel)model).getDocument()) != null) {
            WSDLModelAdapter modelAdapter;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.wsdl.ui.internal.text.WSDLModelAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((modelAdapter = (WSDLModelAdapter)domDoc.getAdapterFor((Object)clazz)) == null) {
                modelAdapter = new WSDLModelAdapter();
                domDoc.addAdapter((INodeAdapter)modelAdapter);
                modelAdapter.createDefinition(domDoc.getDocumentElement(), (Document)domDoc);
            }
            definition = modelAdapter.getDefinition();
        }
        return definition;
    }

    private WSDLEditor getWSDLEditor() {
        IEditorPart editor;
        IWorkbenchPage page;
        IWorkbenchWindow window;
        IWorkbench workbench;
        if (this.fEditor == null && (workbench = PlatformUI.getWorkbench()) != null && (window = workbench.getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null && (editor = page.getActiveEditor()) instanceof WSDLEditor) {
            this.fEditor = (WSDLEditor)editor;
        }
        return this.fEditor;
    }

    public void unconfigure(TreeViewer viewer) {
        super.unconfigure(viewer);
        this.fEditor = null;
    }

    private Object getWSDLNode(Object object, TreeViewer viewer) {
        Object modelObject;
        Node node;
        Element element = null;
        if (object instanceof Node && (node = (Node)object) != null) {
            if (node.getNodeType() == 1) {
                element = (Element)node;
            } else if (node.getNodeType() == 2) {
                element = ((Attr)node).getOwnerElement();
            }
        }
        Object o = element;
        if (element != null && (modelObject = WSDLEditorUtil.getInstance().findModelObjectForElement(this.getDefinition(viewer), element)) != null) {
            o = modelObject;
        }
        return o;
    }
}

