/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.typesystem;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.extension.ITypeSystemProvider;
import org.eclipse.wst.wsdl.ui.internal.extension.WSDLEditorExtension;
import org.eclipse.wst.wsdl.ui.internal.extension.WSDLEditorExtensionRegistry;
import org.eclipse.xsd.XSDSchema;

public class ExtensibleTypeSystemProvider
implements ITypeSystemProvider {
    protected WSDLEditorExtension[] extensions;
    protected ITypeSystemProvider[] typeSystemProviders;
    protected static final Object[] EMPTY_ARRAY = new Object[0];

    public ExtensibleTypeSystemProvider() {
        WSDLEditorExtensionRegistry registry = WSDLEditorPlugin.getInstance().getWSDLEditorExtensionRegistry();
        this.extensions = registry.getRegisteredExtensions(6);
        this.typeSystemProviders = new ITypeSystemProvider[this.extensions.length];
        int i = 0;
        while (i < this.extensions.length) {
            this.typeSystemProviders[i] = (ITypeSystemProvider)this.extensions[i].createExtensionObject(6, null);
            ++i;
        }
    }

    public List getAvailableTypeNames(Definition definition, int typeNameCategory) {
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < this.typeSystemProviders.length) {
            list.addAll(this.typeSystemProviders[i].getAvailableTypeNames(definition, typeNameCategory));
            ++i;
        }
        return list;
    }

    public List getAvailableTypes(Definition definition, XSDSchema schema, int typeNameCategory) {
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < this.typeSystemProviders.length) {
            list.addAll(this.typeSystemProviders[i].getAvailableTypes(definition, schema, typeNameCategory));
            ++i;
        }
        return list;
    }

    public List getAvailableElementNames(Definition definition) {
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < this.typeSystemProviders.length) {
            list.addAll(this.typeSystemProviders[i].getAvailableElementNames(definition));
            ++i;
        }
        return list;
    }

    public int getCategoryForTypeName(Definition definition, String typeName) {
        int result = 0;
        int i = 0;
        while (i < this.typeSystemProviders.length) {
            result = this.typeSystemProviders[i].getCategoryForTypeName(definition, typeName);
            if (result != 0) break;
            ++i;
        }
        return result;
    }

    public List getPrefixedNames(Definition definition, String namespace, String localName) {
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < this.typeSystemProviders.length) {
            list.addAll(this.typeSystemProviders[i].getPrefixedNames(definition, namespace, localName));
            ++i;
        }
        return list;
    }
}

