/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ExtensibleElement;
import org.eclipse.wst.wsdl.MessageReference;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.ui.internal.extension.ITypeSystemProvider;
import org.eclipse.wst.wsdl.ui.internal.typesystem.ExtensibleTypeSystemProvider;
import org.eclipse.wst.wsdl.ui.internal.util.NodeAssociationManager;
import org.eclipse.wst.wsdl.util.WSDLConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSDLEditorUtil
extends WSDLConstants {
    protected static WSDLEditorUtil instance;
    protected NodeAssociationManager nodeAssociationManager = new NodeAssociationManager();
    protected HashMap elementNameToTypeMap = new HashMap();
    public static final int ELEMENT = 14;
    public static final int TYPE = 15;
    private Hashtable typeSystemProviders = new Hashtable();
    private ITypeSystemProvider typeSystemProvider;

    public static WSDLEditorUtil getInstance() {
        if (instance == null) {
            instance = new WSDLEditorUtil();
        }
        return instance;
    }

    public WSDLEditorUtil() {
        this.elementNameToTypeMap.put("binding", new Integer(0));
        this.elementNameToTypeMap.put("definitions", new Integer(1));
        this.elementNameToTypeMap.put("documentation", new Integer(2));
        this.elementNameToTypeMap.put("fault", new Integer(3));
        this.elementNameToTypeMap.put("import", new Integer(4));
        this.elementNameToTypeMap.put("input", new Integer(5));
        this.elementNameToTypeMap.put("message", new Integer(6));
        this.elementNameToTypeMap.put("operation", new Integer(7));
        this.elementNameToTypeMap.put("output", new Integer(8));
        this.elementNameToTypeMap.put("part", new Integer(9));
        this.elementNameToTypeMap.put("port", new Integer(10));
        this.elementNameToTypeMap.put("portType", new Integer(11));
        this.elementNameToTypeMap.put("service", new Integer(12));
        this.elementNameToTypeMap.put("types", new Integer(13));
    }

    public int getWSDLType(Element element) {
        int result = -1;
        Integer integer = (Integer)this.elementNameToTypeMap.get(element.getLocalName());
        if (integer != null) {
            result = integer;
        }
        return result;
    }

    protected List getParentElementChain(Element element) {
        ArrayList<Element> list = new ArrayList<Element>();
        while (element != null) {
            list.add(0, element);
            Node node = element.getParentNode();
            Element element2 = element = node != null && node.getNodeType() == 1 ? (Element)node : null;
        }
        return list;
    }

    public Object findModelObjectForElement(Definition definition, Element targetElement) {
        Object o = this.nodeAssociationManager.getModelObjectForNode(definition, targetElement);
        return o;
    }

    public Element getElementForObject(Object o) {
        return ((WSDLElement)o).getElement();
    }

    public Node getNodeForObject(Object o) {
        return this.nodeAssociationManager.getNode(o);
    }

    public ITypeSystemProvider getTypeSystemProvider(Definition definition) {
        if (this.typeSystemProvider == null) {
            this.typeSystemProvider = new ExtensibleTypeSystemProvider();
        }
        return this.typeSystemProvider;
    }

    public void setTypeSystemProvider(Definition definition, ITypeSystemProvider typeSystemProvider) {
    }

    public static QName createQName(Definition definition, String prefixedName) {
        QName qname = null;
        if (prefixedName != null) {
            String namespace;
            String prefix;
            int index = prefixedName.indexOf(":");
            String string = prefix = index == -1 ? null : prefixedName.substring(0, index);
            if (prefix != null && (namespace = definition.getNamespace(prefix)) != null) {
                String localPart = prefixedName.substring(index + 1);
                qname = new QName(namespace, localPart);
            }
        }
        return qname;
    }

    public List getExtensibilityElementNodes(ExtensibleElement extensibleElement) {
        if (extensibleElement instanceof Types) {
            Types xsdEE = (Types)extensibleElement;
            return xsdEE.getSchemas();
        }
        return extensibleElement.getEExtensibilityElements();
    }

    public static List getModelGraphViewChildren(Object object) {
        ArrayList<Object> childList = new ArrayList<Object>();
        if (object instanceof PortType) {
            PortType portType = (PortType)object;
            childList.addAll(portType.getOperations());
        } else if (object instanceof Operation) {
            Operation operation = (Operation)object;
            if (operation.getEInput() != null) {
                childList.add(operation.getEInput());
            }
            if (operation.getEOutput() != null) {
                childList.add(operation.getEOutput());
            }
            childList.addAll(operation.getFaults().values());
        } else if (object instanceof MessageReference) {
            MessageReference messageReference = (MessageReference)object;
            childList.add(messageReference.getEMessage());
        }
        return childList;
    }
}

