/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.wst.xsd.ui.internal.XSDEditor;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.actions.AddEnumsAction;
import org.eclipse.wst.xsd.ui.internal.actions.AddModelGroupAction;
import org.eclipse.wst.xsd.ui.internal.actions.BackAction;
import org.eclipse.wst.xsd.ui.internal.actions.CreateAnnotationAction;
import org.eclipse.wst.xsd.ui.internal.actions.CreateElementAction;
import org.eclipse.wst.xsd.ui.internal.actions.CreateGroupAction;
import org.eclipse.wst.xsd.ui.internal.actions.CreateIdentityConstraintsAction;
import org.eclipse.wst.xsd.ui.internal.actions.CreateLocalComplexTypeAction;
import org.eclipse.wst.xsd.ui.internal.actions.CreateLocalSimpleTypeAction;
import org.eclipse.wst.xsd.ui.internal.actions.CreateSimpleContentAction;
import org.eclipse.wst.xsd.ui.internal.actions.CreateSimpleTypeAction;
import org.eclipse.wst.xsd.ui.internal.actions.DOMAttribute;
import org.eclipse.wst.xsd.ui.internal.actions.DeleteAction;
import org.eclipse.wst.xsd.ui.internal.actions.OpenSchemaAction;
import org.eclipse.wst.xsd.ui.internal.actions.SetBaseTypeAction;
import org.eclipse.wst.xsd.ui.internal.actions.SetMultiplicityAction;
import org.eclipse.wst.xsd.ui.internal.actions.SetTypeAction;
import org.eclipse.wst.xsd.ui.internal.actions.XSDEditNamespacesAction;
import org.eclipse.wst.xsd.ui.internal.graph.model.Category;
import org.eclipse.wst.xsd.ui.internal.provider.CategoryAdapter;
import org.eclipse.wst.xsd.ui.internal.refactor.actions.RefactorActionGroup;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XSDMenuListener
implements IMenuListener {
    protected ISelectionProvider selectionProvider;
    protected DeleteAction deleteAction;
    protected CreateElementAction addComplexTypeAction;
    protected XSDSchema xsdSchema;
    protected boolean isReadOnly;
    protected Object sourceContext;
    private RefactorActionGroup fRefactorMenuGroup;
    static /* synthetic */ Class class$0;

    public XSDMenuListener(ISelectionProvider selectionProvider) {
        this.selectionProvider = selectionProvider;
        this.deleteAction = new DeleteAction(XSDEditorPlugin.getXSDString("_UI_ACTION_DELETE"), null, this.getXSDSchema());
        this.deleteAction.setSelectionProvider(selectionProvider);
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.deleteAction);
    }

    public void setSourceContext(Object sourceContext) {
        this.sourceContext = sourceContext;
    }

    public void setSelectionProvider(ISelectionProvider selectionProvider) {
        this.selectionProvider = selectionProvider;
    }

    protected XSDSchema getXSDSchema() {
        return this.xsdSchema;
    }

    protected Object getSelectedElement() {
        ISelection selection = this.selectionProvider.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return ((IStructuredSelection)selection).getFirstElement();
    }

    protected boolean isSchemaReadOnly() {
        XSDSchema editorSchema = ((XSDEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()).getXSDSchema();
        return editorSchema != this.xsdSchema;
    }

    protected XSDSchema getCurrentSchemaInEditor() {
        return ((XSDEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()).getXSDSchema();
    }

    protected void updateXSDSchema() {
        this.isReadOnly = false;
        Object object = this.getSelectedElement();
        if (object instanceof XSDConcreteComponent) {
            this.xsdSchema = ((XSDConcreteComponent)object).getSchema();
            this.isReadOnly = this.isSchemaReadOnly();
        } else if (object instanceof Category) {
            Category cg = (Category)object;
            this.xsdSchema = cg.getXSDSchema();
        } else if (object instanceof CategoryAdapter) {
            CategoryAdapter category = (CategoryAdapter)object;
            this.xsdSchema = category.getXSDSchema();
        }
    }

    public void menuAboutToShow(IMenuManager manager) {
        this.isReadOnly = false;
        this.updateXSDSchema();
        if (this.xsdSchema == null) {
            manager.add((IContributionItem)new Separator("additions"));
            return;
        }
        this.deleteAction.setXSDSchema(this.xsdSchema);
        this.deleteAction.setEnabled(!this.isReadOnly);
        BackAction backAction = new BackAction(XSDEditorPlugin.getXSDString("_UI_ACTION_BACK_TO_SCHEMA_VIEW"));
        backAction.setXSDSchema(this.getCurrentSchemaInEditor());
        backAction.setSelectionProvider(this.selectionProvider);
        Object selectedElementObj = this.getSelectedElement();
        if (selectedElementObj instanceof XSDSchema || selectedElementObj instanceof Category || selectedElementObj instanceof CategoryAdapter) {
            backAction.setEnabled(false);
        }
        manager.add((IAction)backAction);
        manager.add((IContributionItem)new Separator());
        Element selectedElement = null;
        if (selectedElementObj instanceof Element) {
            selectedElement = (Element)selectedElementObj;
        } else if (selectedElementObj instanceof XSDConcreteComponent) {
            selectedElement = ((XSDConcreteComponent)selectedElementObj).getElement();
        } else if (selectedElementObj instanceof Category || selectedElementObj instanceof CategoryAdapter) {
            int groupType = -1;
            if (selectedElementObj instanceof Category) {
                Category category = (Category)selectedElementObj;
                groupType = category.getGroupType();
            } else if (selectedElementObj instanceof CategoryAdapter) {
                CategoryAdapter categoryAdapter = (CategoryAdapter)selectedElementObj;
                groupType = categoryAdapter.getGroupType();
            }
            ArrayList<DOMAttribute> attributes = null;
            Element parent = this.getXSDSchema().getElement();
            if (parent == null) {
                return;
            }
            Node relativeNode = null;
            switch (groupType) {
                case 3: {
                    attributes = new ArrayList<DOMAttribute>();
                    attributes.add(new DOMAttribute("name", this.getNewGlobalTypeName("ComplexType")));
                    Action action = this.addCreateElementAction(manager, "complexType", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_COMPLEX_TYPE"), attributes, parent, relativeNode);
                    ((CreateElementAction)action).setIsGlobal(true);
                    attributes = new ArrayList();
                    attributes.add(new DOMAttribute("name", this.getNewGlobalTypeName("SimpleType")));
                    Action action2 = this.addCreateSimpleTypeAction(manager, "simpleType", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_SIMPLE_TYPE"), attributes, parent, relativeNode);
                    ((CreateElementAction)action2).setIsGlobal(true);
                    break;
                }
                case 2: {
                    attributes = new ArrayList();
                    attributes.add(new DOMAttribute("name", this.getNewGlobalName("element", "GlobalElement")));
                    attributes.add(new DOMAttribute("type", this.getBuiltInStringQName()));
                    Action action = this.addCreateElementAction(manager, "element", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ELEMENT"), attributes, parent, relativeNode);
                    ((CreateElementAction)action).setIsGlobal(true);
                    break;
                }
                case 5: {
                    attributes = new ArrayList();
                    attributes.add(new DOMAttribute("name", this.getNewGlobalName("group", "Group")));
                    CreateGroupAction groupAction = this.addCreateGroupAction(manager, "group", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_GROUP"), attributes, parent, relativeNode);
                    groupAction.setIsGlobal(true);
                    break;
                }
                case 1: {
                    attributes = new ArrayList();
                    attributes.add(new DOMAttribute("name", this.getNewGlobalName("attribute", "GlobalAttribute")));
                    attributes.add(new DOMAttribute("type", this.getBuiltInStringQName()));
                    Action action = this.addCreateElementAction(manager, "attribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_GLOBAL_ATTRIBUTE"), attributes, parent, relativeNode);
                    ((CreateElementAction)action).setIsGlobal(true);
                    break;
                }
                case 8: {
                    attributes = new ArrayList();
                    attributes.add(new DOMAttribute("name", this.getNewGlobalName("attributeGroup", "AttributeGroup")));
                    Action action = this.addCreateElementAction(manager, "attributeGroup", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE_GROUP"), attributes, parent, relativeNode);
                    ((CreateElementAction)action).setIsGlobal(true);
                    break;
                }
                case 7: {
                    attributes = new ArrayList();
                    attributes.add(new DOMAttribute("name", this.getNewGlobalName("notation", "Notation")));
                    attributes.add(new DOMAttribute("public", ""));
                    Action action = this.addCreateElementAction(manager, "notation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_NOTATION"), attributes, parent, relativeNode);
                    ((CreateElementAction)action).setIsGlobal(true);
                    break;
                }
                case 6: {
                    boolean b = true;
                    NodeList children = parent.getChildNodes();
                    int length = children.getLength();
                    Node effectiveRelativeNode = parent.getFirstChild();
                    int i = 0;
                    while (i < length && b) {
                        Node child = children.item(i);
                        if (child != null && child instanceof Element) {
                            if (XSDDOMHelper.inputEquals((Element)child, "include", false) || XSDDOMHelper.inputEquals((Element)child, "import", false) || XSDDOMHelper.inputEquals((Element)child, "redefine", false) || XSDDOMHelper.inputEquals((Element)child, "annotation", false)) {
                                effectiveRelativeNode = child;
                            } else {
                                b = false;
                            }
                        }
                        ++i;
                    }
                    relativeNode = effectiveRelativeNode != null ? XSDDOMHelper.getNextElementNode(effectiveRelativeNode) : null;
                    attributes = new ArrayList();
                    attributes.add(new DOMAttribute("schemaLocation", ""));
                    Action action = this.addCreateElementAction(manager, "include", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_INCLUDE"), attributes, parent, relativeNode);
                    ((CreateElementAction)action).setIsGlobal(true);
                    action = this.addCreateElementAction(manager, "import", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_IMPORT"), null, parent, relativeNode);
                    ((CreateElementAction)action).setIsGlobal(true);
                    action = this.addCreateElementAction(manager, "redefine", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_REDEFINE"), attributes, parent, relativeNode);
                    ((CreateElementAction)action).setIsGlobal(true);
                    break;
                }
                case 10: {
                    Action action = this.addCreateElementAction(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), null, parent, relativeNode);
                    ((CreateElementAction)action).setIsGlobal(true);
                }
            }
            manager.add((IContributionItem)new Separator("additions"));
            return;
        }
        if (selectedElement != null) {
            this.addContextItems(manager, selectedElement, null);
            manager.add((IContributionItem)new Separator());
        }
        manager.add((IContributionItem)new Separator());
        if (this.deleteAction != null) {
            manager.add((IAction)this.deleteAction);
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    protected String getBuiltInStringQName() {
        String prefix;
        String schemaForSchemaPrefix;
        String stringName = "string";
        if (this.getXSDSchema() != null && (schemaForSchemaPrefix = this.getXSDSchema().getSchemaForSchemaQNamePrefix()) != null && schemaForSchemaPrefix.length() > 0 && (prefix = this.getXSDSchema().getSchemaForSchemaQNamePrefix()) != null && prefix.length() > 0) {
            stringName = String.valueOf(prefix) + ":" + stringName;
        }
        return stringName;
    }

    protected void addContextItems(IMenuManager manager, Element parent, Node relativeNode) {
        XSDConcreteComponent xsdConcreteComponent;
        ArrayList<DOMAttribute> attributes = null;
        if (XSDDOMHelper.inputEquals(parent, "schema", false)) {
            this.addSchemaElementItems(manager, parent, relativeNode);
            manager.add((IContributionItem)new Separator());
            boolean b = true;
            NodeList children = parent.getChildNodes();
            Node effectiveRelativeNode = parent.getFirstChild();
            int i = 0;
            while (i < children.getLength() && b) {
                Node child = children.item(i);
                if (child != null && child instanceof Element) {
                    if (XSDDOMHelper.inputEquals((Element)child, "include", false) || XSDDOMHelper.inputEquals((Element)child, "import", false) || XSDDOMHelper.inputEquals((Element)child, "redefine", false) || XSDDOMHelper.inputEquals((Element)child, "annotation", false)) {
                        effectiveRelativeNode = child;
                    } else {
                        b = false;
                    }
                }
                ++i;
            }
            relativeNode = effectiveRelativeNode != null ? effectiveRelativeNode.getNextSibling() : null;
            attributes = new ArrayList<DOMAttribute>();
            attributes.add(new DOMAttribute("schemaLocation", ""));
            this.addCreateElementAction(manager, "include", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_INCLUDE"), attributes, parent, relativeNode);
            this.addCreateElementAction(manager, "import", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_IMPORT"), null, parent, relativeNode);
            this.addCreateElementAction(manager, "redefine", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_REDEFINE"), attributes, parent, relativeNode);
            attributes = null;
            this.addCreateAnnotationAction(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), null, parent, relativeNode);
        } else if (XSDDOMHelper.inputEquals(parent, "annotation", false)) {
            this.addCreateElementAction(manager, "documentation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_DOC"), attributes, parent, null);
            this.addCreateElementAction(manager, "appinfo", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_APP_INFO"), attributes, parent, null);
        } else if (XSDDOMHelper.inputEquals(parent, "element", false)) {
            XSDDOMHelper domHelper;
            Element anonymousType;
            XSDConcreteComponent concreteComponent = this.getXSDSchema().getCorrespondingComponent((Node)parent);
            Element parentNode = (Element)parent.getParentNode();
            boolean isGlobalElement = false;
            if (XSDDOMHelper.inputEquals(parentNode, "schema", false)) {
                isGlobalElement = true;
            }
            boolean annotationExists = this.addCreateAnnotationActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
            boolean simpleTypeExists = this.elementExists("simpleType", parent);
            boolean complexTypeExists = this.elementExists("complexType", parent);
            manager.add((IContributionItem)new Separator());
            if (annotationExists) {
                Node annotationNode = this.getFirstChildNodeIfExists(parent, "annotation", false);
                if (!simpleTypeExists && !complexTypeExists && annotationNode != null) {
                    manager.add((IContributionItem)new Separator());
                }
            } else if (concreteComponent != null) {
                AddModelGroupAction addModelGroupAction = new AddModelGroupAction(concreteComponent, XSDCompositor.SEQUENCE_LITERAL);
                addModelGroupAction.setEnabled(!this.isReadOnly);
                manager.add((IAction)addModelGroupAction);
                addModelGroupAction = new AddModelGroupAction(concreteComponent, XSDCompositor.CHOICE_LITERAL);
                addModelGroupAction.setEnabled(!this.isReadOnly);
                manager.add((IAction)addModelGroupAction);
                addModelGroupAction = new AddModelGroupAction(concreteComponent, XSDCompositor.ALL_LITERAL);
                addModelGroupAction.setEnabled(!this.isReadOnly);
                manager.add((IAction)addModelGroupAction);
                manager.add((IContributionItem)new Separator());
            }
            if ((anonymousType = (Element)(domHelper = new XSDDOMHelper()).getChildNode(parent, "complexType")) != null) {
                manager.add((IContributionItem)new Separator());
                attributes = new ArrayList();
                attributes.add(new DOMAttribute("name", this.getNewGlobalTypeName("ComplexType")));
                this.addMoveAnonymousGlobal(manager, "complexType", XSDEditorPlugin.getXSDString("_UI_ACTION_MAKE_ANONYMOUS_TYPE_GLOBAL"), attributes, anonymousType, null);
                attributes = null;
            }
            if ((anonymousType = (Element)domHelper.getChildNode(parent, "simpleType")) != null) {
                manager.add((IContributionItem)new Separator());
                attributes = new ArrayList();
                attributes.add(new DOMAttribute("name", this.getNewGlobalTypeName("SimpleType")));
                this.addMoveAnonymousGlobal(manager, "simpleType", XSDEditorPlugin.getXSDString("_UI_ACTION_MAKE_ANONYMOUS_TYPE_GLOBAL"), attributes, anonymousType, null);
                attributes = null;
            }
            manager.add((IContributionItem)new Separator());
            MenuManager setTypeCascadeMenu = new MenuManager(XSDEditorPlugin.getXSDString("_UI_LABEL_SET_TYPE"));
            manager.add((IContributionItem)setTypeCascadeMenu);
            String string = XSDEditorPlugin.getXSDString("_UI_LABEL_NEW_COMPLEX_TYPE");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            SetTypeAction setNewComplexTypeAction = new SetTypeAction(string, ImageDescriptor.createFromFile((Class)clazz, (String)"icons/XSDComplexType.gif"), concreteComponent);
            setNewComplexTypeAction.setTypeKind(9);
            setNewComplexTypeAction.setEnabled(!this.isReadOnly);
            setTypeCascadeMenu.add((IAction)setNewComplexTypeAction);
            String string2 = XSDEditorPlugin.getXSDString("_UI_LABEL_NEW_SIMPLE_TYPE");
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            SetTypeAction setNewSimpleTypeAction = new SetTypeAction(string2, ImageDescriptor.createFromFile((Class)clazz2, (String)"icons/XSDSimpleType.gif"), concreteComponent);
            setNewSimpleTypeAction.setTypeKind(37);
            setNewSimpleTypeAction.setEnabled(!this.isReadOnly);
            setTypeCascadeMenu.add((IAction)setNewSimpleTypeAction);
            SetTypeAction setExistingTypeAction = new SetTypeAction(XSDEditorPlugin.getXSDString("_UI_LABEL_SET_EXISTING_TYPE"), concreteComponent);
            setExistingTypeAction.setTypeKind(0);
            setExistingTypeAction.setEnabled(!this.isReadOnly);
            setTypeCascadeMenu.add((IAction)setExistingTypeAction);
            manager.add((IContributionItem)new Separator());
            if (!isGlobalElement) {
                this.addMultiplicityMenu(concreteComponent, manager);
            }
        } else if (XSDDOMHelper.inputEquals(parent, "sequence", false) || XSDDOMHelper.inputEquals(parent, "choice", false)) {
            XSDConcreteComponent concreteComponent = this.getXSDSchema().getCorrespondingComponent((Node)parent);
            this.addCreateAnnotationActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
            manager.add((IContributionItem)new Separator());
            this.addCreateElementAction(manager, "choice", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_CHOICE"), attributes, parent, null);
            this.addCreateElementAction(manager, "sequence", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_SEQUENCE"), attributes, parent, null);
            this.addCreateElementRefAction(manager, "group", XSDEditorPlugin.getXSDString("_UI_ADD_GROUP_REF"), parent, null);
            manager.add((IContributionItem)new Separator());
            attributes = new ArrayList();
            attributes.add(new DOMAttribute("name", this.getNewName(parent, "element", "Element", false)));
            attributes.add(new DOMAttribute("type", this.getBuiltInStringQName()));
            this.addCreateElementAction(manager, "element", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ELEMENT"), attributes, parent, null);
            this.addCreateElementRefAction(manager, "element", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ELEMENT_REF"), parent, null);
            manager.add((IContributionItem)new Separator());
            attributes = null;
            this.addCreateElementAction(manager, "any", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANY_ELEMENT"), attributes, parent, null);
            if (concreteComponent.getContainer() instanceof XSDParticle) {
                this.addMultiplicityMenu(concreteComponent, manager);
            }
        } else if (XSDDOMHelper.inputEquals(parent, "all", false)) {
            XSDConcreteComponent concreteComponent = this.getXSDSchema().getCorrespondingComponent((Node)parent);
            this.addCreateAnnotationActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
            manager.add((IContributionItem)new Separator());
            attributes = new ArrayList();
            attributes.add(new DOMAttribute("name", this.getNewName(parent, "element", "Element", false)));
            attributes.add(new DOMAttribute("type", this.getBuiltInStringQName()));
            this.addCreateElementAction(manager, "element", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ELEMENT"), attributes, parent, null);
            this.addCreateElementRefAction(manager, "element", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ELEMENT_REF"), parent, null);
            if (concreteComponent.getContainer() instanceof XSDParticle) {
                this.addMultiplicityMenu(concreteComponent, manager);
            }
        } else if (XSDDOMHelper.inputEquals(parent, "attributeGroup", false)) {
            this.addCreateAnnotationActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
            boolean anyAttributeExists = this.elementExists("anyAttribute", parent);
            Node anyAttributeNode = null;
            manager.add((IContributionItem)new Separator());
            if (anyAttributeExists) {
                anyAttributeNode = this.getFirstChildNodeIfExists(parent, "anyAttribute", false);
                attributes = new ArrayList();
                attributes.add(new DOMAttribute("name", this.getNewName(parent, "attribute", "Attribute", false)));
                attributes.add(new DOMAttribute("type", this.getBuiltInStringQName()));
                this.addCreateElementAction(manager, "attribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE"), attributes, parent, anyAttributeNode);
                attributes = null;
                this.addCreateElementRefAction(manager, "attribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE_REFERENCE"), parent, anyAttributeNode);
                this.addCreateElementRefAction(manager, "attributeGroup", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE_GROUP_REF"), parent, anyAttributeNode);
            } else {
                attributes = new ArrayList();
                attributes.add(new DOMAttribute("name", this.getNewName(parent, "attribute", "Attribute", false)));
                attributes.add(new DOMAttribute("type", this.getBuiltInStringQName()));
                this.addCreateElementAction(manager, "attribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE"), attributes, parent, parent.getLastChild());
                attributes = null;
                this.addCreateElementRefAction(manager, "attribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE_REFERENCE"), parent, parent.getLastChild());
                this.addCreateElementRefAction(manager, "attributeGroup", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE_GROUP_REF"), parent, parent.getLastChild());
            }
            attributes = null;
            this.addCreateElementActionIfNotExist(manager, "anyAttribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANY_ATTRIBUTE"), attributes, parent, null);
        } else if (XSDDOMHelper.inputEquals(parent, "notation", false)) {
            this.addCreateAnnotationActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, null);
        } else if (XSDDOMHelper.inputEquals(parent, "simpleType", false)) {
            this.addCreateAnnotationActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
            boolean restrictionExists = this.elementExists("restriction", parent);
            boolean unionExists = this.elementExists("union", parent);
            boolean listExists = this.elementExists("list", parent);
            if (!(restrictionExists || unionExists || listExists)) {
                attributes = new ArrayList();
                attributes.add(new DOMAttribute("base", this.getBuiltInStringQName()));
                this.addCreateElementActionIfNotExist(manager, "restriction", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_RESTRICTION"), attributes, parent, null);
                attributes = null;
                attributes = new ArrayList();
                attributes.add(new DOMAttribute("memberTypes", this.getBuiltInStringQName()));
                this.addCreateElementActionIfNotExist(manager, "union", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_UNION"), attributes, parent, null);
                attributes = null;
                attributes = new ArrayList();
                attributes.add(new DOMAttribute("itemType", this.getBuiltInStringQName()));
                this.addCreateElementActionIfNotExist(manager, "list", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_LIST"), attributes, parent, null);
                attributes = null;
            }
            if (XSDDOMHelper.inputEquals(parent.getParentNode(), "element", false)) {
                manager.add((IContributionItem)new Separator());
                attributes = new ArrayList();
                attributes.add(new DOMAttribute("name", this.getNewGlobalTypeName("SimpleType")));
                this.addMoveAnonymousGlobal(manager, "simpleType", XSDEditorPlugin.getXSDString("_UI_ACTION_MAKE_ANONYMOUS_TYPE_GLOBAL"), attributes, parent, null);
                attributes = null;
            }
        } else if (XSDDOMHelper.inputEquals(parent, "group", false)) {
            this.addCreateAnnotationActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
            this.addCreateElementActionIfNotExist(manager, "sequence", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_CONTENT_MODEL"), attributes, parent, null);
        } else if (XSDDOMHelper.inputEquals(parent, "complexType", false)) {
            AddModelGroupAction addModelGroupAction;
            boolean annotationExists = false;
            boolean contentExists = false;
            Node annotationNode = null;
            NodeList children = parent.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child != null && child instanceof Element) {
                    if (XSDDOMHelper.inputEquals((Element)child, "annotation", false)) {
                        annotationNode = child;
                        annotationExists = true;
                    } else if (XSDDOMHelper.inputEquals((Element)child, "sequence", false) || XSDDOMHelper.inputEquals((Element)child, "all", false) || XSDDOMHelper.inputEquals((Element)child, "choice", false) || XSDDOMHelper.inputEquals((Element)child, "group", true) || XSDDOMHelper.inputEquals((Element)child, "simpleContent", false) || XSDDOMHelper.inputEquals((Element)child, "complexContent", false)) {
                        contentExists = true;
                    }
                }
                ++i;
            }
            this.addCreateAnnotationActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
            manager.add((IContributionItem)new Separator());
            this.addSetBaseTypeAction(manager, parent);
            XSDConcreteComponent concreteComponent = this.getXSDSchema().getCorrespondingComponent((Node)parent);
            if (annotationExists) {
                if (!contentExists) {
                    if (concreteComponent != null) {
                        addModelGroupAction = new AddModelGroupAction(concreteComponent, XSDCompositor.SEQUENCE_LITERAL);
                        addModelGroupAction.setEnabled(!this.isReadOnly);
                        manager.add((IAction)addModelGroupAction);
                        addModelGroupAction = new AddModelGroupAction(concreteComponent, XSDCompositor.CHOICE_LITERAL);
                        addModelGroupAction.setEnabled(!this.isReadOnly);
                        manager.add((IAction)addModelGroupAction);
                        addModelGroupAction = new AddModelGroupAction(concreteComponent, XSDCompositor.ALL_LITERAL);
                        addModelGroupAction.setEnabled(!this.isReadOnly);
                        manager.add((IAction)addModelGroupAction);
                    }
                    this.addCreateElementRefAction(manager, "group", XSDEditorPlugin.getXSDString("_UI_ADD_GROUP_REF"), parent, annotationNode.getNextSibling());
                    attributes = null;
                }
            } else if (!contentExists) {
                if (concreteComponent != null) {
                    addModelGroupAction = new AddModelGroupAction(concreteComponent, XSDCompositor.SEQUENCE_LITERAL);
                    addModelGroupAction.setEnabled(!this.isReadOnly);
                    manager.add((IAction)addModelGroupAction);
                    addModelGroupAction = new AddModelGroupAction(concreteComponent, XSDCompositor.CHOICE_LITERAL);
                    addModelGroupAction.setEnabled(!this.isReadOnly);
                    manager.add((IAction)addModelGroupAction);
                    addModelGroupAction = new AddModelGroupAction(concreteComponent, XSDCompositor.ALL_LITERAL);
                    addModelGroupAction.setEnabled(!this.isReadOnly);
                    manager.add((IAction)addModelGroupAction);
                }
                this.addCreateElementRefAction(manager, "group", XSDEditorPlugin.getXSDString("_UI_ADD_GROUP_REF"), parent, parent.getFirstChild());
                attributes = null;
            }
            manager.add((IContributionItem)new Separator());
            if (XSDDOMHelper.inputEquals(parent.getParentNode(), "element", false)) {
                manager.add((IContributionItem)new Separator());
                attributes = new ArrayList();
                attributes.add(new DOMAttribute("name", this.getNewGlobalTypeName("ComplexType")));
                this.addMoveAnonymousGlobal(manager, "complexType", XSDEditorPlugin.getXSDString("_UI_ACTION_MAKE_ANONYMOUS_TYPE_GLOBAL"), attributes, parent, null);
                attributes = null;
            }
        } else if (XSDDOMHelper.inputEquals(parent, "complexContent", false)) {
            XSDDOMHelper xsdDOMHelper = new XSDDOMHelper();
            Element derivedByNode = xsdDOMHelper.getDerivedByElement(parent);
            this.addCreateAnnotationActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
            manager.add((IContributionItem)new Separator());
            if (derivedByNode == null) {
                TypesHelper typesHelper = new TypesHelper(this.getXSDSchema());
                String firstType = "";
                List listOfCT = typesHelper.getUserComplexTypeNamesList();
                if (listOfCT.size() > 0) {
                    firstType = (String)listOfCT.get(0);
                }
                attributes = new ArrayList();
                attributes.add(new DOMAttribute("base", firstType));
                this.addCreateElementActionIfNotExist(manager, "restriction", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_RESTRICTION"), attributes, parent, null);
                this.addCreateElementActionIfNotExist(manager, "extension", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_EXTENSION"), attributes, parent, null);
            }
        } else if (XSDDOMHelper.inputEquals(parent, "simpleContent", false)) {
            XSDDOMHelper xsdDOMHelper = new XSDDOMHelper();
            Element derivedByNode = xsdDOMHelper.getDerivedByElement(parent);
            this.addCreateAnnotationActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
            manager.add((IContributionItem)new Separator());
            if (derivedByNode == null) {
                TypesHelper typesHelper = new TypesHelper(this.getXSDSchema());
                String firstType = "";
                List listOfCT = typesHelper.getUserComplexTypeNamesList();
                if (listOfCT.size() > 0) {
                    firstType = (String)listOfCT.get(0);
                }
                attributes = new ArrayList();
                attributes.add(new DOMAttribute("base", firstType));
                this.addCreateElementActionIfNotExist(manager, "restriction", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_RESTRICTION"), attributes, parent, null);
                this.addCreateElementActionIfNotExist(manager, "extension", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_EXTENSION"), attributes, parent, null);
            }
        } else if (XSDDOMHelper.inputEquals(parent, "restriction", false)) {
            Element parentNode = (Element)parent.getParentNode();
            if (XSDDOMHelper.inputEquals(parentNode, "simpleContent", false)) {
                boolean annotationExists = false;
                boolean anyAttributeExists = false;
                Node anyAttributeNode = null;
                anyAttributeExists = this.elementExists("anyAttribute", parent);
                annotationExists = this.addCreateAnnotationActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
                if (annotationExists) {
                    this.getFirstChildNodeIfExists(parent, "annotation", false);
                }
                manager.add((IContributionItem)new Separator());
                if (anyAttributeExists) {
                    anyAttributeNode = this.getFirstChildNodeIfExists(parent, "anyAttribute", false);
                    attributes = new ArrayList();
                    attributes.add(new DOMAttribute("name", this.getNewName(parent, "attribute", "Attribute", false)));
                    attributes.add(new DOMAttribute("type", this.getBuiltInStringQName()));
                    this.addCreateElementAction(manager, "attribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE"), attributes, parent, anyAttributeNode);
                    attributes = null;
                    this.addCreateElementRefAction(manager, "attribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE_REFERENCE"), parent, anyAttributeNode);
                    this.addCreateElementRefAction(manager, "attributeGroup", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE_GROUP_REF"), parent, anyAttributeNode);
                } else {
                    attributes = new ArrayList();
                    attributes.add(new DOMAttribute("name", this.getNewName(parent, "attribute", "Attribute", false)));
                    attributes.add(new DOMAttribute("type", this.getBuiltInStringQName()));
                    this.addCreateElementAction(manager, "attribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE"), attributes, parent, parent.getLastChild());
                    attributes = null;
                    this.addCreateElementRefAction(manager, "attribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE_REFERENCE"), parent, parent.getLastChild());
                    this.addCreateElementRefAction(manager, "attributeGroup", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE_GROUP_REF"), parent, parent.getLastChild());
                }
                attributes = null;
                this.addCreateElementActionIfNotExist(manager, "anyAttribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANY_ATTRIBUTE"), attributes, parent, parent.getLastChild());
            } else if (XSDDOMHelper.inputEquals(parentNode, "simpleType", false)) {
                boolean annotationExists = false;
                attributes = null;
                annotationExists = this.addCreateAnnotationActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
                if (annotationExists) {
                    Node annotationNode = this.getFirstChildNodeIfExists(parent, "annotation", false);
                    this.addCreateLocalSimpleTypeActionIfNotExist(manager, "simpleType", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_LOCAL_SIMPLE_TYPE"), attributes, parent, annotationNode.getNextSibling());
                } else {
                    this.addCreateLocalSimpleTypeActionIfNotExist(manager, "simpleType", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_LOCAL_SIMPLE_TYPE"), attributes, parent, parent.getFirstChild());
                }
                manager.add((IContributionItem)new Separator());
                this.addCreateElementAction(manager, "pattern", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_PATTERN"), attributes, parent, null);
                this.addCreateElementAction(manager, "enumeration", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ENUM"), attributes, parent, null);
                this.addEnumsAction(manager, "enumeration", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ENUMS"), attributes, parent, null);
            } else if (XSDDOMHelper.inputEquals(parentNode, "complexContent", false)) {
                boolean annotationExists = false;
                boolean anyAttributeExists = false;
                Node anyAttributeNode = null;
                boolean sequenceExists = this.elementExists("sequence", parent);
                boolean choiceExists = this.elementExists("choice", parent);
                boolean allExists = this.elementExists("all", parent);
                boolean groupExists = this.elementExists("group", parent);
                anyAttributeExists = this.elementExists("anyAttribute", parent);
                annotationExists = this.addCreateAnnotationActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
                manager.add((IContributionItem)new Separator());
                if (annotationExists) {
                    if (!(sequenceExists || choiceExists || allExists || groupExists)) {
                        Node annotationNode = this.getFirstChildNodeIfExists(parent, "annotation", false);
                        this.addCreateElementActionIfNotExist(manager, "sequence", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_CONTENT_MODEL"), attributes, parent, annotationNode.getNextSibling());
                        this.addCreateElementRefAction(manager, "group", XSDEditorPlugin.getXSDString("_UI_ADD_GROUP_REF"), parent, annotationNode.getNextSibling());
                    }
                } else if (!(sequenceExists || choiceExists || allExists || groupExists)) {
                    this.addCreateElementActionIfNotExist(manager, "sequence", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_CONTENT_MODEL"), attributes, parent, parent.getFirstChild());
                    this.addCreateElementRefAction(manager, "group", XSDEditorPlugin.getXSDString("_UI_ADD_GROUP_REF"), parent, parent.getFirstChild());
                }
                manager.add((IContributionItem)new Separator());
                if (anyAttributeExists) {
                    anyAttributeNode = this.getFirstChildNodeIfExists(parent, "anyAttribute", false);
                    attributes = new ArrayList();
                    attributes.add(new DOMAttribute("name", this.getNewName(parent, "attribute", "Attribute", false)));
                    attributes.add(new DOMAttribute("type", this.getBuiltInStringQName()));
                    this.addCreateElementAction(manager, "attribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE"), attributes, parent, anyAttributeNode);
                    attributes = null;
                    this.addCreateElementRefAction(manager, "attribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE_REFERENCE"), parent, anyAttributeNode);
                    this.addCreateElementRefAction(manager, "attributeGroup", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE_GROUP_REF"), parent, anyAttributeNode);
                } else {
                    attributes = new ArrayList();
                    attributes.add(new DOMAttribute("name", this.getNewName(parent, "attribute", "Attribute", false)));
                    attributes.add(new DOMAttribute("type", this.getBuiltInStringQName()));
                    this.addCreateElementAction(manager, "attribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE"), attributes, parent, parent.getLastChild());
                    attributes = null;
                    this.addCreateElementRefAction(manager, "attribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE_REFERENCE"), parent, parent.getLastChild());
                    this.addCreateElementRefAction(manager, "attributeGroup", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE_GROUP_REF"), parent, parent.getLastChild());
                }
                attributes = null;
                this.addCreateElementActionIfNotExist(manager, "anyAttribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANY_ATTRIBUTE"), attributes, parent, parent.getLastChild());
            }
        } else if (XSDDOMHelper.inputEquals(parent, "extension", false)) {
            Element parentNode = (Element)parent.getParentNode();
            if (XSDDOMHelper.inputEquals(parentNode, "simpleContent", false)) {
                boolean anyAttributeExists = false;
                Node anyAttributeNode = null;
                anyAttributeExists = this.elementExists("anyAttribute", parent);
                this.addCreateAnnotationActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
                manager.add((IContributionItem)new Separator());
                if (anyAttributeExists) {
                    anyAttributeNode = this.getFirstChildNodeIfExists(parent, "anyAttribute", false);
                    attributes = new ArrayList();
                    attributes.add(new DOMAttribute("name", this.getNewName(parent, "attribute", "Attribute", false)));
                    attributes.add(new DOMAttribute("type", this.getBuiltInStringQName()));
                    this.addCreateElementAction(manager, "attribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE"), attributes, parent, anyAttributeNode);
                    attributes = null;
                    this.addCreateElementRefAction(manager, "attribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE_REFERENCE"), parent, anyAttributeNode);
                    this.addCreateElementRefAction(manager, "attributeGroup", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE_GROUP_REF"), parent, anyAttributeNode);
                } else {
                    attributes = new ArrayList();
                    attributes.add(new DOMAttribute("name", this.getNewName(parent, "attribute", "Attribute", false)));
                    attributes.add(new DOMAttribute("type", this.getBuiltInStringQName()));
                    this.addCreateElementAction(manager, "attribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE"), attributes, parent, parent.getLastChild());
                    attributes = null;
                    this.addCreateElementRefAction(manager, "attribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE_REFERENCE"), parent, parent.getLastChild());
                    this.addCreateElementRefAction(manager, "attributeGroup", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE_GROUP_REF"), parent, parent.getLastChild());
                }
                attributes = null;
                this.addCreateElementActionIfNotExist(manager, "anyAttribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANY_ATTRIBUTE"), attributes, parent, parent.getLastChild());
            } else if (XSDDOMHelper.inputEquals(parentNode, "complexContent", false)) {
                boolean annotationExists = false;
                boolean anyAttributeExists = false;
                Node anyAttributeNode = null;
                boolean sequenceExists = this.elementExists("sequence", parent);
                boolean choiceExists = this.elementExists("choice", parent);
                boolean allExists = this.elementExists("all", parent);
                boolean groupExists = this.elementExists("group", parent);
                anyAttributeExists = this.elementExists("anyAttribute", parent);
                annotationExists = this.addCreateAnnotationActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
                manager.add((IContributionItem)new Separator());
                if (annotationExists) {
                    if (!(sequenceExists || choiceExists || allExists || groupExists)) {
                        Node annotationNode = this.getFirstChildNodeIfExists(parent, "annotation", false);
                        this.addCreateElementActionIfNotExist(manager, "sequence", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_CONTENT_MODEL"), attributes, parent, annotationNode.getNextSibling());
                        this.addCreateElementRefAction(manager, "group", XSDEditorPlugin.getXSDString("_UI_ADD_GROUP_REF"), parent, annotationNode.getNextSibling());
                    }
                } else if (!(sequenceExists || choiceExists || allExists || groupExists)) {
                    this.addCreateElementActionIfNotExist(manager, "sequence", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_CONTENT_MODEL"), attributes, parent, parent.getFirstChild());
                    this.addCreateElementRefAction(manager, "group", XSDEditorPlugin.getXSDString("_UI_ADD_GROUP_REF"), parent, parent.getFirstChild());
                }
                manager.add((IContributionItem)new Separator());
                if (anyAttributeExists) {
                    anyAttributeNode = this.getFirstChildNodeIfExists(parent, "anyAttribute", false);
                    attributes = new ArrayList();
                    attributes.add(new DOMAttribute("name", this.getNewName(parent, "attribute", "Attribute", false)));
                    attributes.add(new DOMAttribute("type", this.getBuiltInStringQName()));
                    this.addCreateElementAction(manager, "attribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE"), attributes, parent, anyAttributeNode);
                    attributes = null;
                    this.addCreateElementRefAction(manager, "attribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE_REFERENCE"), parent, anyAttributeNode);
                    this.addCreateElementRefAction(manager, "attributeGroup", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE_GROUP_REF"), parent, anyAttributeNode);
                } else {
                    attributes = new ArrayList();
                    attributes.add(new DOMAttribute("name", this.getNewName(parent, "attribute", "Attribute", false)));
                    attributes.add(new DOMAttribute("type", this.getBuiltInStringQName()));
                    this.addCreateElementAction(manager, "attribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE"), attributes, parent, parent.getLastChild());
                    attributes = null;
                    this.addCreateElementRefAction(manager, "attribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE_REFERENCE"), parent, parent.getLastChild());
                    this.addCreateElementRefAction(manager, "attributeGroup", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE_GROUP_REF"), parent, parent.getLastChild());
                }
                attributes = null;
                this.addCreateElementActionIfNotExist(manager, "anyAttribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANY_ATTRIBUTE"), attributes, parent, parent.getLastChild());
            }
        } else if (XSDDOMHelper.inputEquals(parent, "redefine", false)) {
            this.addCreateElementAction(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, null);
            this.addCreateElementAction(manager, "simpleType", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_SIMPLE_TYPE"), attributes, parent, null);
            this.addCreateElementAction(manager, "complexType", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_COMPLEX_TYPE"), attributes, parent, null);
            this.addCreateGroupAction(manager, "group", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_GROUP"), attributes, parent, null);
            this.addCreateElementAction(manager, "attributeGroup", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE_GROUP"), attributes, parent, null);
            manager.add((IContributionItem)new Separator());
            this.addOpenSchemaAction(manager, XSDEditorPlugin.getXSDString("_UI_ACTION_OPEN_SCHEMA"), parent);
        } else if (XSDDOMHelper.inputEquals(parent, "list", false)) {
            this.addCreateAnnotationActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
            manager.add((IContributionItem)new Separator());
            this.addCreateLocalSimpleTypeActionIfNotExist(manager, "simpleType", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_LOCAL_SIMPLE_TYPE"), attributes, parent, null);
        } else if (XSDDOMHelper.inputEquals(parent, "union", false)) {
            this.addCreateAnnotationActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
            manager.add((IContributionItem)new Separator());
            this.addCreateLocalSimpleTypeAction(manager, "simpleType", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_LOCAL_SIMPLE_TYPE"), attributes, parent, null);
        } else if (XSDDOMHelper.inputEquals(parent, "unique", false)) {
            boolean annotationExists = this.addCreateAnnotationActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
            manager.add((IContributionItem)new Separator());
            attributes = new ArrayList();
            attributes.add(new DOMAttribute("xpath", ""));
            if (annotationExists) {
                Node annotationNode = this.getFirstChildNodeIfExists(parent, "annotation", false);
                this.addCreateElementActionIfNotExist(manager, "selector", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_SELECTOR"), attributes, parent, annotationNode.getNextSibling());
            } else {
                this.addCreateElementActionIfNotExist(manager, "selector", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_SELECTOR"), attributes, parent, parent.getFirstChild());
            }
            attributes = new ArrayList();
            attributes.add(new DOMAttribute("xpath", ""));
            this.addCreateElementAction(manager, "field", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_FIELD"), attributes, parent, null);
        } else if (XSDDOMHelper.inputEquals(parent, "keyref", false)) {
            boolean annotationExists = this.addCreateAnnotationActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
            manager.add((IContributionItem)new Separator());
            attributes = new ArrayList();
            attributes.add(new DOMAttribute("xpath", ""));
            if (annotationExists) {
                Node annotationNode = this.getFirstChildNodeIfExists(parent, "annotation", false);
                this.addCreateElementActionIfNotExist(manager, "selector", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_SELECTOR"), attributes, parent, annotationNode.getNextSibling());
            } else {
                this.addCreateElementActionIfNotExist(manager, "selector", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_SELECTOR"), attributes, parent, parent.getFirstChild());
            }
            attributes = new ArrayList();
            attributes.add(new DOMAttribute("xpath", ""));
            this.addCreateElementAction(manager, "field", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_FIELD"), attributes, parent, null);
        } else if (XSDDOMHelper.inputEquals(parent, "key", false)) {
            boolean annotationExists = this.addCreateAnnotationActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
            manager.add((IContributionItem)new Separator());
            attributes = new ArrayList();
            attributes.add(new DOMAttribute("xpath", ""));
            if (annotationExists) {
                Node annotationNode = this.getFirstChildNodeIfExists(parent, "annotation", false);
                this.addCreateElementActionIfNotExist(manager, "selector", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_SELECTOR"), attributes, parent, annotationNode.getNextSibling());
            } else {
                this.addCreateElementActionIfNotExist(manager, "selector", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_SELECTOR"), attributes, parent, parent.getFirstChild());
            }
            attributes = new ArrayList();
            attributes.add(new DOMAttribute("xpath", ""));
            this.addCreateElementAction(manager, "field", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_FIELD"), attributes, parent, null);
        } else if (XSDDOMHelper.inputEquals(parent, "import", false)) {
            this.addCreateElementActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
            manager.add((IContributionItem)new Separator());
            this.addOpenSchemaAction(manager, XSDEditorPlugin.getXSDString("_UI_ACTION_OPEN_SCHEMA"), parent);
        } else if (XSDDOMHelper.inputEquals(parent, "selector", false)) {
            this.addCreateElementActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
        } else if (XSDDOMHelper.inputEquals(parent, "field", false)) {
            this.addCreateElementActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
        } else if (XSDDOMHelper.inputEquals(parent, "include", false)) {
            this.addCreateElementActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
            manager.add((IContributionItem)new Separator());
            this.addOpenSchemaAction(manager, XSDEditorPlugin.getXSDString("_UI_ACTION_OPEN_SCHEMA"), parent);
        } else if (XSDDOMHelper.inputEquals(parent, "any", false)) {
            this.addCreateElementActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
        } else if (XSDDOMHelper.inputEquals(parent, "anyAttribute", false)) {
            this.addCreateElementActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
        } else if (XSDDOMHelper.inputEquals(parent, "attribute", false)) {
            this.addCreateElementActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
            this.addCreateLocalSimpleTypeActionIfNotExist(manager, "simpleType", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_LOCAL_SIMPLE_TYPE"), attributes, parent, null);
        } else if (XSDDOMHelper.inputEquals(parent, "minExclusive", false)) {
            this.addCreateAnnotationActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
        } else if (XSDDOMHelper.inputEquals(parent, "minInclusive", false)) {
            this.addCreateAnnotationActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
        } else if (XSDDOMHelper.inputEquals(parent, "maxExclusive", false)) {
            this.addCreateAnnotationActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
        } else if (XSDDOMHelper.inputEquals(parent, "maxInclusive", false)) {
            this.addCreateAnnotationActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
        } else if (XSDDOMHelper.inputEquals(parent, "totalDigits", false)) {
            this.addCreateAnnotationActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
        } else if (XSDDOMHelper.inputEquals(parent, "fractionDigits", false)) {
            this.addCreateAnnotationActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
        } else if (XSDDOMHelper.inputEquals(parent, "length", false)) {
            this.addCreateAnnotationActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
        } else if (XSDDOMHelper.inputEquals(parent, "minLength", false)) {
            this.addCreateAnnotationActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
        } else if (XSDDOMHelper.inputEquals(parent, "maxLength", false)) {
            this.addCreateAnnotationActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
        } else if (XSDDOMHelper.inputEquals(parent, "enumeration", false)) {
            this.addCreateAnnotationActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
        } else if (XSDDOMHelper.inputEquals(parent, "whiteSpace", false)) {
            this.addCreateAnnotationActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
        } else if (XSDDOMHelper.inputEquals(parent, "pattern", false)) {
            this.addCreateAnnotationActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
        } else if (XSDDOMHelper.inputEquals(parent, "attributeGroup", true)) {
            this.addCreateAnnotationActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
        } else if (XSDDOMHelper.inputEquals(parent, "attribute", true)) {
            this.addCreateAnnotationActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
        } else if (XSDDOMHelper.inputEquals(parent, "element", true) && (xsdConcreteComponent = this.getXSDSchema().getCorrespondingComponent((Node)parent)) instanceof XSDElementDeclaration) {
            XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)xsdConcreteComponent;
            XSDElementDeclaration resolvedElementDeclaration = xsdElementDeclaration.getResolvedElementDeclaration();
            if (resolvedElementDeclaration.getRootContainer() == this.xsdSchema) {
                XSDDOMHelper domHelper;
                Element anonymousType;
                parent = resolvedElementDeclaration.getElement();
                boolean annotationExists = this.addCreateAnnotationActionIfNotExist(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), attributes, parent, parent.getFirstChild());
                boolean simpleTypeExists = this.elementExists("simpleType", parent);
                boolean complexTypeExists = this.elementExists("complexType", parent);
                manager.add((IContributionItem)new Separator());
                if (annotationExists) {
                    Node annotationNode = this.getFirstChildNodeIfExists(parent, "annotation", false);
                    if (!simpleTypeExists && !complexTypeExists && annotationNode != null) {
                        manager.add((IContributionItem)new Separator());
                    }
                } else {
                    XSDConcreteComponent concreteComponent = this.getXSDSchema().getCorrespondingComponent((Node)parent);
                    if (concreteComponent != null) {
                        AddModelGroupAction addModelGroupAction = new AddModelGroupAction(concreteComponent, XSDCompositor.SEQUENCE_LITERAL);
                        addModelGroupAction.setEnabled(!this.isReadOnly);
                        manager.add((IAction)addModelGroupAction);
                        addModelGroupAction = new AddModelGroupAction(concreteComponent, XSDCompositor.CHOICE_LITERAL);
                        addModelGroupAction.setEnabled(!this.isReadOnly);
                        manager.add((IAction)addModelGroupAction);
                        addModelGroupAction = new AddModelGroupAction(concreteComponent, XSDCompositor.ALL_LITERAL);
                        addModelGroupAction.setEnabled(!this.isReadOnly);
                        manager.add((IAction)addModelGroupAction);
                        manager.add((IContributionItem)new Separator());
                    }
                }
                if ((anonymousType = (Element)(domHelper = new XSDDOMHelper()).getChildNode(parent, "complexType")) != null) {
                    manager.add((IContributionItem)new Separator());
                    attributes = new ArrayList();
                    attributes.add(new DOMAttribute("name", this.getNewGlobalTypeName("ComplexType")));
                    this.addMoveAnonymousGlobal(manager, "complexType", XSDEditorPlugin.getXSDString("_UI_ACTION_MAKE_ANONYMOUS_TYPE_GLOBAL"), attributes, anonymousType, null);
                    attributes = null;
                }
                if ((anonymousType = (Element)domHelper.getChildNode(parent, "simpleType")) != null) {
                    manager.add((IContributionItem)new Separator());
                    attributes = new ArrayList();
                    attributes.add(new DOMAttribute("name", this.getNewGlobalTypeName("SimpleType")));
                    this.addMoveAnonymousGlobal(manager, "simpleType", XSDEditorPlugin.getXSDString("_UI_ACTION_MAKE_ANONYMOUS_TYPE_GLOBAL"), attributes, anonymousType, null);
                    attributes = null;
                }
            }
            this.addMultiplicityMenu(xsdConcreteComponent, manager);
        }
        XSDConcreteComponent concreteComponent = this.getXSDSchema().getCorrespondingComponent((Node)parent);
        if (concreteComponent instanceof XSDNamedComponent) {
            this.addRefactorMenuGroup(manager);
        }
    }

    protected void addContextInsertItems(IMenuManager manager, Element parent, Element currentElement, Node relativeNode) {
        ArrayList<DOMAttribute> attributes = null;
        if (XSDDOMHelper.inputEquals(currentElement, "include", false) || XSDDOMHelper.inputEquals(currentElement, "import", false) || XSDDOMHelper.inputEquals(currentElement, "redefine", false) || XSDDOMHelper.inputEquals(currentElement, "annotation", false)) {
            if (XSDDOMHelper.inputEquals(parent, "schema", false)) {
                attributes = new ArrayList<DOMAttribute>();
                attributes.add(new DOMAttribute("schemaLocation", ""));
                this.addCreateElementAction(manager, "include", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_INCLUDE"), attributes, parent, relativeNode);
                this.addCreateElementAction(manager, "import", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_IMPORT"), null, parent, relativeNode);
                this.addCreateElementAction(manager, "redefine", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_REDEFINE"), attributes, parent, relativeNode);
                attributes = null;
                this.addCreateElementAction(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), null, parent, relativeNode);
            }
        } else if (XSDDOMHelper.inputEquals(currentElement, "simpleType", false)) {
            if (XSDDOMHelper.inputEquals(parent, "schema", false)) {
                this.addSchemaElementItems(manager, parent, relativeNode);
            } else if (XSDDOMHelper.inputEquals(parent, "union", false)) {
                this.addCreateLocalSimpleTypeAction(manager, "simpleType", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_LOCAL_SIMPLE_TYPE"), attributes, parent, relativeNode);
            }
        } else if (XSDDOMHelper.inputEquals(currentElement, "complexType", false)) {
            if (XSDDOMHelper.inputEquals(parent, "schema", false)) {
                this.addSchemaElementItems(manager, parent, relativeNode);
            }
        } else if (XSDDOMHelper.inputEquals(currentElement, "group", false)) {
            if (XSDDOMHelper.inputEquals(parent, "schema", false)) {
                this.addSchemaElementItems(manager, parent, relativeNode);
            }
        } else if (XSDDOMHelper.inputEquals(currentElement, "attributeGroup", false)) {
            if (XSDDOMHelper.inputEquals(parent, "schema", false)) {
                this.addSchemaElementItems(manager, parent, relativeNode);
            }
        } else if (XSDDOMHelper.inputEquals(currentElement, "element", false)) {
            if (XSDDOMHelper.inputEquals(parent, "schema", false)) {
                this.addSchemaElementItems(manager, parent, relativeNode);
            }
        } else if (XSDDOMHelper.inputEquals(currentElement, "attribute", false)) {
            if (XSDDOMHelper.inputEquals(parent, "schema", false)) {
                this.addSchemaElementItems(manager, parent, relativeNode);
            }
        } else if (XSDDOMHelper.inputEquals(currentElement, "notation", false)) {
            if (XSDDOMHelper.inputEquals(parent, "schema", false)) {
                this.addSchemaElementItems(manager, parent, relativeNode);
            }
        } else if (XSDDOMHelper.inputEquals(currentElement, "documentation", false)) {
            this.addCreateElementAction(manager, "documentation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_DOC"), attributes, parent, relativeNode);
            this.addCreateElementAction(manager, "appinfo", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_APP_INFO"), attributes, parent, relativeNode);
        } else if (XSDDOMHelper.inputEquals(currentElement, "appinfo", false)) {
            this.addCreateElementAction(manager, "documentation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_DOC"), attributes, parent, relativeNode);
            this.addCreateElementAction(manager, "appinfo", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_APP_INFO"), attributes, parent, relativeNode);
        }
    }

    protected String getNewGlobalName(String elementTag, String description) {
        return this.getNewGlobalName(elementTag, description, false);
    }

    protected String getNewGlobalTypeName(String description) {
        return this.getNewGlobalName(null, description, true);
    }

    protected String getNewGlobalName(String elementTag, String description, boolean isSimpleOrComplexType) {
        return this.getNewName(this.getXSDSchema().getDocument(), elementTag, description, isSimpleOrComplexType);
    }

    protected String getNewName(Node parentNode, String elementTag, String description, boolean isSimpleOrComplexType) {
        NodeList list = null;
        NodeList typeList2 = null;
        if (isSimpleOrComplexType) {
            if (parentNode instanceof Document) {
                list = ((Document)parentNode).getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "complexType");
                typeList2 = ((Document)parentNode).getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "simpleType");
            } else if (parentNode instanceof Element) {
                list = ((Element)parentNode).getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "complexType");
                typeList2 = ((Element)parentNode).getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "simpleType");
            }
        } else if (parentNode instanceof Document) {
            list = ((Document)parentNode).getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", elementTag);
        } else if (parentNode instanceof Element) {
            list = ((Element)parentNode).getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", elementTag);
        }
        String name = "New" + description;
        if (list == null || list.getLength() == 0 && typeList2 != null && typeList2.getLength() == 0) {
            return name;
        }
        int i = 1;
        while (i < 100) {
            String currName;
            boolean newName = false;
            int j = 0;
            while (j < list.getLength()) {
                currName = ((Element)list.item(j)).getAttribute("name");
                if (currName != null && currName.length() != 0 && currName.equals(name)) {
                    name = "New" + description + String.valueOf(i);
                    newName = true;
                    break;
                }
                ++j;
            }
            if (typeList2 != null && !newName) {
                j = 0;
                while (j < typeList2.getLength()) {
                    currName = ((Element)typeList2.item(j)).getAttribute("name");
                    if (currName != null && currName.length() != 0 && currName.equals(name)) {
                        name = "New" + description + String.valueOf(i);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return name;
    }

    protected String getFirstGlobalElementTagName(String elementTag) {
        XSDSchema schema = this.getXSDSchema();
        TypesHelper helper = new TypesHelper(schema);
        String prefix = "";
        if (schema != null) {
            prefix = helper.getPrefix(schema.getTargetNamespace(), true);
        }
        NodeList slist = schema.getDocument().getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "schema");
        Node schemaNode = null;
        if (slist != null && slist.getLength() > 0) {
            schemaNode = slist.item(0);
        }
        NodeList list = null;
        if (schemaNode != null) {
            list = schemaNode.getChildNodes();
        }
        String name = null;
        if (list != null) {
            int i = 0;
            while (i < list.getLength()) {
                if (list.item(i) instanceof Element && list.item(i).getLocalName().equals(elementTag) && (name = ((Element)list.item(i)).getAttribute("name")) != null && name.length() > 0) {
                    return String.valueOf(prefix) + name;
                }
                ++i;
            }
        }
        if (elementTag.equals("element")) {
            return helper.getGlobalElement(schema);
        }
        if (elementTag.equals("attribute")) {
            return helper.getGlobalAttribute(schema);
        }
        if (elementTag.equals("attributeGroup")) {
            return helper.getGlobalAttributeGroup(schema);
        }
        if (elementTag.equals("group")) {
            return helper.getModelGroup(schema);
        }
        return null;
    }

    protected void addSchemaElementItems(IMenuManager manager, Element parent, Node relativeNode) {
        ArrayList<DOMAttribute> attributes = null;
        XSDEditNamespacesAction nsAction = new XSDEditNamespacesAction(XSDEditorPlugin.getXSDString("_UI_ACTION_EDIT_NAMESPACES"), parent, relativeNode, this.getXSDSchema());
        manager.add((IAction)nsAction);
        manager.add((IContributionItem)new Separator());
        DOMAttribute nameAttribute = new DOMAttribute("name", this.getNewGlobalTypeName("ComplexType"));
        attributes = new ArrayList<DOMAttribute>();
        attributes.add(nameAttribute);
        Action action = this.addCreateElementAction(manager, "complexType", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_COMPLEX_TYPE"), attributes, parent, relativeNode);
        ((CreateElementAction)action).setIsGlobal(true);
        attributes = new ArrayList();
        attributes.add(new DOMAttribute("name", this.getNewGlobalTypeName("SimpleType")));
        action = this.addCreateElementAction(manager, "simpleType", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_SIMPLE_TYPE"), attributes, parent, relativeNode);
        ((CreateElementAction)action).setIsGlobal(true);
        attributes = new ArrayList();
        attributes.add(new DOMAttribute("name", this.getNewGlobalName("element", "GlobalElement")));
        attributes.add(new DOMAttribute("type", this.getBuiltInStringQName()));
        action = this.addCreateElementAction(manager, "element", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_GLOBAL_ELEMENT"), attributes, parent, relativeNode);
        ((CreateElementAction)action).setIsGlobal(true);
        attributes = new ArrayList();
        attributes.add(new DOMAttribute("name", this.getNewGlobalName("attribute", "GlobalAttribute")));
        attributes.add(new DOMAttribute("type", this.getBuiltInStringQName()));
        action = this.addCreateElementAction(manager, "attribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_GLOBAL_ATTRIBUTE"), attributes, parent, relativeNode);
        ((CreateElementAction)action).setIsGlobal(true);
        attributes = new ArrayList();
        attributes.add(new DOMAttribute("name", this.getNewGlobalName("attributeGroup", "AttributeGroup")));
        action = this.addCreateElementAction(manager, "attributeGroup", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE_GROUP"), attributes, parent, relativeNode);
        ((CreateElementAction)action).setIsGlobal(true);
        attributes = new ArrayList();
        attributes.add(new DOMAttribute("name", this.getNewGlobalName("group", "Group")));
        CreateGroupAction groupAction = this.addCreateGroupAction(manager, "group", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_GROUP"), attributes, parent, relativeNode);
        groupAction.setIsGlobal(true);
        attributes = new ArrayList();
        attributes.add(new DOMAttribute("name", this.getNewGlobalName("notation", "Notation")));
        attributes.add(new DOMAttribute("public", ""));
        action = this.addCreateElementAction(manager, "notation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_NOTATION"), attributes, parent, relativeNode);
        ((CreateElementAction)action).setIsGlobal(true);
        action = this.addCreateElementAction(manager, "annotation", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANNOTATION"), null, parent, relativeNode);
        ((CreateElementAction)action).setIsGlobal(true);
    }

    protected boolean addCreateElementActionIfNotExist(IMenuManager manager, String elementTag, String label, List attributes, Element parent, Node relativeNode) {
        if (this.getFirstChildNodeIfExists(parent, elementTag, false) == null) {
            this.addCreateElementAction(manager, elementTag, label, attributes, parent, relativeNode);
            return false;
        }
        return true;
    }

    protected Action addCreateElementAction(IMenuManager manager, String elementTag, String label, List attributes, Element parent, Node relativeNode) {
        CreateElementAction action = new CreateElementAction(label);
        action.setElementTag(elementTag);
        action.setAttributes(attributes);
        action.setParentNode(parent);
        action.setRelativeNode(relativeNode);
        action.setXSDSchema(this.getXSDSchema());
        action.setSelectionProvider(this.selectionProvider);
        action.setEnabled(!this.isReadOnly);
        action.setSourceContext(this.sourceContext);
        manager.add((IAction)action);
        return action;
    }

    protected void addCreateElementAction(IMenuManager manager, String elementTag, String label, List attributes, Element parent, Node relativeNode, boolean isEnabled) {
        Action action = this.addCreateElementAction(manager, elementTag, label, attributes, parent, relativeNode);
        action.setEnabled(isEnabled);
    }

    protected void addCreateElementRefAction(IMenuManager manager, String elementTag, String label, Element parent, Node relativeNode) {
        ArrayList<DOMAttribute> attributes = new ArrayList<DOMAttribute>();
        String ref = this.getFirstGlobalElementTagName(elementTag);
        attributes.add(new DOMAttribute("ref", ref));
        Action action = this.addCreateElementAction(manager, elementTag, label, attributes, parent, relativeNode);
        action.setEnabled(ref != null && !this.isReadOnly);
    }

    protected void addCreateSimpleContentAction(IMenuManager manager, String elementTag, String label, List attributes, Element parent, Node relativeNode) {
        if (this.getFirstChildNodeIfExists(parent, elementTag, false) == null) {
            CreateSimpleContentAction action = new CreateSimpleContentAction(label, this.getXSDSchema());
            action.setElementTag(elementTag);
            action.setAttributes(attributes);
            action.setParentNode(parent);
            action.setRelativeNode(relativeNode);
            action.setEnabled(!this.isReadOnly);
            manager.add((IAction)action);
        }
    }

    protected CreateGroupAction addCreateGroupAction(IMenuManager manager, String elementTag, String label, List attributes, Element parent, Node relativeNode) {
        CreateGroupAction action = new CreateGroupAction(label, this.getXSDSchema());
        action.setElementTag(elementTag);
        action.setAttributes(attributes);
        action.setParentNode(parent);
        action.setRelativeNode(relativeNode);
        action.setXSDSchema(this.getXSDSchema());
        action.setSelectionProvider(this.selectionProvider);
        action.setEnabled(!this.isReadOnly);
        action.setSourceContext(this.sourceContext);
        manager.add((IAction)action);
        return action;
    }

    protected void addCreateIdentityConstraintsAction(IMenuManager manager, String elementTag, String label, List attributes, Element parent, Node relativeNode) {
        CreateIdentityConstraintsAction action = new CreateIdentityConstraintsAction(label, this.getXSDSchema());
        action.setElementTag(elementTag);
        action.setAttributes(attributes);
        action.setParentNode(parent);
        action.setRelativeNode(relativeNode);
        action.setXSDSchema(this.getXSDSchema());
        action.setSelectionProvider(this.selectionProvider);
        action.setEnabled(!this.isReadOnly);
        manager.add((IAction)action);
    }

    protected void addEnumsAction(IMenuManager manager, String elementTag, String label, List attributes, Element parent, Node relativeNode) {
        AddEnumsAction action = new AddEnumsAction(label);
        action.setElementTag(elementTag);
        action.setAttributes(attributes);
        action.setParentNode(parent);
        action.setRelativeNode(relativeNode);
        action.setDescription(XSDEditorPlugin.getXSDString("_UI_ENUMERATIONS_DIALOG_TITLE"));
        action.setEnabled(!this.isReadOnly);
        manager.add((IAction)action);
    }

    protected Action addCreateSimpleTypeAction(IMenuManager manager, String elementTag, String label, List attributes, Element parent, Node relativeNode) {
        CreateSimpleTypeAction action = new CreateSimpleTypeAction(label);
        action.setElementTag(elementTag);
        action.setAttributes(attributes);
        action.setParentNode(parent);
        action.setRelativeNode(relativeNode);
        action.setXSDSchema(this.getXSDSchema());
        action.setSelectionProvider(this.selectionProvider);
        action.setEnabled(!this.isReadOnly);
        action.setSourceContext(this.sourceContext);
        manager.add((IAction)action);
        return action;
    }

    protected boolean addCreateLocalSimpleTypeActionIfNotExist(IMenuManager manager, String elementTag, String label, List attributes, Element parent, Node relativeNode) {
        if (this.getFirstChildNodeIfExists(parent, elementTag, false) == null) {
            this.addCreateLocalSimpleTypeAction(manager, elementTag, label, attributes, parent, relativeNode);
            return false;
        }
        return true;
    }

    protected void addSetBaseTypeAction(IMenuManager manager, Element element) {
        SetBaseTypeAction action = new SetBaseTypeAction(XSDEditorPlugin.getXSDString("_UI_ACTION_SET_BASE_TYPE"));
        action.setComplexTypeElement(element);
        action.setXSDSchema(this.getXSDSchema());
        action.setEnabled(!this.isReadOnly);
        manager.add((IAction)action);
    }

    protected void addCreateLocalSimpleTypeAction(IMenuManager manager, String elementTag, String label, List attributes, Element parent, Node relativeNode) {
        CreateLocalSimpleTypeAction action = new CreateLocalSimpleTypeAction(label);
        action.setElementTag(elementTag);
        action.setAttributes(attributes);
        action.setParentNode(parent);
        action.setRelativeNode(relativeNode);
        action.setXSDSchema(this.getXSDSchema());
        action.setSelectionProvider(this.selectionProvider);
        action.setEnabled(!this.isReadOnly);
        manager.add((IAction)action);
    }

    protected boolean addCreateLocalComplexTypeActionIfNotExist(IMenuManager manager, String elementTag, String label, List attributes, Element parent, Node relativeNode) {
        if (this.getFirstChildNodeIfExists(parent, elementTag, false) == null) {
            this.addCreateLocalComplexTypeAction(manager, elementTag, label, attributes, parent, relativeNode);
            return false;
        }
        return true;
    }

    protected void addCreateLocalComplexTypeAction(IMenuManager manager, String elementTag, String label, List attributes, Element parent, Node relativeNode) {
        CreateLocalComplexTypeAction action = new CreateLocalComplexTypeAction(label);
        action.setElementTag(elementTag);
        action.setAttributes(attributes);
        action.setParentNode(parent);
        action.setRelativeNode(relativeNode);
        action.setXSDSchema(this.getXSDSchema());
        action.setSelectionProvider(this.selectionProvider);
        action.setEnabled(!this.isReadOnly);
        manager.add((IAction)action);
    }

    protected boolean addCreateAnnotationActionIfNotExist(IMenuManager manager, String elementTag, String label, List attributes, Element parent, Node relativeNode) {
        return false;
    }

    protected void addOpenSchemaAction(IMenuManager manager, String label, Element parent) {
        OpenSchemaAction openAction = new OpenSchemaAction(label, this.getXSDSchema().getCorrespondingComponent((Node)parent));
        manager.add((IAction)openAction);
    }

    protected void addMoveAnonymousGlobal(IMenuManager manager, String elementTag, String label, List attributes, Element parent, Node relativeNode) {
    }

    protected void addRefactorMenuGroup(IMenuManager manager) {
        this.fRefactorMenuGroup = new RefactorActionGroup(this.selectionProvider, this.getXSDSchema());
        ActionContext context = new ActionContext(this.selectionProvider.getSelection());
        this.fRefactorMenuGroup.setContext(context);
        this.fRefactorMenuGroup.fillContextMenu(manager);
        this.fRefactorMenuGroup.setContext(null);
    }

    protected void addCreateAnnotationAction(IMenuManager manager, String elementTag, String label, List attributes, Element parent, Node relativeNode) {
        CreateAnnotationAction action = new CreateAnnotationAction(label);
        action.setElementTag(elementTag);
        action.setAttributes(attributes);
        action.setParentNode(parent);
        action.setRelativeNode(relativeNode);
        action.setEnabled(!this.isReadOnly);
        manager.add((IAction)action);
    }

    protected Node getFirstChildNodeIfExists(Node parent, String elementTag, boolean isRef) {
        if (parent == null) {
            return null;
        }
        NodeList children = parent.getChildNodes();
        Node targetNode = null;
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child != null && child instanceof Element && XSDDOMHelper.inputEquals((Element)child, elementTag, isRef)) {
                targetNode = child;
                break;
            }
            ++i;
        }
        return targetNode;
    }

    protected boolean elementExists(String elementTag, Element parent) {
        return parent.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", elementTag).getLength() > 0;
    }

    public DeleteAction getDeleteAction() {
        return this.deleteAction;
    }

    protected void addMultiplicityMenu(XSDConcreteComponent concreteComponent, IMenuManager manager) {
        SetMultiplicityAction oneMultiplicity = new SetMultiplicityAction(concreteComponent, "1");
        oneMultiplicity.setMaxOccurs(1);
        oneMultiplicity.setMinOccurs(1);
        oneMultiplicity.setEnabled(!this.isReadOnly);
        SetMultiplicityAction zeroOrMoreMultiplicity = new SetMultiplicityAction(concreteComponent, "0..* (" + XSDEditorPlugin.getXSDString("_ZERO_OR_MORE") + ")");
        zeroOrMoreMultiplicity.setMaxOccurs(-1);
        zeroOrMoreMultiplicity.setMinOccurs(0);
        zeroOrMoreMultiplicity.setEnabled(!this.isReadOnly);
        SetMultiplicityAction zeroOrOneMultiplicity = new SetMultiplicityAction(concreteComponent, "0..1 (" + XSDEditorPlugin.getXSDString("_ZERO_OR_ONE") + ")");
        zeroOrOneMultiplicity.setMaxOccurs(1);
        zeroOrOneMultiplicity.setMinOccurs(0);
        zeroOrOneMultiplicity.setEnabled(!this.isReadOnly);
        SetMultiplicityAction oneOrMoreMultiplicity = new SetMultiplicityAction(concreteComponent, "1..* (" + XSDEditorPlugin.getXSDString("_ONE_OR_MORE") + ")");
        oneOrMoreMultiplicity.setMaxOccurs(-1);
        oneOrMoreMultiplicity.setMinOccurs(1);
        oneOrMoreMultiplicity.setEnabled(!this.isReadOnly);
        MenuManager multiplicityMenu = new MenuManager(XSDEditorPlugin.getXSDString("_UI_ACTION_SET_MULTIPLICITY"));
        manager.add((IContributionItem)multiplicityMenu);
        multiplicityMenu.add((IAction)oneMultiplicity);
        multiplicityMenu.add((IAction)zeroOrOneMultiplicity);
        multiplicityMenu.add((IAction)zeroOrMoreMultiplicity);
        multiplicityMenu.add((IAction)oneOrMoreMultiplicity);
    }
}

