/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xsd.ui.internal.util.OpenOnSelectionHelper;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.impl.XSDImportImpl;

public class OpenSchemaAction
extends Action {
    XSDConcreteComponent component;
    boolean lastResult = false;

    public OpenSchemaAction(String label, XSDConcreteComponent component) {
        super(label);
        this.component = component;
    }

    public void run() {
        if (this.component != null) {
            this.revealObject();
        }
    }

    protected boolean revealObject() {
        String schemaLocation = "";
        if (this.component instanceof XSDSchemaDirective) {
            XSDSchemaDirective dir = (XSDSchemaDirective)this.component;
            if (dir instanceof XSDImportImpl) {
                ((XSDImportImpl)dir).importSchema();
            }
            if (dir.getResolvedSchema() != null && (schemaLocation = URIHelper.removePlatformResourceProtocol((String)dir.getResolvedSchema().getSchemaLocation())) != null) {
                OpenOnSelectionHelper.openXSDEditor(schemaLocation);
            }
        }
        return this.lastResult;
    }
}

