/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.commands;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.wst.xsd.ui.internal.commands.AbstractCommand;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDTypeDefinition;

public class AddAttributeDeclarationCommand
extends AbstractCommand {
    XSDAttributeDeclaration refAttribute = null;
    ArrayList names;

    public AddAttributeDeclarationCommand(XSDConcreteComponent parent) {
        super(parent);
    }

    public AddAttributeDeclarationCommand(XSDConcreteComponent parent, XSDAttributeDeclaration ref) {
        super(parent);
        this.refAttribute = ref;
    }

    public void run() {
        XSDConcreteComponent parent = this.getParent();
        if (parent instanceof XSDComplexTypeDefinition) {
            XSDComplexTypeDefinition ct = (XSDComplexTypeDefinition)parent;
            XSDAttributeDeclaration attribute = XSDFactory.eINSTANCE.createXSDAttributeDeclaration();
            attribute.setName(this.getNewName("Attribute"));
            attribute.setTypeDefinition(ct.getSchema().getSchemaForSchema().resolveSimpleTypeDefinition("string"));
            XSDAttributeUse attributeUse = XSDFactory.eINSTANCE.createXSDAttributeUse();
            attributeUse.setAttributeDeclaration(attribute);
            attributeUse.setContent(attribute);
            if (ct.getAttributeContents() != null) {
                ct.getAttributeContents().add((Object)attributeUse);
                this.formatChild(attribute.getElement());
            }
        }
    }

    protected boolean adopt(XSDConcreteComponent model) {
        return false;
    }

    protected String getNewName(String description) {
        String candidateName = "New" + description;
        XSDConcreteComponent parent = this.getParent();
        this.names = new ArrayList();
        int i = 1;
        if (parent instanceof XSDComplexTypeDefinition) {
            XSDComplexTypeDefinition ct = (XSDComplexTypeDefinition)parent;
            this.walkUpInheritance(ct);
            boolean ready = false;
            while (!ready) {
                ready = true;
                Iterator iter = this.names.iterator();
                while (iter.hasNext()) {
                    String attrName = (String)iter.next();
                    if (!candidateName.equals(attrName)) continue;
                    ready = false;
                    candidateName = "New" + description + String.valueOf(i);
                    ++i;
                }
            }
        }
        return candidateName;
    }

    private void walkUpInheritance(XSDComplexTypeDefinition ct) {
        this.updateNames(ct);
        XSDTypeDefinition typeDef = ct.getBaseTypeDefinition();
        if (ct != ct.getRootType() && typeDef instanceof XSDComplexTypeDefinition) {
            XSDComplexTypeDefinition ct2 = (XSDComplexTypeDefinition)typeDef;
            this.walkUpInheritance(ct2);
        }
    }

    private void updateNames(XSDComplexTypeDefinition ct) {
        Iterator iter = ct.getAttributeContents().iterator();
        while (iter.hasNext()) {
            XSDAttributeUse use;
            XSDAttributeDeclaration attr;
            String attrName;
            Object obj = iter.next();
            if (!(obj instanceof XSDAttributeUse) || (attrName = (attr = (use = (XSDAttributeUse)obj).getAttributeDeclaration()).getName()) == null) continue;
            this.names.add(attrName);
        }
    }
}

