/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.graph.editparts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.wst.xsd.ui.internal.graph.XSDChildUtility;
import org.eclipse.wst.xsd.ui.internal.graph.XSDGraphUtil;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.ComplexTypeInheritedContentEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.GraphNodeEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.editpolicies.ComponentNameDirectEditManager;
import org.eclipse.wst.xsd.ui.internal.graph.editpolicies.SimpleDirectEditPolicy;
import org.eclipse.wst.xsd.ui.internal.graph.figures.CenteredIconFigure;
import org.eclipse.wst.xsd.ui.internal.graph.figures.ContainerFigure;
import org.eclipse.wst.xsd.ui.internal.graph.figures.FillLayout;
import org.eclipse.wst.xsd.ui.internal.graph.figures.GraphNodeFigure;
import org.eclipse.wst.xsd.ui.internal.graph.figures.RoundedLineBorder;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDNamedComponent;

public class ComplexTypeDefinitionEditPart
extends GraphNodeEditPart {
    protected ContainerFigure contentFigure;
    protected Label label;
    protected SimpleDirectEditPolicy simpleDirectEditPolicy = new SimpleDirectEditPolicy();
    protected CenteredIconFigure centeredIconFigure;
    protected RectangleFigure preceedingSpace;
    protected ContainerFigure contentPane;

    public XSDComplexTypeDefinition getXSDComplexTypeDefinition() {
        return (XSDComplexTypeDefinition)this.getModel();
    }

    protected boolean isConnectedEditPart() {
        return false;
    }

    protected GraphNodeFigure createGraphNodeFigure() {
        GraphNodeFigure figure = new GraphNodeFigure();
        figure.getOutlinedArea().setBorder((Border)new RoundedLineBorder(1, 6));
        figure.getOutlinedArea().setFill(true);
        figure.getOutlinedArea().setLayoutManager((LayoutManager)new FillLayout(true));
        figure.getInnerContentArea().getContainerLayout().setHorizontal(true);
        this.preceedingSpace = new RectangleFigure();
        this.preceedingSpace.setVisible(false);
        figure.getInnerContentArea().add((IFigure)this.preceedingSpace, 0);
        this.contentPane = new ContainerFigure();
        this.contentPane.getContainerLayout().setHorizontal(false);
        this.contentPane.getContainerLayout().setSpacing(5);
        this.contentPane.setBorder((Border)new MarginBorder(5, 5, 5, 5));
        figure.getInnerContentArea().add((IFigure)this.contentPane);
        this.label = new Label();
        this.label.setBorder((Border)new MarginBorder(0, 5, 5, 5));
        figure.getIconArea().add((IFigure)this.label);
        this.label.setFont(mediumBoldFont);
        figure.getInnerContentArea().getContainerLayout().setSpacing(5);
        figure.getInnerContentArea().setBorder((Border)new MarginBorder(5, 5, 5, 5));
        return figure;
    }

    protected EditPart createChild(Object model) {
        ComplexTypeInheritedContentEditPart editPart = null;
        if (model == this.getModel()) {
            editPart = new ComplexTypeInheritedContentEditPart();
            editPart.setModel(model);
            editPart.setParent((EditPart)this);
        } else {
            editPart = super.createChild(model);
        }
        return editPart;
    }

    protected List getModelChildren() {
        ArrayList<Object> list = new ArrayList<Object>();
        XSDComplexTypeDefinition ct = (XSDComplexTypeDefinition)this.getModel();
        if (ct.getDerivationMethod().getName().equals("extension")) {
            list.add(this.getModel());
        }
        list.addAll(XSDChildUtility.getModelChildren(this.getModel()));
        return list;
    }

    public IFigure getContentPane() {
        return this.contentPane;
    }

    protected void refreshVisuals() {
        XSDComplexTypeDefinition ctd = (XSDComplexTypeDefinition)this.getModel();
        String name = ctd.getName();
        if (name == null) {
            try {
                if (this.label != null) {
                    this.graphNodeFigure.getIconArea().remove((IFigure)this.label);
                }
                this.label = null;
            }
            catch (Exception exception) {}
        } else {
            if (this.label == null) {
                this.label = new Label();
                this.label.setBorder((Border)new MarginBorder(0, 5, 5, 5));
                ((GraphNodeFigure)this.getFigure()).getIconArea().add((IFigure)this.label);
                this.label.setFont(mediumBoldFont);
            }
            this.graphNodeFigure.getIconArea().add((IFigure)this.label);
            this.label.setText(name);
        }
        boolean includesInheritedContent = this.getModelChildren().contains(this.getModel());
        this.preceedingSpace.setPreferredSize(includesInheritedContent ? new Dimension(10, 1) : new Dimension(0, 0));
        if (XSDGraphUtil.isEditable(this.getModel())) {
            this.graphNodeFigure.setForegroundColor(this.isSelected ? ColorConstants.black : elementBorderColor);
            if (this.label != null) {
                this.label.setForegroundColor(elementBorderColor);
            }
        } else {
            this.graphNodeFigure.setForegroundColor(this.isSelected ? ColorConstants.black : readOnlyBorderColor);
            if (this.label != null) {
                this.label.setForegroundColor(readOnlyBorderColor);
            }
        }
    }

    protected void performDirectEdit() {
        ComponentNameDirectEditManager manager = new ComponentNameDirectEditManager((GraphicalEditPart)this, this.label, (XSDNamedComponent)((XSDComplexTypeDefinition)this.getModel()));
        this.simpleDirectEditPolicy.setDelegate(manager);
        manager.show();
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)this.simpleDirectEditPolicy);
    }

    public void performRequest(Request request) {
        if ((request.getType() == "direct edit" || request.getType() == "open") && XSDGraphUtil.isEditable(this.getModel())) {
            LocationRequest locationRequest = (LocationRequest)request;
            Point p = locationRequest.getLocation();
            if (this.label != null && this.hitTest((IFigure)this.label, p)) {
                this.performDirectEdit();
            }
        }
    }

    public void doEditName() {
        this.performDirectEdit();
    }
}

