/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.graph.editparts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.graph.XSDChildUtility;
import org.eclipse.wst.xsd.ui.internal.graph.XSDGraphUtil;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.RepeatableGraphNodeEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.editpolicies.ComboBoxCellEditorManager;
import org.eclipse.wst.xsd.ui.internal.graph.editpolicies.ComponentNameDirectEditManager;
import org.eclipse.wst.xsd.ui.internal.graph.editpolicies.SimpleDirectEditPolicy;
import org.eclipse.wst.xsd.ui.internal.graph.figures.GraphNodeFigure;
import org.eclipse.wst.xsd.ui.internal.graph.figures.RepeatableGraphNodeFigure;
import org.eclipse.wst.xsd.ui.internal.graph.figures.RoundedLineBorder;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;

public class ModelGroupDefinitionEditPart
extends RepeatableGraphNodeEditPart {
    protected Label label;
    protected SimpleDirectEditPolicy simpleDirectEditPolicy = new SimpleDirectEditPolicy();

    public XSDModelGroupDefinition getXSDModelGroupDefinition() {
        return (XSDModelGroupDefinition)this.getModel();
    }

    protected boolean isConnectedEditPart() {
        return false;
    }

    public XSDParticle getXSDParticle() {
        XSDConcreteComponent o = this.getXSDModelGroupDefinition().getContainer();
        return o instanceof XSDParticle ? (XSDParticle)o : null;
    }

    protected GraphNodeFigure createGraphNodeFigure() {
        RepeatableGraphNodeFigure figure = new RepeatableGraphNodeFigure();
        figure.getOutlinedArea().setBorder((Border)new RoundedLineBorder(1, 6));
        figure.getInnerContentArea().setBorder((Border)new MarginBorder(10, 0, 10, 0));
        this.label = new Label();
        this.label.setFont(mediumBoldFont);
        figure.getIconArea().add((IFigure)this.label);
        return figure;
    }

    public IFigure getContentPane() {
        return this.graphNodeFigure.getInnerContentArea();
    }

    protected List getModelChildren() {
        return XSDChildUtility.getModelChildren(this.getModel());
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)this.simpleDirectEditPolicy);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        if (this.getXSDModelGroupDefinition().isModelGroupDefinitionReference()) {
            this.label.setText(this.getXSDModelGroupDefinition().getResolvedModelGroupDefinition().getQName());
            this.label.setIcon(XSDEditorPlugin.getXSDImage("icons/GraphViewElementRef.gif"));
            this.label.setBorder((Border)new MarginBorder(0, 0, 0, 4));
        } else {
            this.label.setText(this.getXSDModelGroupDefinition().getName());
            this.label.setIcon(null);
            this.label.setBorder((Border)new MarginBorder(0, 6, 0, 4));
        }
        if (XSDGraphUtil.isEditable(this.getModel())) {
            this.graphNodeFigure.getOutlinedArea().setForegroundColor(this.isSelected ? ColorConstants.black : elementBorderColor);
            this.label.setForegroundColor(elementLabelColor);
        } else {
            this.graphNodeFigure.getOutlinedArea().setForegroundColor(readOnlyBackgroundColor);
            this.label.setForegroundColor(readOnlyBackgroundColor);
        }
        this.refreshOccurenceLabel(this.getXSDParticle());
    }

    protected void performDirectEdit() {
        if (this.getXSDModelGroupDefinition().isModelGroupDefinitionReference()) {
            ComboBoxCellEditorManager manager = new ComboBoxCellEditorManager((GraphicalEditPart)this, this.label){

                protected List computeComboContent() {
                    XSDSchema schema = ModelGroupDefinitionEditPart.this.getXSDModelGroupDefinition().getSchema();
                    List nameList = new ArrayList();
                    if (schema != null) {
                        TypesHelper typesHelper = new TypesHelper(schema);
                        nameList = typesHelper.getModelGroups();
                    }
                    return nameList;
                }

                public void performModify(String value) {
                    Display.getCurrent().asyncExec((Runnable)new DelayedModelGroupRenameAction(ModelGroupDefinitionEditPart.this.getXSDModelGroupDefinition(), value));
                }
            };
            this.simpleDirectEditPolicy.setDelegate(manager);
            manager.show();
        } else {
            ComponentNameDirectEditManager manager = new ComponentNameDirectEditManager((GraphicalEditPart)this, this.label, (XSDNamedComponent)this.getXSDModelGroupDefinition());
            this.simpleDirectEditPolicy.setDelegate(manager);
            manager.show();
        }
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit" && XSDGraphUtil.isEditable(this.getModel())) {
            this.performDirectEdit();
        }
    }

    public void doEditName() {
        ComponentNameDirectEditManager manager = new ComponentNameDirectEditManager((GraphicalEditPart)this, this.label, (XSDNamedComponent)this.getXSDModelGroupDefinition());
        this.simpleDirectEditPolicy.setDelegate(manager);
        manager.show();
    }

    protected class DelayedModelGroupRenameAction
    implements Runnable {
        XSDModelGroupDefinition modelGroupDefinition;
        String value;

        DelayedModelGroupRenameAction(XSDModelGroupDefinition modelGroupDefinition, String value) {
            this.modelGroupDefinition = modelGroupDefinition;
            this.value = value;
        }

        public void run() {
            this.modelGroupDefinition.getElement().setAttribute("ref", this.value);
        }
    }
}

