/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties.section;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.xsd.ui.internal.provider.XSDAbstractAdapter;
import org.eclipse.wst.xsd.ui.internal.provider.XSDAdapterFactoryLabelProvider;
import org.eclipse.wst.xsd.ui.internal.provider.XSDModelAdapterFactoryImpl;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupContent;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;

public class AttributesViewContentProvider
implements ITreeContentProvider,
ITableLabelProvider,
ILabelProvider,
INotifyChangedListener {
    IEditorPart editorPart;
    static XSDModelAdapterFactoryImpl xsdModelAdapterFactory = XSDModelAdapterFactoryImpl.getInstance();
    static XSDAdapterFactoryLabelProvider adapterFactoryLabelProvider = new XSDAdapterFactoryLabelProvider(xsdModelAdapterFactory);
    XSDAbstractAdapter elementAdapter;
    XSDAbstractAdapter ctAdapter;
    XSDComplexTypeDefinition ct;
    Viewer attributesViewer;
    Viewer viewer;

    public AttributesViewContentProvider() {
    }

    public AttributesViewContentProvider(IEditorPart editorPart, Viewer viewer) {
        this.editorPart = editorPart;
        this.attributesViewer = viewer;
    }

    public Object[] getChildren(Object inputElement) {
        ArrayList<Object> list = new ArrayList<Object>();
        this.ct = null;
        if (inputElement instanceof XSDElementDeclaration) {
            XSDElementDeclaration xsdElement = (XSDElementDeclaration)inputElement;
            if (this.elementAdapter != null) {
                this.elementAdapter.removeListener(this);
            }
            this.elementAdapter = (XSDAbstractAdapter)xsdModelAdapterFactory.adapt((Notifier)xsdElement, (Object)xsdModelAdapterFactory);
            this.elementAdapter.addListener(this);
            if (xsdElement.getAnonymousTypeDefinition() instanceof XSDComplexTypeDefinition) {
                this.ct = (XSDComplexTypeDefinition)xsdElement.getAnonymousTypeDefinition();
            } else {
                XSDTypeDefinition xsdType = xsdElement.getTypeDefinition();
                if (xsdType instanceof XSDComplexTypeDefinition) {
                    this.ct = (XSDComplexTypeDefinition)xsdType;
                }
            }
        } else if (inputElement instanceof XSDComplexTypeDefinition) {
            this.ct = (XSDComplexTypeDefinition)inputElement;
        }
        if (this.ct != null) {
            if (this.ctAdapter != null) {
                this.ctAdapter.removeListener(this);
            }
            this.ctAdapter = (XSDAbstractAdapter)xsdModelAdapterFactory.adapt((Notifier)this.ct, (Object)xsdModelAdapterFactory);
            this.ctAdapter.addListener(this);
            XSDWildcard wildcard = this.ct.getAttributeWildcardContent();
            if (wildcard != null) {
                list.add(wildcard);
            }
            Iterator i = this.ct.getAttributeContents().iterator();
            while (i.hasNext()) {
                XSDAbstractAdapter a;
                XSDAttributeGroupContent attributeGroupContent = (XSDAttributeGroupContent)i.next();
                if (attributeGroupContent instanceof XSDAttributeGroupDefinition) {
                    XSDAttributeGroupDefinition attributeGroupDefinition = (XSDAttributeGroupDefinition)attributeGroupContent;
                    XSDAbstractAdapter a2 = (XSDAbstractAdapter)xsdModelAdapterFactory.adapt((Notifier)attributeGroupDefinition, (Object)xsdModelAdapterFactory);
                    a2.removeListener(this);
                    a2.addListener(this);
                    list.add(attributeGroupDefinition);
                    continue;
                }
                if (!(attributeGroupContent instanceof XSDAttributeUse)) continue;
                XSDAttributeUse attributeUse = (XSDAttributeUse)attributeGroupContent;
                XSDAttributeDeclaration attribute = attributeUse.getAttributeDeclaration();
                boolean isRef = XSDDOMHelper.isAttributeRef(this.ct.getElement(), attribute.getQName(), attribute.getTargetNamespace());
                if (isRef) {
                    a = (XSDAbstractAdapter)xsdModelAdapterFactory.adapt((Notifier)attributeUse, (Object)xsdModelAdapterFactory);
                    a.removeListener(this);
                    a.addListener(this);
                    list.add(attributeUse);
                    continue;
                }
                a = (XSDAbstractAdapter)xsdModelAdapterFactory.adapt((Notifier)attribute, (Object)xsdModelAdapterFactory);
                a.removeListener(this);
                a.addListener(this);
                list.add(attribute);
            }
        }
        return list.toArray();
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return false;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof XSDConcreteComponent) {
            return adapterFactoryLabelProvider.getImage((XSDConcreteComponent)element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof XSDConcreteComponent) {
            XSDAbstractAdapter a = (XSDAbstractAdapter)xsdModelAdapterFactory.adapt((Notifier)((XSDConcreteComponent)element), (Object)xsdModelAdapterFactory);
            return a.getText((XSDConcreteComponent)element);
        }
        return "";
    }

    public Image getImage(Object element) {
        if (element instanceof XSDConcreteComponent) {
            return adapterFactoryLabelProvider.getImage((XSDConcreteComponent)element);
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof XSDConcreteComponent) {
            XSDAbstractAdapter a = (XSDAbstractAdapter)xsdModelAdapterFactory.adapt((Notifier)((XSDConcreteComponent)element), (Object)xsdModelAdapterFactory);
            return a.getText((XSDConcreteComponent)element);
        }
        return "";
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        if (this.elementAdapter != null) {
            this.elementAdapter.removeListener(this);
        }
        if (this.ctAdapter != null) {
            this.ctAdapter.removeListener(this);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void notifyChanged(Notification notification) {
        if (this.attributesViewer != null && !this.attributesViewer.getControl().isDisposed() && this.attributesViewer instanceof StructuredViewer) {
            this.attributesViewer.refresh();
        }
    }
}

