/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties.section;

import java.util.ArrayList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.wst.common.ui.properties.internal.provisional.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.XSDMenuListener;
import org.eclipse.wst.xsd.ui.internal.actions.AddAttributeAction;
import org.eclipse.wst.xsd.ui.internal.actions.CreateAttributeAndRequired;
import org.eclipse.wst.xsd.ui.internal.actions.DOMAttribute;
import org.eclipse.wst.xsd.ui.internal.actions.DeleteAction;
import org.eclipse.wst.xsd.ui.internal.properties.XSDPropertySourceProvider;
import org.eclipse.wst.xsd.ui.internal.properties.section.AbstractSection;
import org.eclipse.wst.xsd.ui.internal.properties.section.AttributesViewContentProvider;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AttributesViewSection
extends AbstractSection
implements ISelectionChangedListener {
    AttributeTableTreeViewer viewer;
    AttributesPropertySheetPage propertySheetPage;

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        SashForm sashForm = new SashForm(this.composite, 256);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        sashForm.setLayoutData((Object)data);
        this.viewer = new AttributeTableTreeViewer((Composite)sashForm);
        this.propertySheetPage = new AttributesPropertySheetPage();
        this.propertySheetPage.createControl((Composite)sashForm);
        AttributesViewContentProvider provider = new AttributesViewContentProvider(this.getActiveEditor(), (Viewer)this.viewer);
        this.viewer.setContentProvider((IContentProvider)provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)provider);
        this.viewer.addSelectionChangedListener(this);
        this.propertySheetPage.setPropertySourceProvider(new XSDPropertySourceProvider());
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        XSDElementDeclaration elementDeclaration;
        super.setInput(part, selection);
        if (this.input instanceof XSDElementDeclaration && (elementDeclaration = (XSDElementDeclaration)this.input).isElementDeclarationReference()) {
            this.input = elementDeclaration.getResolvedElementDeclaration();
            this.isReadOnly = elementDeclaration.getResolvedElementDeclaration().getRootContainer() != this.xsdSchema;
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.propertySheetPage.selectionChanged(this.part, event.getSelection());
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    public void aboutToBeShown() {
        this.refresh();
    }

    public void refresh() {
        if (this.isReadOnly) {
            this.composite.setEnabled(false);
        } else {
            this.composite.setEnabled(true);
        }
        this.setListenerEnabled(false);
        if (this.viewer != null) {
            this.viewer.setInput(this.getInput());
            this.viewer.refresh();
        }
        this.setListenerEnabled(true);
    }

    public void dispose() {
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    class AttributeTableTreeViewer
    extends TreeViewer {
        public AttributeTableTreeViewer(Composite c) {
            super(c);
            MenuManager menuManager = new MenuManager("#popup");
            menuManager.setRemoveAllWhenShown(true);
            Menu menu = menuManager.createContextMenu((Control)this.getTree());
            this.getTree().setMenu(menu);
            XSDAttributeMenuListener menuListener = new XSDAttributeMenuListener(this);
            menuManager.addMenuListener((IMenuListener)menuListener);
        }

        public class XSDAttributeMenuListener
        extends XSDMenuListener {
            public XSDAttributeMenuListener(TreeViewer viewer) {
                super((ISelectionProvider)viewer);
                this.selectionProvider = viewer;
                this.deleteAction = new DeleteAction(XSDEditorPlugin.getXSDString("_UI_ACTION_DELETE"), AttributesViewSection.this.getActiveEditor(), this.getXSDSchema());
                this.deleteAction.setSelectionProvider(this.selectionProvider);
                this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.deleteAction);
            }

            protected XSDSchema getXSDSchema() {
                return this.xsdSchema;
            }

            protected Object getSelectedElement() {
                XSDComponent xsdInput = (XSDComponent)AttributesViewSection.this.getInput();
                if (xsdInput instanceof XSDElementDeclaration) {
                    XSDElementDeclaration xsdElement = (XSDElementDeclaration)xsdInput;
                    XSDTypeDefinition xsdType = xsdElement.getType();
                    if (xsdType instanceof XSDComplexTypeDefinition) {
                        XSDComplexTypeDefinition ct = (XSDComplexTypeDefinition)xsdType;
                        return ct;
                    }
                    return xsdElement;
                }
                if (xsdInput instanceof XSDComplexTypeDefinition) {
                    return xsdInput;
                }
                return null;
            }

            public void menuAboutToShow(IMenuManager manager) {
                this.updateXSDSchema();
                if (this.xsdSchema == null) {
                    return;
                }
                Object selectedElementObj = this.getSelectedElement();
                Element selectedElement = null;
                if (selectedElementObj instanceof XSDComplexTypeDefinition) {
                    selectedElement = ((XSDComplexTypeDefinition)selectedElementObj).getElement();
                }
                this.addContextItems(manager, selectedElement, null);
                if (!this.selectionProvider.getSelection().isEmpty()) {
                    manager.add((IContributionItem)new Separator());
                    if (this.deleteAction != null) {
                        this.deleteAction.setXSDSchema(this.getXSDSchema());
                        manager.add((IAction)this.deleteAction);
                    }
                }
            }

            protected void addContextItems(IMenuManager manager, Element parent, Node relativeNode) {
                ArrayList<DOMAttribute> attributes = null;
                if (XSDDOMHelper.inputEquals(parent, "complexType", false)) {
                    boolean complexOrSimpleContentExists = false;
                    boolean anyAttributeExists = false;
                    Element contentNode = null;
                    Node anyAttributeNode = null;
                    NodeList children = parent.getChildNodes();
                    int i = 0;
                    while (i < children.getLength()) {
                        Node child = children.item(i);
                        if (child != null && child instanceof Element) {
                            if (XSDDOMHelper.inputEquals((Element)child, "sequence", false) || XSDDOMHelper.inputEquals((Element)child, "all", false) || XSDDOMHelper.inputEquals((Element)child, "choice", false) || XSDDOMHelper.inputEquals((Element)child, "group", true) || XSDDOMHelper.inputEquals((Element)child, "simpleContent", false) || XSDDOMHelper.inputEquals((Element)child, "complexContent", false)) {
                                contentNode = (Element)child;
                                if (XSDDOMHelper.inputEquals((Element)child, "simpleContent", false) || XSDDOMHelper.inputEquals((Element)child, "complexContent", false)) {
                                    complexOrSimpleContentExists = true;
                                }
                            } else if (XSDDOMHelper.inputEquals((Element)child, "anyAttribute", false)) {
                                anyAttributeExists = true;
                                anyAttributeNode = child;
                            }
                        }
                        ++i;
                    }
                    if (anyAttributeExists) {
                        if (!complexOrSimpleContentExists) {
                            attributes = new ArrayList();
                            attributes.add(new DOMAttribute("name", this.getNewName(parent, "attribute", "Attribute", false)));
                            attributes.add(new DOMAttribute("type", this.getBuiltInStringQName()));
                            this.addCreateElementAction(manager, "attribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE"), attributes, parent, anyAttributeNode);
                            attributes = null;
                            this.addCreateElementRefAction(manager, "attribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE_REFERENCE"), parent, anyAttributeNode);
                            this.addCreateElementRefAction(manager, "attributeGroup", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE_GROUP_REF"), parent, anyAttributeNode);
                        }
                    } else if (!complexOrSimpleContentExists) {
                        attributes = new ArrayList();
                        attributes.add(new DOMAttribute("name", this.getNewName(parent, "attribute", "Attribute", false)));
                        attributes.add(new DOMAttribute("type", this.getBuiltInStringQName()));
                        this.addCreateElementAction(manager, "attribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE"), attributes, parent, parent.getLastChild());
                        attributes = null;
                        this.addCreateElementRefAction(manager, "attribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE_REFERENCE"), parent, parent.getLastChild());
                        this.addCreateElementRefAction(manager, "attributeGroup", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE_GROUP_REF"), parent, parent.getLastChild());
                        attributes = null;
                        this.addCreateElementActionIfNotExist(manager, "anyAttribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANY_ATTRIBUTE"), attributes, parent, parent.getLastChild());
                    } else {
                        XSDComplexTypeDefinition xsdCT = (XSDComplexTypeDefinition)this.getXSDSchema().getCorrespondingComponent((Node)parent);
                        manager.add((IAction)new AddAttributeAction(XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE"), (XSDConcreteComponent)xsdCT));
                        Element derivedByElement = ((AttributeTableTreeViewer)AttributeTableTreeViewer.this).AttributesViewSection.this.domHelper.getDerivedByElement(contentNode);
                        if (derivedByElement != null) {
                            attributes = null;
                            this.addCreateElementRefAction(manager, "attribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE_REFERENCE"), derivedByElement, derivedByElement.getLastChild());
                            this.addCreateElementRefAction(manager, "attributeGroup", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE_GROUP_REF"), derivedByElement, derivedByElement.getLastChild());
                            attributes = null;
                            this.addCreateElementActionIfNotExist(manager, "anyAttribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANY_ATTRIBUTE"), attributes, derivedByElement, derivedByElement.getLastChild());
                        }
                    }
                } else if (parent == null) {
                    XSDElementDeclaration ed = (XSDElementDeclaration)((AttributeTableTreeViewer)AttributeTableTreeViewer.this).AttributesViewSection.this.input;
                    attributes = new ArrayList<DOMAttribute>();
                    attributes.add(new DOMAttribute("name", this.getNewName(parent, "attribute", "Attribute", false)));
                    attributes.add(new DOMAttribute("type", this.getBuiltInStringQName()));
                    manager.add((IAction)new CreateAttributeAndRequired("attribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE"), attributes, this.getXSDSchema(), this.selectionProvider, ed));
                    attributes = null;
                    attributes = new ArrayList();
                    String ref = this.getFirstGlobalElementTagName("attribute");
                    attributes.add(new DOMAttribute("ref", ref));
                    CreateAttributeAndRequired action = new CreateAttributeAndRequired("attribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE_REFERENCE"), attributes, this.getXSDSchema(), this.selectionProvider, ed);
                    manager.add((IAction)action);
                    action.setEnabled(ref != null);
                    attributes = null;
                    attributes = new ArrayList();
                    ref = this.getFirstGlobalElementTagName("attributeGroup");
                    attributes.add(new DOMAttribute("ref", ref));
                    action = new CreateAttributeAndRequired("attributeGroup", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ATTRIBUTE_GROUP_REF"), attributes, this.getXSDSchema(), this.selectionProvider, ed);
                    manager.add((IAction)action);
                    action.setEnabled(ref != null);
                    attributes = null;
                    if (this.getFirstChildNodeIfExists(parent, "anyAttribute", false) == null) {
                        action = new CreateAttributeAndRequired("anyAttribute", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ANY_ATTRIBUTE"), attributes, this.getXSDSchema(), this.selectionProvider, ed);
                        manager.add((IAction)action);
                    }
                }
            }
        }
    }

    class AttributesPropertySheetPage
    extends PropertySheetPage
    implements INotifyChangedListener {
        public void notifyChanged(Notification notification) {
            System.out.println("Notification");
        }
    }
}

