/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties.section;

import org.eclipse.core.resources.IFile;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.common.ui.properties.internal.provisional.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.xsd.XSDComponentSelectionDialog;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.xsd.XSDComponentSelectionProvider;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.xsd.XSDSetTypeHelper;
import org.eclipse.wst.xsd.ui.internal.properties.section.AbstractSection;
import org.eclipse.wst.xsd.ui.internal.widgets.TypeSection;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TypesSection
extends AbstractSection {
    Text typeCombo;
    Button button;
    String type;
    Object typeObject;
    CLabel typeLabel;
    Table table;
    TypeSection typeSection;
    boolean showAnonymous = true;
    String previousStringType = "";
    boolean isAnonymous;
    int previousType;
    boolean showComplexTypes = true;

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.typeCombo = this.getWidgetFactory().createText(this.composite, "");
        this.typeCombo.setEditable(false);
        this.typeCombo.addListener(24, (Listener)this);
        this.button = this.getWidgetFactory().createButton(this.composite, "", 8);
        this.button.setImage(XSDEditorPlugin.getXSDImage("icons/browsebutton.gif"));
        this.typeLabel = this.getWidgetFactory().createCLabel(this.composite, String.valueOf(XSDEditorPlugin.getXSDString("_UI_LABEL_TYPE")) + ":");
        this.button.addSelectionListener((SelectionListener)this);
        FormData data2 = new FormData();
        data2.left = new FormAttachment(100, -this.rightMarginSpace + 2);
        data2.right = new FormAttachment(100, 0);
        data2.top = new FormAttachment((Control)this.typeCombo, 0, 0x1000000);
        this.button.setLayoutData((Object)data2);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 100);
        data.right = new FormAttachment((Control)this.button, 0);
        this.typeCombo.setLayoutData((Object)data);
    }

    public void refresh() {
        Object input = this.getInput();
        if (this.isReadOnly) {
            this.composite.setEnabled(false);
        } else {
            this.composite.setEnabled(true);
        }
        this.typeCombo.setText("");
        if (input != null) {
            Element element = null;
            if (input instanceof XSDElementDeclaration) {
                XSDElementDeclaration xsdElem = (XSDElementDeclaration)input;
                element = xsdElem.getElement();
                XSDTypeDefinition typeDef = xsdElem.getTypeDefinition();
                boolean isAnonymous = xsdElem.isAbstract();
                if (isAnonymous) {
                    this.typeCombo.setText("**anonymous**");
                } else {
                    String typeName = "";
                    if (typeDef != null) {
                        typeName = typeDef.getQName((XSDConcreteComponent)this.getSchema());
                        if (typeName == null) {
                            typeName = "";
                        }
                        this.typeCombo.setText(typeName);
                    } else {
                        this.typeCombo.setText(XSDEditorPlugin.getXSDString("_UI_NO_TYPE"));
                    }
                }
            } else if (input instanceof XSDAttributeDeclaration) {
                element = ((XSDAttributeDeclaration)input).getElement();
            } else if (input instanceof XSDAttributeUse) {
                XSDAttributeUse attributeUse = (XSDAttributeUse)input;
                XSDAttributeDeclaration attribute = attributeUse.getAttributeDeclaration();
                element = attribute.getElement();
            } else if (input instanceof Element) {
                element = (Element)input;
            }
            this.typeLabel.setText(String.valueOf(XSDEditorPlugin.getXSDString("_UI_LABEL_TYPE")) + ":");
            if (element != null) {
                boolean isAnonymous = this.checkForAnonymousType(element);
                String result = element.getAttribute("type");
                if (isAnonymous) {
                    this.typeCombo.setText("**anonymous**");
                }
                if (result != null && result.equals("")) {
                    this.typeCombo.setText(XSDEditorPlugin.getXSDString("_UI_NO_TYPE"));
                } else if (result != null) {
                    this.typeCombo.setText(result);
                }
            }
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.button) {
            Shell shell = Display.getCurrent().getActiveShell();
            IFile currentIFile = ((IFileEditorInput)this.getActiveEditor().getEditorInput()).getFile();
            Object input = this.getInput();
            XSDSchema schema = null;
            if (input instanceof XSDConcreteComponent) {
                schema = ((XSDConcreteComponent)input).getSchema();
            }
            XSDComponentSelectionProvider provider = new XSDComponentSelectionProvider(currentIFile, schema);
            XSDComponentSelectionDialog dialog = new XSDComponentSelectionDialog(shell, XSDEditorPlugin.getXSDString("_UI_LABEL_SET_TYPE"), provider);
            if (input instanceof XSDAttributeDeclaration) {
                provider.showComplexTypes(false);
            }
            provider.setDialog(dialog);
            dialog.setBlockOnOpen(true);
            dialog.create();
            if (dialog.open() == 0) {
                Element element = ((XSDConcreteComponent)this.getInput()).getElement();
                XSDSetTypeHelper helper = new XSDSetTypeHelper(currentIFile, schema);
                helper.setType(element, "type", dialog.getSelection());
            }
        }
    }

    boolean checkForAnonymousType(Element element) {
        boolean isAnonymous = false;
        Node aNode = this.getDomHelper().getChildNode(element, "simpleType");
        if (aNode != null) {
            return true;
        }
        aNode = this.getDomHelper().getChildNode(element, "complexType");
        if (aNode != null) {
            isAnonymous = true;
        }
        return isAnonymous;
    }

    public boolean shouldUseExtraSpace() {
        return false;
    }
}

