/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.server.internal.ui.explorer.actions.popup;

import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonActionProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentService;
import org.eclipse.wst.rdb.server.internal.ui.explorer.ServerExplorerNav;
import org.eclipse.wst.rdb.server.internal.ui.explorer.providers.bookmark.BookmarkProvider;
import org.eclipse.wst.rdb.server.internal.ui.explorer.providers.bookmark.BookmarkSelectionProvider;

public class BookmarkAction
implements ICommonActionProvider {
    private BookmarkProvider bookmarkProvider = null;
    private BookmarkSelectionProvider bookmarkSelectionProvider = null;
    private IViewPart aViewPart;
    private IStructuredSelection selection;

    private boolean isSelectionValid(IStructuredSelection selection) {
        if (selection == null) {
            return false;
        }
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            Object selected = iterator.next();
            if (selected instanceof EObject) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        this.aViewPart.getViewSite().getActionBars().setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), null);
        if (this.bookmarkProvider != null) {
            this.bookmarkProvider.removeListener();
            this.bookmarkSelectionProvider.removeListener();
        }
    }

    public void init(IViewPart aViewPart, StructuredViewer aViewer, NavigatorContentService aContentService) {
        this.aViewPart = aViewPart;
        if (this.aViewPart instanceof ServerExplorerNav) {
            this.bookmarkProvider = new BookmarkProvider(this.aViewPart);
            this.bookmarkSelectionProvider = new BookmarkSelectionProvider();
        }
    }

    public void setActionContext(ActionContext aContext) {
        if (aContext.getSelection() instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)aContext.getSelection();
        }
    }

    public boolean fillContextMenu(IMenuManager aMenu) {
        return false;
    }

    public boolean fillActionBars(IActionBars bars) {
        if (this.aViewPart instanceof ServerExplorerNav && this.isSelectionValid(this.selection)) {
            bars.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), (IAction)this.bookmarkProvider);
            bars.updateActionBars();
            bars.getMenuManager().update();
            return true;
        }
        return false;
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }
}

