/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.navigator.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.CommonWorkingSetProviderDescriptor;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.CommonWorkingSetProviderRegistry;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.wst.common.navigator.internal.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.views.extensions.RegistryReader;

public class CommonWorkingSetDescriptorRegistry {
    private static final CommonWorkingSetProviderRegistry INSTANCE = new CommonWorkingSetProviderRegistry();
    private static boolean isInitialized = false;
    private static final String[] NO_DESCRIPTORS = new String[0];
    private List commonWorkingSetDescriptors = new ArrayList();

    public void init() {
        new CommonWorkingSetRegistryReader().readRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommonWorkingSetProviderRegistry getInstance() {
        if (isInitialized) {
            return INSTANCE;
        }
        CommonWorkingSetProviderRegistry commonWorkingSetProviderRegistry = INSTANCE;
        synchronized (commonWorkingSetProviderRegistry) {
            if (!isInitialized) {
                INSTANCE.init();
                isInitialized = true;
            }
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCommonWorkingSetDescriptor(CommonWorkingSetProviderDescriptor aDesc) {
        if (aDesc == null) {
            return;
        }
        List list = this.commonWorkingSetDescriptors;
        synchronized (list) {
            boolean bValue = this.commonWorkingSetDescriptors.contains(aDesc);
            if (!bValue) {
                this.commonWorkingSetDescriptors.add(aDesc);
            }
        }
    }

    public CommonWorkingSetProviderDescriptor[] getCommonWorkingSetDescriptors() {
        CommonWorkingSetProviderDescriptor[] descriptors = new CommonWorkingSetProviderDescriptor[this.commonWorkingSetDescriptors.size()];
        return this.commonWorkingSetDescriptors.toArray(descriptors);
    }

    class CommonWorkingSetRegistryReader
    extends RegistryReader {
        private static final String COMMON_WORKING_SET = "workingSetProviders";

        CommonWorkingSetRegistryReader() {
            super("org.eclipse.jst.common.navigator.java", COMMON_WORKING_SET);
        }

        protected boolean readElement(IConfigurationElement anElement) {
            if (COMMON_WORKING_SET.equals(anElement.getName())) {
                try {
                    CommonWorkingSetDescriptorRegistry.this.addCommonWorkingSetDescriptor(new CommonWorkingSetProviderDescriptor(anElement));
                    return true;
                }
                catch (WorkbenchException e) {
                    WorkbenchNavigatorPlugin.log((String)"Unable to create common working set descriptor.", (IStatus)e.getStatus());
                }
            }
            return false;
        }
    }
}

