/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.actions;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.actions.WSDLDragAction;
import org.eclipse.wst.wsdl.ui.internal.commands.AddOperationCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.WSDLElementCommand;
import org.eclipse.wst.wsdl.ui.internal.graph.editparts.WSDLTreeNodeEditPart;
import org.eclipse.wst.wsdl.ui.internal.util.NameUtil;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;
import org.w3c.dom.Node;

public class CopyWSDLElementAction
extends WSDLDragAction {
    WSDLElement element;
    WSDLElement parent;
    Node parentNode;
    WSDLElementCommand wsdlElementCommand;
    EditPartViewer editPartViewer;

    public CopyWSDLElementAction(EditPartViewer editPartViewer, WSDLElement element, WSDLElement parent, Node parentNode) {
        this.setText("Copy WSDLElement");
        this.element = element;
        this.parent = parent;
        this.parentNode = parentNode;
        this.editPartViewer = editPartViewer;
    }

    public boolean canExecute() {
        if (this.element instanceof Operation && this.parent instanceof PortType) {
            PortType pt = (PortType)this.parent;
            Operation op = (Operation)this.element;
            this.wsdlElementCommand = new AddOperationCommand(pt, op, NameUtil.buildUniqueOperationName(pt, op.getName()), true);
        }
        return this.wsdlElementCommand != null;
    }

    public void run() {
        if (this.wsdlElementCommand == null) {
            if (this.canExecute()) {
                this.runCommand();
            }
        } else {
            this.runCommand();
        }
    }

    private void runCommand() {
        this.beginRecording();
        this.wsdlElementCommand.run();
        this.selectWSDLElement(this.wsdlElementCommand.getWSDLElement());
        this.endRecording();
    }

    private void selectWSDLElement(WSDLElement element) {
        Map editPartMap = this.editPartViewer.getEditPartRegistry();
        WSDLTreeNodeEditPart wsdlEditPart = (WSDLTreeNodeEditPart)editPartMap.get(element);
        if (wsdlEditPart != null) {
            this.editPartViewer.select((EditPart)wsdlEditPart);
            this.expandEditParts(element, true);
        }
    }

    private void expandEditParts(Object element, boolean expandChildren) {
        if (element != null) {
            Map editPartMap = this.editPartViewer.getEditPartRegistry();
            WSDLTreeNodeEditPart wsdlEditPart = (WSDLTreeNodeEditPart)editPartMap.get(element);
            wsdlEditPart.setExpanded(true);
            if (expandChildren) {
                Iterator iterator = WSDLEditorUtil.getModelGraphViewChildren(element).iterator();
                while (iterator.hasNext()) {
                    this.expandEditParts(iterator.next(), expandChildren);
                }
            }
        }
    }

    public Node getNode() {
        return this.parentNode;
    }

    public String getUndoDescription() {
        return WSDLEditorPlugin.getWSDLString("_UI_ACTION_COPY");
    }
}

