/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.actions;

import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditor;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.actions.CopyWSDLElementAction;
import org.w3c.dom.Node;

public class PasteGlobalAction
extends Action {
    private IEditorPart editor;
    private WSDLElement selection;
    private Node selectionNode;

    public PasteGlobalAction(WSDLElement selection, IEditorPart editor) {
        this.setText(WSDLEditorPlugin.getWSDLString("_UI_ACTION_PASTE"));
        this.selection = selection;
        this.editor = editor;
        this.selectionNode = selection.getElement();
        this.setEnabledState();
    }

    public void run() {
        if (this.editor instanceof WSDLEditor) {
            WSDLEditor wsdlEditor = (WSDLEditor)this.editor;
            CopyWSDLElementAction copyAction = new CopyWSDLElementAction((EditPartViewer)wsdlEditor.getGraphViewer().getComponentViewer(), wsdlEditor.getClipboardContents(), this.selection, this.selectionNode);
            copyAction.run();
        }
    }

    public void setSelection(WSDLElement newSelection) {
        this.selection = newSelection;
        this.setEnabledState();
    }

    protected void setEnabledState() {
        WSDLElement parentElement = null;
        parentElement = this.showPasteAction(this.selection, this.editor);
        if (parentElement != null) {
            this.selection = parentElement;
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    private WSDLElement showPasteAction(WSDLElement element, IEditorPart ePart) {
        WSDLElement parentElement = null;
        if (ePart instanceof WSDLEditor) {
            WSDLElement clipboardElement = ((WSDLEditor)ePart).getClipboardContents();
            if (element instanceof PortType && clipboardElement instanceof Operation) {
                parentElement = element;
            }
            if (element instanceof Operation && clipboardElement instanceof Operation) {
                parentElement = (WSDLElement)((Operation)element).eContainer();
            }
        }
        return parentElement;
    }
}

