/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.parameters;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.MessageReference;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;

public class WNameHelperUtil {
    public static String getMessageName(MessageReference messageRef) {
        String messageName = "NewMessage";
        ArrayList<String> messageNames = new ArrayList<String>();
        Operation operation = (Operation)messageRef.getContainer();
        Iterator messageIt = operation.getEnclosingDefinition().getEMessages().iterator();
        while (messageIt.hasNext()) {
            messageNames.add(((Message)messageIt.next()).getQName().getLocalPart());
        }
        String requestResponseString = String.valueOf(WNameHelperUtil.getRequestOrResponse(messageRef)) + "Msg";
        messageName = WNameHelperUtil.getUniqueName(String.valueOf(operation.getName()) + requestResponseString, messageNames);
        return messageName;
    }

    public static String getPartName(MessageReference messageRef) {
        String partName = "NewPart";
        Message message = messageRef.getEMessage();
        Operation operation = (Operation)messageRef.getContainer();
        String operationName = operation.getName();
        String appendString = "";
        if (messageRef instanceof Input) {
            appendString = "Parameters";
        } else if (messageRef instanceof Output) {
            appendString = "Result";
        } else if (messageRef instanceof Fault) {
            appendString = "Fault";
        }
        partName = String.valueOf(operationName) + appendString;
        ArrayList<String> usedPartNames = new ArrayList<String>();
        if (message != null) {
            Iterator partIt = message.getEParts().iterator();
            while (partIt.hasNext()) {
                usedPartNames.add(((Part)partIt.next()).getName());
            }
        }
        partName = WNameHelperUtil.getUniqueName(partName, usedPartNames);
        return partName;
    }

    public static String getOperationName(PortType portType) {
        String operationName = "NewOperation";
        Iterator operationIt = portType.getEOperations().iterator();
        ArrayList<String> usedNames = new ArrayList<String>();
        while (operationIt.hasNext()) {
            usedNames.add(((Operation)operationIt.next()).getName());
        }
        operationName = WNameHelperUtil.getUniqueName("NewOperation", usedNames);
        return operationName;
    }

    public static String getRequestOrResponse(MessageReference messageRef) {
        if (messageRef instanceof Input) {
            return "Request";
        }
        if (messageRef instanceof Output) {
            return "Response";
        }
        if (messageRef instanceof Fault) {
            return "_Fault";
        }
        return "";
    }

    public static String getFaultName(Operation operation) {
        String faultName = "fault";
        ArrayList<String> nameList = new ArrayList<String>();
        Iterator faultIt = operation.getEFaults().iterator();
        while (faultIt.hasNext()) {
            nameList.add(((Fault)faultIt.next()).getName());
        }
        faultName = WNameHelperUtil.getUniqueName(faultName, nameList);
        return faultName;
    }

    public static String getXSDElementName(String baseName, Object parent) {
        String elementName = "";
        if (parent instanceof XSDSchema) {
            elementName = WNameHelperUtil.getUniqueName(baseName, WNameHelperUtil.getUsedElementNames((XSDSchema)parent));
        } else if (parent instanceof XSDModelGroup) {
            ArrayList<String> existingNames = new ArrayList<String>();
            XSDModelGroup modelGroup = (XSDModelGroup)parent;
            Iterator modelGroupIt = modelGroup.getContents().iterator();
            while (modelGroupIt.hasNext()) {
                XSDParticle existingParticle;
                Object item = modelGroupIt.next();
                if (!(item instanceof XSDParticle) || !((existingParticle = (XSDParticle)item).getContent() instanceof XSDElementDeclaration)) continue;
                existingNames.add(((XSDElementDeclaration)existingParticle.getContent()).getName());
            }
            elementName = WNameHelperUtil.getUniqueName(baseName, existingNames);
        }
        return elementName;
    }

    public static String getXSDComplexTypeName(String baseName, XSDSchema schema) {
        String typeName = "";
        ArrayList<String> existingNames = new ArrayList<String>();
        Iterator it = schema.getTypeDefinitions().iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (!(item instanceof XSDComplexTypeDefinition)) continue;
            existingNames.add(((XSDComplexTypeDefinition)item).getName());
        }
        typeName = WNameHelperUtil.getUniqueName(baseName, existingNames);
        return typeName;
    }

    private static List getUsedElementNames(XSDSchema xsdSchema) {
        ArrayList<String> usedNames = new ArrayList<String>();
        Iterator schemaIt = xsdSchema.getContents().iterator();
        while (schemaIt.hasNext()) {
            Object item = schemaIt.next();
            if (!(item instanceof XSDElementDeclaration)) continue;
            usedNames.add(((XSDElementDeclaration)item).getName());
        }
        return usedNames;
    }

    private static String getUniqueName(String baseName, List existingNames) {
        int count = 1;
        if (!existingNames.contains(baseName)) {
            return baseName;
        }
        Iterator namesIt = existingNames.iterator();
        boolean foundMatch = true;
        block0: while (foundMatch) {
            foundMatch = false;
            while (namesIt.hasNext()) {
                String name = (String)namesIt.next();
                if (!name.equals(String.valueOf(baseName) + String.valueOf(count))) continue;
                ++count;
                foundMatch = true;
                continue block0;
            }
        }
        return String.valueOf(baseName) + String.valueOf(count);
    }
}

