/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.BindingFault;
import org.eclipse.wst.wsdl.BindingInput;
import org.eclipse.wst.wsdl.BindingOperation;
import org.eclipse.wst.wsdl.BindingOutput;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.Service;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.internal.impl.ImportImpl;
import org.eclipse.wst.wsdl.internal.impl.WSDLElementImpl;
import org.eclipse.wst.wsdl.ui.internal.extension.ITypeSystemProvider;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ComponentReferenceUtil {
    protected Definition rootDefinition;

    public ComponentReferenceUtil(Definition rootDefinition) {
        this.rootDefinition = rootDefinition;
    }

    protected static boolean isEqual(String a, String b) {
        boolean result = false;
        result = a != null ? a.equals(b) || a.length() == 0 && b == null : b == null || b.length() == 0;
        return result;
    }

    protected static boolean isEqualInputName(Operation operation, BindingOperation bindingOperation) {
        boolean result = false;
        Input operationInput = operation.getEInput();
        BindingInput bindingOperationInput = bindingOperation.getEBindingInput();
        if (operationInput != null && bindingOperationInput != null) {
            result = ComponentReferenceUtil.isEqual(operationInput.getName(), bindingOperationInput.getName());
        } else if (operationInput == null && bindingOperationInput == null) {
            result = true;
        }
        return result;
    }

    protected static boolean isEqualOutputName(Operation operation, BindingOperation bindingOperation) {
        boolean result = false;
        Output operationOutput = operation.getEOutput();
        BindingOutput bindingOperationOutput = bindingOperation.getEBindingOutput();
        if (operationOutput != null && bindingOperationOutput != null) {
            result = ComponentReferenceUtil.isEqual(operationOutput.getName(), bindingOperationOutput.getName());
        } else if (operationOutput == null && bindingOperationOutput == null) {
            result = true;
        }
        return result;
    }

    protected static boolean isMatchingBinding(Operation operation, BindingOperation bindingOperation) {
        return ComponentReferenceUtil.isEqual(operation.getName(), bindingOperation.getName()) && ComponentReferenceUtil.isEqualInputName(operation, bindingOperation) && ComponentReferenceUtil.isEqualOutputName(operation, bindingOperation);
    }

    public List getPortsForPortType(PortType portType) {
        ArrayList<Port> list = new ArrayList<Port>();
        Iterator i = this.getServices().iterator();
        while (i.hasNext()) {
            Service service = (Service)i.next();
            Iterator j = service.getEPorts().iterator();
            while (j.hasNext()) {
                Port port = (Port)j.next();
                Binding binding = port.getEBinding();
                if (binding == null || binding.getEPortType() != portType) continue;
                list.add(port);
            }
        }
        return list;
    }

    public List getPortsForBinding(Binding binding) {
        ArrayList<Port> list = new ArrayList<Port>();
        Iterator i = this.getServices().iterator();
        while (i.hasNext()) {
            Service service = (Service)i.next();
            Iterator j = service.getEPorts().iterator();
            while (j.hasNext()) {
                Port port = (Port)j.next();
                if (port.getEBinding() != binding) continue;
                list.add(port);
            }
        }
        return list;
    }

    public List getBindingOperations(Operation operation) {
        ArrayList<BindingOperation> list = new ArrayList<BindingOperation>();
        String operationName = operation.getName();
        if (operationName != null) {
            PortType portType = this.getEnclosingPortType(operation);
            Iterator i = this.getBindings(portType).iterator();
            while (i.hasNext()) {
                Binding binding = (Binding)i.next();
                BindingOperation bindingOperation = this.getBindingOperation(operation, binding);
                if (bindingOperation == null) continue;
                list.add(bindingOperation);
            }
        }
        return list;
    }

    public BindingOperation getBindingOperation(Operation operation, Binding binding) {
        BindingOperation result = null;
        Iterator j = binding.getBindingOperations().iterator();
        while (j.hasNext()) {
            BindingOperation bindingOperation = (BindingOperation)j.next();
            if (!ComponentReferenceUtil.isMatchingBinding(operation, bindingOperation)) continue;
            result = bindingOperation;
            break;
        }
        return result;
    }

    public BindingInput getBindingInput(Input input, Binding binding) {
        BindingOperation bindingOperation = this.getBindingOperation((Operation)input.eContainer(), binding);
        return bindingOperation != null ? bindingOperation.getEBindingInput() : null;
    }

    public BindingOutput getBindingOutput(Output output, Binding binding) {
        BindingOperation bindingOperation = this.getBindingOperation((Operation)output.eContainer(), binding);
        return bindingOperation != null ? bindingOperation.getEBindingOutput() : null;
    }

    public BindingFault getBindingFault(Fault fault, Binding binding) {
        BindingOperation bindingOperation;
        BindingFault result = null;
        String faultName = fault.getName();
        if (faultName != null && (bindingOperation = this.getBindingOperation((Operation)fault.eContainer(), binding)) != null) {
            result = (BindingFault)bindingOperation.getBindingFault(faultName);
        }
        return result;
    }

    public EObject getBindingObject(EObject interfaceObject, Binding binding) {
        BindingInput result = null;
        if (interfaceObject instanceof Input) {
            result = this.getBindingInput((Input)interfaceObject, binding);
        } else if (interfaceObject instanceof Output) {
            result = this.getBindingOutput((Output)interfaceObject, binding);
        } else if (interfaceObject instanceof Fault) {
            result = this.getBindingFault((Fault)interfaceObject, binding);
        } else if (interfaceObject instanceof Operation) {
            result = this.getBindingOperation((Operation)interfaceObject, binding);
        } else if (interfaceObject instanceof PortType) {
            result = binding;
        }
        return result;
    }

    public List getBindingInputs(Input input) {
        ArrayList<javax.wsdl.BindingInput> list = new ArrayList<javax.wsdl.BindingInput>();
        List operations = this.getBindingOperations((Operation)input.eContainer());
        Iterator i = operations.iterator();
        while (i.hasNext()) {
            BindingOperation bindingOperation = (BindingOperation)i.next();
            if (bindingOperation.getBindingInput() == null) continue;
            list.add(bindingOperation.getBindingInput());
        }
        return list;
    }

    public List getBindingOutputs(Output output) {
        ArrayList<javax.wsdl.BindingOutput> list = new ArrayList<javax.wsdl.BindingOutput>();
        Operation operation = (Operation)output.eContainer();
        if (operation != null) {
            List operations = this.getBindingOperations(operation);
            Iterator i = operations.iterator();
            while (i.hasNext()) {
                BindingOperation bindingOperation = (BindingOperation)i.next();
                if (bindingOperation.getBindingOutput() == null) continue;
                list.add(bindingOperation.getBindingOutput());
            }
        }
        return list;
    }

    public List getBindingFaults(Fault fault) {
        Operation operation;
        ArrayList<BindingFault> list = new ArrayList<BindingFault>();
        String faultName = fault.getName();
        if (faultName != null && (operation = (Operation)fault.eContainer()) != null) {
            List operations = this.getBindingOperations(operation);
            Iterator i = operations.iterator();
            while (i.hasNext()) {
                BindingOperation bindingOperation = (BindingOperation)i.next();
                BindingFault bindingFault = (BindingFault)bindingOperation.getBindingFault(faultName);
                if (bindingFault == null) continue;
                list.add(bindingFault);
            }
        }
        return list;
    }

    protected PortType getEnclosingPortType(Operation operation) {
        return (PortType)operation.eContainer();
    }

    public List getBindings(Operation operation) {
        return this.getBindings(this.getEnclosingPortType(operation));
    }

    public List getBindings(PortType portType) {
        ArrayList<Binding> list = new ArrayList<Binding>();
        Iterator i = this.getDefinitions().iterator();
        while (i.hasNext()) {
            Definition definition = (Definition)i.next();
            Iterator j = definition.getBindings().values().iterator();
            while (j.hasNext()) {
                Binding binding = (Binding)j.next();
                if (portType != null && binding.getPortType() != portType) continue;
                list.add(binding);
            }
        }
        return list;
    }

    public List getBindingsWithoutOperation(PortType portType, String operationName) {
        ArrayList<Binding> result = new ArrayList<Binding>();
        if (operationName != null) {
            List bindings = this.getBindings(portType);
            Iterator i = bindings.iterator();
            while (i.hasNext()) {
                Binding binding = (Binding)i.next();
                boolean hasName = false;
                Iterator j = binding.getBindingOperations().iterator();
                while (j.hasNext()) {
                    BindingOperation bindingOperation = (BindingOperation)j.next();
                    if (!operationName.equals(bindingOperation.getName())) continue;
                    hasName = true;
                    break;
                }
                if (hasName) continue;
                result.add(binding);
            }
        }
        return result;
    }

    public List getBindings() {
        return this.getBindings((PortType)null);
    }

    public List getBindingNames() {
        ArrayList list = new ArrayList();
        Iterator i = this.getBindings().iterator();
        while (i.hasNext()) {
            Binding binding = (Binding)i.next();
            list.addAll(this.getPrefixedNames(binding.getQName()));
        }
        return list;
    }

    public List getPortTypeNames() {
        ArrayList list = new ArrayList();
        Iterator i = this.getDefinitions().iterator();
        while (i.hasNext()) {
            Definition definition = (Definition)i.next();
            Iterator j = definition.getPortTypes().values().iterator();
            while (j.hasNext()) {
                PortType portType = (PortType)j.next();
                list.addAll(this.getPrefixedNames(portType.getQName()));
            }
        }
        return list;
    }

    public List getServices() {
        ArrayList list = new ArrayList();
        Iterator i = this.getDefinitions().iterator();
        while (i.hasNext()) {
            Definition definition = (Definition)i.next();
            list.addAll(definition.getEServices());
        }
        return list;
    }

    public List getPortTypes() {
        ArrayList list = new ArrayList();
        Iterator i = this.getDefinitions().iterator();
        while (i.hasNext()) {
            Definition definition = (Definition)i.next();
            list.addAll(definition.getEPortTypes());
        }
        return list;
    }

    public List getMessages() {
        ArrayList list = new ArrayList();
        Iterator i = this.getDefinitions().iterator();
        while (i.hasNext()) {
            Definition definition = (Definition)i.next();
            list.addAll(definition.getEMessages());
        }
        return list;
    }

    public List getTypes() {
        ArrayList<Types> list = new ArrayList<Types>();
        Iterator i = this.getDefinitions().iterator();
        while (i.hasNext()) {
            Definition definition = (Definition)i.next();
            if (definition.getETypes() == null) continue;
            list.add(definition.getETypes());
        }
        return list;
    }

    public List getMessageNames() {
        ArrayList list = new ArrayList();
        Iterator i = this.getDefinitions().iterator();
        while (i.hasNext()) {
            Definition definition = (Definition)i.next();
            Iterator j = definition.getMessages().values().iterator();
            while (j.hasNext()) {
                Message message = (Message)j.next();
                list.addAll(this.getPrefixedNames(message.getQName()));
            }
        }
        return list;
    }

    public List getDefinitions() {
        ArrayList list = new ArrayList();
        this.addDefinition(this.rootDefinition, list);
        return list;
    }

    public String getPrefixedName(QName qname) {
        String prefix;
        String name = null;
        if (qname != null && (prefix = this.rootDefinition.getPrefix(qname.getNamespaceURI())) != null) {
            name = String.valueOf(prefix) + ":" + qname.getLocalPart();
        }
        return name;
    }

    public List getPrefixedNames(QName qname) {
        ArrayList<String> list = new ArrayList<String>();
        if (qname != null) {
            Map map = this.rootDefinition.getNamespaces();
            Iterator i = map.keySet().iterator();
            while (i.hasNext()) {
                String prefix = (String)i.next();
                String namespace = (String)map.get(prefix);
                if (namespace == null || !namespace.equals(qname.getNamespaceURI())) continue;
                String name = prefix.length() > 0 ? String.valueOf(prefix) + ":" + qname.getLocalPart() : qname.getLocalPart();
                list.add(name);
            }
        }
        return list;
    }

    protected void addDefinition(Definition definition, List list) {
        if (definition != null) {
            list.add(definition);
            Iterator i = definition.getEImports().iterator();
            while (i.hasNext()) {
                ImportImpl theImport = (ImportImpl)i.next();
                if (theImport.getLocationURI() == null || theImport.getLocationURI().endsWith("xsd")) continue;
                theImport.importDefinitionOrSchema();
                Definition importedDefinition = theImport.getEDefinition();
                if (importedDefinition == null || list.contains(importedDefinition)) continue;
                this.addDefinition(importedDefinition, list);
            }
        }
    }

    public static String getPortTypeReference(Binding binding) {
        String result = null;
        Element element = WSDLEditorUtil.getInstance().getElementForObject(binding);
        if (element != null) {
            result = element.getAttribute("type");
        }
        return result;
    }

    public static void setPortTypeReference(Binding binding, String portType) {
        Element element = WSDLEditorUtil.getInstance().getElementForObject(binding);
        if (element != null) {
            element.setAttribute("type", portType);
        }
    }

    public static String getBindingReference(Port port) {
        String result = null;
        Element element = WSDLEditorUtil.getInstance().getElementForObject(port);
        if (element != null) {
            result = element.getAttribute("binding");
        }
        return result;
    }

    public static String getName(Binding binding) {
        String result = null;
        Element element = WSDLEditorUtil.getInstance().getElementForObject(binding);
        if (element != null) {
            result = element.getAttribute("name");
        }
        return result;
    }

    public static QName getPortTypeReferenceQName(Binding binding) {
        QName result = null;
        Definition definition = binding.getEnclosingDefinition();
        String prefixedName = ComponentReferenceUtil.getPortTypeReference(binding);
        if (prefixedName != null) {
            result = WSDLEditorUtil.createQName(definition, prefixedName);
        }
        return result;
    }

    public static QName getBindingReferenceQName(Port port) {
        QName result = null;
        Definition definition = port.getEnclosingDefinition();
        String prefixedName = ComponentReferenceUtil.getBindingReference(port);
        if (prefixedName != null) {
            result = WSDLEditorUtil.createQName(definition, prefixedName);
        }
        return result;
    }

    public static String getMessageReference(Input input) {
        return ComponentReferenceUtil.getMessageReferenceHelper((WSDLElement)input);
    }

    public static String getMessageReference(Output output) {
        return ComponentReferenceUtil.getMessageReferenceHelper((WSDLElement)output);
    }

    public static String getMessageReference(Fault fault) {
        return ComponentReferenceUtil.getMessageReferenceHelper((WSDLElement)fault);
    }

    public static QName getMessageReferenceQName(Input input) {
        return ComponentReferenceUtil.getMessageReferenceQNameHelper((WSDLElement)input);
    }

    public static QName getMessageReferenceQName(Output output) {
        return ComponentReferenceUtil.getMessageReferenceQNameHelper((WSDLElement)output);
    }

    public static QName getMessageReferenceQName(Fault fault) {
        return ComponentReferenceUtil.getMessageReferenceQNameHelper((WSDLElement)fault);
    }

    protected static String getMessageReferenceHelper(WSDLElement o) {
        String result = null;
        Element element = WSDLEditorUtil.getInstance().getElementForObject(o);
        if (element != null) {
            result = element.getAttribute("message");
        }
        return result;
    }

    public static QName getMessageReferenceQNameHelper(WSDLElement o) {
        QName result = null;
        Definition definition = o.getEnclosingDefinition();
        String prefixedName = ComponentReferenceUtil.getMessageReferenceHelper(o);
        if (prefixedName != null) {
            result = WSDLEditorUtil.createQName(definition, prefixedName);
        }
        return result;
    }

    public static void updatePortTypeReferences(Definition definition) {
        Iterator i = definition.getBindings().values().iterator();
        while (i.hasNext()) {
            PortType portType;
            Binding binding = (Binding)i.next();
            QName qname = ComponentReferenceUtil.getPortTypeReferenceQName(binding);
            PortType portType2 = portType = qname != null ? (PortType)definition.getPortType(qname) : null;
            if (binding.getPortType() == portType) continue;
            binding.setPortType((javax.wsdl.PortType)portType);
        }
    }

    public static void updateBindingReferences(Definition definition) {
        Iterator i = definition.getServices().values().iterator();
        while (i.hasNext()) {
            Service service = (Service)i.next();
            Iterator j = service.getEPorts().iterator();
            while (j.hasNext()) {
                Binding binding;
                Port port = (Port)j.next();
                QName qname = ComponentReferenceUtil.getBindingReferenceQName(port);
                Binding binding2 = binding = qname != null ? (Binding)definition.getBinding(qname) : null;
                if (port.getBinding() == binding) continue;
                port.setBinding((javax.wsdl.Binding)binding);
            }
        }
    }

    public static void updateMessageReferences(Definition definition) {
        Iterator i = definition.getPortTypes().values().iterator();
        while (i.hasNext()) {
            PortType portType = (PortType)i.next();
            Iterator j = portType.getEOperations().iterator();
            while (j.hasNext()) {
                Output output;
                Operation operation = (Operation)j.next();
                Input input = (Input)operation.getInput();
                if (input != null) {
                    Message message;
                    QName qname = ComponentReferenceUtil.getMessageReferenceQName(input);
                    Message message2 = message = qname != null ? (Message)definition.getMessage(qname) : null;
                    if (input.getMessage() != message) {
                        input.setMessage((javax.wsdl.Message)message);
                    }
                }
                if ((output = (Output)operation.getOutput()) != null) {
                    Message message;
                    QName qname = ComponentReferenceUtil.getMessageReferenceQName(output);
                    Message message3 = message = qname != null ? (Message)definition.getMessage(qname) : null;
                    if (output.getMessage() != message) {
                        output.setMessage((javax.wsdl.Message)message);
                    }
                }
                Iterator k = operation.getEFaults().iterator();
                while (k.hasNext()) {
                    Message message;
                    Fault fault = (Fault)k.next();
                    QName qname = ComponentReferenceUtil.getMessageReferenceQName(fault);
                    Message message4 = message = qname != null ? (Message)definition.getMessage(qname) : null;
                    if (fault.getMessage() == message) continue;
                    fault.setMessage((javax.wsdl.Message)message);
                }
            }
        }
    }

    public static void updateSchemaReferences(Definition definition) {
        Iterator i = definition.getEMessages().iterator();
        while (i.hasNext()) {
            Message message = (Message)i.next();
            Iterator j = message.getEParts().iterator();
            while (j.hasNext()) {
                Part part = (Part)j.next();
                Element element = WSDLEditorUtil.getInstance().getElementForObject(part);
                if (element == null) continue;
                ((WSDLElementImpl)part).elementChanged(element);
            }
        }
    }

    public static Operation getOperation(PortType portType, BindingOperation bindingOperation) {
        Operation result = null;
        Iterator i = portType.getEOperations().iterator();
        while (i.hasNext()) {
            Operation operation = (Operation)i.next();
            if (!ComponentReferenceUtil.isMatchingBinding(operation, bindingOperation)) continue;
            result = operation;
            break;
        }
        return result;
    }

    public static void updateOperationReference(BindingOperation bindingOperation) {
        Operation operation = ComponentReferenceUtil.computeOperation(bindingOperation);
        if (operation != bindingOperation.getOperation()) {
            bindingOperation.setOperation((javax.wsdl.Operation)operation);
        }
    }

    public List getComponentNameList(boolean isType) {
        List result = Collections.EMPTY_LIST;
        ITypeSystemProvider typeSystemProvider = WSDLEditorUtil.getInstance().getTypeSystemProvider(this.rootDefinition);
        if (typeSystemProvider != null) {
            result = isType ? typeSystemProvider.getAvailableTypeNames(this.rootDefinition, 0) : typeSystemProvider.getAvailableElementNames(this.rootDefinition);
        }
        return result;
    }

    public static List getComponentNameList(Part part, boolean isType) {
        List result = Collections.EMPTY_LIST;
        Definition definition = part.getEnclosingDefinition();
        ITypeSystemProvider typeSystemProvider = WSDLEditorUtil.getInstance().getTypeSystemProvider(definition);
        if (typeSystemProvider != null) {
            result = isType ? typeSystemProvider.getAvailableTypeNames(definition, 0) : typeSystemProvider.getAvailableElementNames(definition);
        }
        return result;
    }

    public static boolean isType(Part part) {
        Element element = part.getElement();
        return !element.hasAttribute("element");
    }

    public static String getPartComponentReference(Part part) {
        Element element = part.getElement();
        String result = null;
        if (element.hasAttribute("type")) {
            result = element.getAttribute("type");
        } else if (element.hasAttribute("element")) {
            result = element.getAttribute("element");
        }
        return result;
    }

    public static void setComponentReference(Part part, boolean isType, String componentName) {
        String value;
        Element element = WSDLEditorUtil.getInstance().getElementForObject(part);
        String newAttribute = isType ? "type" : "element";
        String oldAttribute = isType ? "element" : "type";
        element.removeAttribute(oldAttribute);
        String string = value = componentName != null ? componentName : element.getAttribute(newAttribute);
        if (value == null) {
            if (isType) {
                String xsdPrefix = part.getEnclosingDefinition().getPrefix("http://www.w3.org/2001/XMLSchema");
                value = "string";
                if (xsdPrefix != null && xsdPrefix.length() > 0) {
                    value = String.valueOf(xsdPrefix) + ":" + value;
                }
            } else {
                List list = ComponentReferenceUtil.getComponentNameList(part, isType);
                value = list.size() > 0 ? (String)list.get(0) : "some-element-name";
            }
        }
        element.setAttribute(newAttribute, value);
    }

    public static Operation computeOperation(BindingOperation bindingOperation) {
        Operation result = null;
        Binding binding = (Binding)bindingOperation.eContainer();
        PortType portType = (PortType)binding.getPortType();
        if (portType != null) {
            result = ComponentReferenceUtil.getOperation(portType, bindingOperation);
        }
        return result;
    }

    public static Input computeInput(BindingInput bindingInput) {
        Operation operation = ComponentReferenceUtil.computeOperation((BindingOperation)bindingInput.eContainer());
        return operation != null ? operation.getEInput() : null;
    }

    public static Output computeOutput(BindingOutput bindingOutput) {
        Operation operation = ComponentReferenceUtil.computeOperation((BindingOperation)bindingOutput.eContainer());
        return operation != null ? operation.getEOutput() : null;
    }

    public static Fault computeFault(BindingFault bindingFault) {
        Fault result = null;
        Operation operation = ComponentReferenceUtil.computeOperation((BindingOperation)bindingFault.eContainer());
        if (operation != null) {
            Iterator i = operation.getEFaults().iterator();
            while (i.hasNext()) {
                Fault fault = (Fault)i.next();
                String faultName = fault.getName();
                if (faultName == null || !faultName.equals(bindingFault.getName())) continue;
                result = fault;
                break;
            }
        }
        return result;
    }

    public static String getPartReferenceValue(Part part) {
        Element element = WSDLEditorUtil.getInstance().getElementForObject(part);
        String value = null;
        if (element != null) {
            if (element.hasAttribute("type")) {
                value = element.getAttribute("type");
            } else if (element.hasAttribute("element")) {
                value = element.getAttribute("element");
            }
        }
        return value != null ? value : "";
    }

    public Operation getBindingOperation(Element bindingOperationContent) {
        Object object;
        Operation operation = null;
        Node parent = bindingOperationContent.getParentNode();
        if (parent instanceof Element && (object = WSDLEditorUtil.getInstance().findModelObjectForElement(this.rootDefinition, (Element)parent)) instanceof BindingOperation) {
            operation = ComponentReferenceUtil.computeOperation((BindingOperation)object);
        }
        return operation;
    }

    public Message getBindingOperationInputMessage(Element bindingOperationContent) {
        Input input;
        Message message = null;
        Operation operation = this.getBindingOperation(bindingOperationContent);
        if (operation != null && (input = operation.getEInput()) != null) {
            message = input.getEMessage();
        }
        return message;
    }

    public Message getBindingOperationOutputMessage(Element bindingOperationContent) {
        Output output;
        Message message = null;
        Operation operation = this.getBindingOperation(bindingOperationContent);
        if (operation != null && (output = operation.getEOutput()) != null) {
            message = output.getEMessage();
        }
        return message;
    }

    public static String computeRelativeURI(IFile referencedLocation, IFile baseLocation, boolean enableIEStyleReferences) {
        return URIHelper.getRelativeURI((IPath)referencedLocation.getLocation(), (IPath)baseLocation.getLocation());
    }

    public static String computeRelativeURI(String referencedLocation, String baseLocation, boolean enableIEStyleReferences) {
        return URIHelper.getRelativeURI((String)referencedLocation, (String)baseLocation);
    }
}

