/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.DataModelManager;
import org.eclipse.wst.common.frameworks.internal.OperationListener;
import org.eclipse.wst.common.frameworks.internal.datamodel.IWorkspaceRunnableWithStatus;
import org.eclipse.wst.common.frameworks.internal.operations.ComposedExtendedOperationHolder;
import org.eclipse.wst.common.frameworks.internal.operations.OperationStatus;

public class OperationManager {
    private IDataModel dataModel;
    private DataModelManager dataModelManager;
    private TableEntry rootOperation;
    private HashMap operationTable;
    private Stack runStopList;
    private IProgressMonitor monitor;
    private IAdaptable adaptable;
    private OperationStatus status;
    private OperationListener preExecuteListener;
    private OperationListener postExecuteListener;
    private OperationListener undoExecuteListener;
    private IEnvironment environment;

    public OperationManager(DataModelManager aDataModelManager, IDataModelOperation aRootOperation, IEnvironment aEnvironment) {
        OperationListener defaultListener;
        if (aRootOperation == null) {
            aRootOperation = new NullOperation();
        }
        TableEntry entry = new TableEntry(aRootOperation);
        this.dataModelManager = aDataModelManager;
        this.dataModel = this.dataModelManager.getDataModel();
        this.rootOperation = entry;
        this.operationTable = new HashMap();
        this.runStopList = new Stack();
        this.operationTable.put(aRootOperation.getID(), entry);
        this.environment = aEnvironment;
        this.addExtendedOperations(aRootOperation);
        this.preExecuteListener = defaultListener = new OperationListener(){

            public boolean notify(IDataModelOperation operation) {
                return true;
            }
        };
        this.postExecuteListener = defaultListener;
        this.undoExecuteListener = defaultListener;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public void setAdaptable(IAdaptable adaptable) {
        this.adaptable = adaptable;
    }

    public void addExtendedPreOperation(String operationId, IDataModelOperation insertOperation) {
        TableEntry entry = (TableEntry)this.operationTable.get(operationId);
        if (entry != null) {
            TableEntry newEntry = new TableEntry(insertOperation);
            entry.preOperations.add(newEntry);
            this.operationTable.put(insertOperation.getID(), newEntry);
        }
    }

    public void addExtendedPostOperation(String operationId, IDataModelOperation insertOperation) {
        TableEntry entry = (TableEntry)this.operationTable.get(operationId);
        if (entry != null) {
            TableEntry newEntry = new TableEntry(insertOperation);
            entry.postOperations.add(newEntry);
            this.operationTable.put(insertOperation.getID(), newEntry);
        }
    }

    public void setPreExecuteListener(OperationListener listener) {
        if (listener != null) {
            this.preExecuteListener = listener;
        }
    }

    public void setPostExecuteListener(OperationListener listener) {
        if (listener != null) {
            this.postExecuteListener = listener;
        }
    }

    public void setUndoExecuteListener(OperationListener listener) {
        if (listener != null) {
            this.undoExecuteListener = listener;
        }
    }

    /*
     * Unable to fully structure code
     */
    public IStatus runOperations() {
        continueRun = true;
        runEntry = this.startNewRun();
        this.status = null;
        if (!runEntry.stackEntries.empty()) ** GOTO lbl7
        return Status.OK_STATUS;
lbl-1000:
        // 1 sources

        {
            v0 = continueRun = this.runOperationsUntilStopped(runEntry) != false && runEntry.stackEntries.empty() == false;
lbl7:
            // 2 sources

            ** while (continueRun)
        }
lbl8:
        // 1 sources

        if (this.status != null && this.status.getSeverity() == 4) {
            this.undoLastRun();
        }
        return this.status;
    }

    public void undoLastRun() {
        if (!this.runStopList.empty()) {
            RunListEntry runListEntry = (RunListEntry)this.runStopList.pop();
            int index = runListEntry.executedOperations.size() - 1;
            while (index >= 0) {
                IDataModelOperation operation = (IDataModelOperation)runListEntry.executedOperations.elementAt(index);
                Set dataModelIDs = operation.getDataModelIDs();
                if (dataModelIDs != null && dataModelIDs.size() > 0) {
                    Iterator ids = dataModelIDs.iterator();
                    while (ids.hasNext()) {
                        String dataModelID = (String)ids.next();
                        this.dataModelManager.removeNestedDataModel(dataModelID);
                    }
                }
                try {
                    this.undoExecuteListener.notify(operation);
                }
                catch (Throwable throwable) {}
                if (operation.canUndo()) {
                    try {
                        this.runOperation(operation, true);
                    }
                    catch (Throwable throwable) {}
                }
                --index;
            }
        }
    }

    private RunListEntry startNewRun() {
        RunListEntry newEntry = null;
        if (this.runStopList.empty()) {
            newEntry = new RunListEntry(this.rootOperation);
        } else {
            RunListEntry topRunList = (RunListEntry)this.runStopList.peek();
            newEntry = new RunListEntry(topRunList);
        }
        this.runStopList.push(newEntry);
        return newEntry;
    }

    private boolean runOperationsUntilStopped(RunListEntry runListEntry) {
        TableEntry tableEntry;
        StackEntry stackEntry = (StackEntry)runListEntry.stackEntries.peek();
        boolean continueRun = true;
        int index = stackEntry.preOperationIndex + 1;
        while (continueRun && index < stackEntry.tableEntry.preOperations.size()) {
            tableEntry = (TableEntry)stackEntry.tableEntry.preOperations.elementAt(index);
            runListEntry.stackEntries.push(new StackEntry(tableEntry));
            stackEntry.preOperationIndex = index++;
            continueRun = this.runOperationsUntilStopped(runListEntry);
        }
        if (continueRun && stackEntry.preOpChildIndex == -1) {
            stackEntry.addPreOpChildren();
        }
        index = stackEntry.preOpChildIndex + 1;
        while (continueRun && index < stackEntry.preOpChildren.size()) {
            tableEntry = (TableEntry)stackEntry.preOpChildren.elementAt(index);
            runListEntry.stackEntries.push(new StackEntry(tableEntry));
            stackEntry.preOpChildIndex = index++;
            continueRun = this.runOperationsUntilStopped(runListEntry);
        }
        if (continueRun && !stackEntry.operationExecuted) {
            IDataModelOperation operation = stackEntry.tableEntry.operation;
            try {
                continueRun = this.preExecuteListener.notify(operation);
                if (continueRun) {
                    Set dataModelIDs = operation.getDataModelIDs();
                    if (dataModelIDs != null && dataModelIDs.size() > 0) {
                        Iterator ids = dataModelIDs.iterator();
                        while (ids.hasNext()) {
                            String dataModelID = (String)ids.next();
                            this.dataModelManager.addNestedDataModel(dataModelID);
                        }
                    }
                    operation.setDataModel(this.dataModel);
                    operation.setEnvironment(this.environment);
                    this.setStatus(this.runOperation(operation, false));
                    runListEntry.executedOperations.add(operation);
                    stackEntry.operationExecuted = true;
                    continueRun = this.postExecuteListener.notify(operation);
                }
            }
            catch (Throwable exc) {
                this.setStatus((IStatus)new Status(4, "id", 0, exc.getMessage() == null ? exc.toString() : exc.getMessage(), exc));
            }
            if (this.status != null && this.status.getSeverity() == 4) {
                continueRun = false;
            }
        }
        if (continueRun && stackEntry.postOpChildIndex == -1) {
            stackEntry.addPostOpChildren();
        }
        index = stackEntry.postOpChildIndex + 1;
        while (continueRun && index < stackEntry.postOpChildren.size()) {
            tableEntry = (TableEntry)stackEntry.postOpChildren.elementAt(index);
            stackEntry.postOpChildIndex = index++;
            runListEntry.stackEntries.push(new StackEntry(tableEntry));
            continueRun = this.runOperationsUntilStopped(runListEntry);
        }
        index = stackEntry.postOperationIndex + 1;
        while (continueRun && index < stackEntry.tableEntry.postOperations.size()) {
            tableEntry = (TableEntry)stackEntry.tableEntry.postOperations.elementAt(index);
            stackEntry.postOperationIndex = index++;
            runListEntry.stackEntries.push(new StackEntry(tableEntry));
            continueRun = this.runOperationsUntilStopped(runListEntry);
        }
        if (continueRun) {
            runListEntry.stackEntries.pop();
        }
        return continueRun;
    }

    private IStatus runOperation(final IDataModelOperation operation, final boolean isUndo) {
        IWorkspaceRunnableWithStatus workspaceRunnable = new IWorkspaceRunnableWithStatus(this.adaptable){

            public void run(IProgressMonitor pm) throws CoreException {
                try {
                    if (isUndo) {
                        this.setStatus(operation.undo(OperationManager.this.monitor, this.getInfo()));
                    } else {
                        this.setStatus(operation.execute(OperationManager.this.monitor, this.getInfo()));
                    }
                }
                catch (Throwable exc) {
                    exc.printStackTrace();
                }
            }
        };
        ISchedulingRule rule = operation.getSchedulingRule();
        try {
            if (rule == null) {
                ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)workspaceRunnable, this.monitor);
            } else {
                ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)workspaceRunnable, rule, operation.getOperationExecutionFlags(), this.monitor);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return workspaceRunnable.getStatus();
    }

    private void setStatus(IStatus newStatus) {
        if (this.status == null) {
            this.status = new OperationStatus(newStatus.getMessage(), newStatus.getException());
            this.status.setSeverity(newStatus.getSeverity());
            this.status.add(newStatus);
        } else {
            this.status.add(newStatus);
        }
    }

    private void addExtendedOperations(IDataModelOperation operation) {
        IDataModelOperation newOperation;
        ComposedExtendedOperationHolder extendedOps = ComposedExtendedOperationHolder.createExtendedOperationHolder(operation.getID());
        ArrayList preOps = null;
        ArrayList postOps = null;
        if (extendedOps != null) {
            preOps = extendedOps.getPreOps();
            postOps = extendedOps.getPostOps();
        }
        if (preOps == null) {
            preOps = new ArrayList();
        }
        if (postOps == null) {
            postOps = new ArrayList();
        }
        int index = 0;
        while (index < preOps.size()) {
            newOperation = (IDataModelOperation)preOps.get(index);
            this.addExtendedPreOperation(operation.getID(), newOperation);
            this.addExtendedOperations(newOperation);
            ++index;
        }
        index = 0;
        while (index < postOps.size()) {
            newOperation = (IDataModelOperation)postOps.get(index);
            this.addExtendedPostOperation(operation.getID(), newOperation);
            this.addExtendedOperations(newOperation);
            ++index;
        }
    }

    private class RunListEntry {
        public Stack stackEntries = new Stack();
        public Vector executedOperations = new Vector();

        public RunListEntry(TableEntry newEntry) {
            this.stackEntries.push(new StackEntry(newEntry));
        }

        public RunListEntry(RunListEntry oldList) {
            int index = 0;
            while (index < oldList.stackEntries.size()) {
                StackEntry oldEntry = (StackEntry)oldList.stackEntries.elementAt(index);
                this.stackEntries.add(new StackEntry(oldEntry));
                ++index;
            }
        }
    }

    private class StackEntry {
        public int preOperationIndex;
        public int postOperationIndex;
        public int preOpChildIndex;
        public int postOpChildIndex;
        public boolean operationExecuted;
        public Vector preOpChildren;
        public Vector postOpChildren;
        public TableEntry tableEntry;

        public StackEntry(TableEntry newTableEntry) {
            this.preOperationIndex = -1;
            this.postOperationIndex = -1;
            this.operationExecuted = false;
            this.preOpChildIndex = -1;
            this.postOpChildIndex = -1;
            this.tableEntry = newTableEntry;
        }

        public StackEntry(StackEntry newStackEntry) {
            this.preOperationIndex = newStackEntry.preOperationIndex;
            this.postOperationIndex = newStackEntry.postOperationIndex;
            this.operationExecuted = newStackEntry.operationExecuted;
            this.tableEntry = newStackEntry.tableEntry;
            this.preOpChildIndex = newStackEntry.preOpChildIndex;
            this.postOpChildIndex = newStackEntry.postOpChildIndex;
            this.preOpChildren = newStackEntry.preOpChildren == null ? null : new Vector(newStackEntry.preOpChildren);
            this.postOpChildren = newStackEntry.postOpChildren == null ? null : new Vector(newStackEntry.postOpChildren);
        }

        public void addPreOpChildren() {
            List preOps = this.tableEntry.operation.getPreOperations();
            this.preOpChildren = new Vector();
            if (preOps != null) {
                int index = 0;
                while (index < preOps.size()) {
                    IDataModelOperation op = (IDataModelOperation)preOps.get(index);
                    TableEntry newEntry = new TableEntry(op);
                    this.preOpChildren.add(newEntry);
                    OperationManager.this.operationTable.put(op.getID(), newEntry);
                    OperationManager.this.addExtendedOperations(op);
                    ++index;
                }
            }
        }

        public void addPostOpChildren() {
            List postOps = this.tableEntry.operation.getPostOperations();
            this.postOpChildren = new Vector();
            if (postOps != null) {
                int index = 0;
                while (index < postOps.size()) {
                    IDataModelOperation op = (IDataModelOperation)postOps.get(index);
                    TableEntry newEntry = new TableEntry(op);
                    this.postOpChildren.add(newEntry);
                    OperationManager.this.operationTable.put(op.getID(), newEntry);
                    OperationManager.this.addExtendedOperations(op);
                    ++index;
                }
            }
        }
    }

    private class TableEntry {
        public IDataModelOperation operation;
        public Vector preOperations;
        public Vector postOperations;

        public TableEntry(IDataModelOperation newOperation) {
            this.operation = newOperation;
            this.preOperations = new Vector(3);
            this.postOperations = new Vector(3);
        }
    }

    private class NullOperation
    extends AbstractDataModelOperation {
        private NullOperation() {
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return Status.OK_STATUS;
        }
    }
}

