/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.product;

import java.io.PrintWriter;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.iproduct.IWindowImages;
import org.eclipse.pde.internal.core.product.ProductObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WindowImages
extends ProductObject
implements IWindowImages {
    private static final long serialVersionUID = 1L;
    private String fLargeImagePath;
    private String fSmallImagePath;

    public WindowImages(IProductModel model) {
        super(model);
    }

    public String getLargeImagePath() {
        return this.fLargeImagePath;
    }

    public String getSmallImagePath() {
        return this.fSmallImagePath;
    }

    public void setLargeImagePath(String path) {
        String old = this.fLargeImagePath;
        this.fLargeImagePath = path;
        if (this.isEditable()) {
            this.firePropertyChanged("large", old, this.fLargeImagePath);
        }
    }

    public void setSmallImagePath(String path) {
        String old = this.fSmallImagePath;
        this.fSmallImagePath = path;
        if (this.isEditable()) {
            this.firePropertyChanged("small", old, this.fSmallImagePath);
        }
    }

    public void parse(Node node) {
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            this.fSmallImagePath = element.getAttribute("small");
            this.fLargeImagePath = element.getAttribute("large");
        }
    }

    public void write(String indent, PrintWriter writer) {
        writer.print(String.valueOf(indent) + "<windowImages");
        if (this.fSmallImagePath != null && this.fSmallImagePath.length() > 0) {
            writer.print(" small=\"" + this.getWritableString(this.fSmallImagePath) + "\"");
        }
        if (this.fLargeImagePath != null && this.fLargeImagePath.length() > 0) {
            writer.print(" large=\"" + this.getWritableString(this.fLargeImagePath) + "\"");
        }
        writer.println("/>");
    }
}

