/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.ui;

import java.io.File;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelSynchHelper;
import org.eclipse.wst.common.frameworks.internal.operations.IProjectCreationPropertiesNew;
import org.eclipse.wst.common.frameworks.internal.ui.NewProjectGroup;
import org.eclipse.wst.common.frameworks.internal.ui.WTPCommonUIResourceHandler;

public class NewProjectGroup
implements IProjectCreationPropertiesNew {
    private IDataModel model;
    public Text projectNameField = null;
    protected Text locationPathField = null;
    protected Button browseButton = null;
    private static final int SIZING_TEXT_FIELD_WIDTH = 305;
    private String defProjectNameLabel = WTPCommonUIResourceHandler.Name_;
    private String defBrowseButtonLabel = WTPCommonUIResourceHandler.Browse_;
    private static final String defDirDialogLabel = "Directory";
    private DataModelSynchHelper synchHelper;

    public NewProjectGroup(Composite parent, IDataModel model) {
        this.model = model;
        this.synchHelper = new DataModelSynchHelper(model);
        this.buildComposites(parent);
    }

    public void buildComposites(Composite parent) {
        this.createProjectNameGroup(parent);
        this.createProjectLocationGroup(parent);
        this.projectNameField.setFocus();
    }

    private final void createProjectNameGroup(Composite parent) {
        Font font = parent.getFont();
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectLabel = new Label(projectGroup, 0);
        projectLabel.setFont(font);
        projectLabel.setText(this.defProjectNameLabel);
        this.projectNameField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 305;
        this.projectNameField.setLayoutData((Object)data);
        this.projectNameField.setFont(font);
        this.synchHelper.synchText(this.projectNameField, "IProjectCreationPropertiesNew.PROJECT_NAME", new Control[]{projectLabel});
    }

    private final void createProjectLocationGroup(Composite parent) {
        Font font = parent.getFont();
        Group projectGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        projectGroup.setFont(font);
        projectGroup.setText(IDEWorkbenchMessages.WizardNewProjectCreationPage_projectContentsGroupLabel);
        Button useDefaultsButton = new Button((Composite)projectGroup, 131104);
        useDefaultsButton.setText(IDEWorkbenchMessages.WizardNewProjectCreationPage_useDefaultLabel);
        useDefaultsButton.setFont(font);
        this.synchHelper.synchCheckbox(useDefaultsButton, "IProjectCreationPropertiesNew.USE_DEFAULT_LOCATION", null);
        GridData buttonData = new GridData();
        buttonData.horizontalSpan = 3;
        useDefaultsButton.setLayoutData((Object)buttonData);
        this.createUserSpecifiedProjectLocationGroup((Composite)projectGroup);
    }

    private void createUserSpecifiedProjectLocationGroup(Composite projectGroup) {
        Font font = projectGroup.getFont();
        Label locationLabel = new Label(projectGroup, 0);
        locationLabel.setFont(font);
        locationLabel.setText(IDEWorkbenchMessages.WizardNewProjectCreationPage_locationLabel);
        this.locationPathField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 305;
        this.locationPathField.setLayoutData((Object)data);
        this.locationPathField.setFont(font);
        this.browseButton = new Button(projectGroup, 8);
        this.browseButton.setFont(font);
        this.browseButton.setText(this.defBrowseButtonLabel);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewProjectGroup.this.handleLocationBrowseButtonPressed();
            }
        });
        IDataModel localModel = this.model;
        class LocationListener
        implements ModifyListener,
        IDataModelListener {
            private boolean typing;
            final /* synthetic */ NewProjectGroup this$0;
            private final /* synthetic */ IDataModel val$localModel;
            private final /* synthetic */ Label val$locationLabel;

            LocationListener(NewProjectGroup newProjectGroup, IDataModel iDataModel, Label label) {
                this.this$0 = newProjectGroup;
                this.val$localModel = iDataModel;
                this.val$locationLabel = label;
                this.typing = false;
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void modifyText(ModifyEvent e) {
                if (this.val$localModel.getBooleanProperty("IProjectCreationPropertiesNew.USE_DEFAULT_LOCATION")) return;
                try {
                    this.typing = true;
                    this.val$localModel.setProperty("IProjectCreationPropertiesNew.USER_DEFINED_LOCATION", (Object)this.this$0.locationPathField.getText());
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    this.typing = false;
                    throw throwable;
                }
                {
                    Object var2_4 = null;
                    this.typing = false;
                    return;
                }
            }

            public void propertyChanged(DataModelEvent event) {
                boolean useDefault = this.val$localModel.getBooleanProperty("IProjectCreationPropertiesNew.USE_DEFAULT_LOCATION");
                if ("IProjectCreationPropertiesNew.USE_DEFAULT_LOCATION".equals(event.getPropertyName())) {
                    this.val$locationLabel.setEnabled(!useDefault);
                    this.this$0.locationPathField.setEnabled(!useDefault);
                    this.this$0.browseButton.setEnabled(!useDefault);
                    if (useDefault) {
                        this.this$0.locationPathField.setText(this.val$localModel.getStringProperty("IProjectCreationPropertiesNew.DEFAULT_LOCATION"));
                    } else {
                        this.this$0.locationPathField.setText(this.val$localModel.getStringProperty("IProjectCreationPropertiesNew.USER_DEFINED_LOCATION"));
                    }
                } else if (!this.typing && (useDefault && "IProjectCreationPropertiesNew.DEFAULT_LOCATION".equals(event.getPropertyName()) || !useDefault && "IProjectCreationPropertiesNew.USER_DEFINED_LOCATION".equals(event.getPropertyName()))) {
                    this.this$0.locationPathField.setText((String)event.getProperty());
                }
            }
        }
        LocationListener listener = new LocationListener(this, localModel, locationLabel);
        listener.propertyChanged(new DataModelEvent(this.model, "IProjectCreationPropertiesNew.USE_DEFAULT_LOCATION", 1));
        this.locationPathField.addModifyListener((ModifyListener)listener);
        this.model.addListener((IDataModelListener)listener);
    }

    protected void handleLocationBrowseButtonPressed() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.locationPathField.getShell());
        dialog.setMessage(defDirDialogLabel);
        String dirName = this.model.getStringProperty("IProjectCreationPropertiesNew.USER_DEFINED_LOCATION");
        if (dirName.trim().length() == 0) {
            dirName = new Path(this.model.getStringProperty("IProjectCreationPropertiesNew.DEFAULT_LOCATION")).removeLastSegments(1).toOSString();
        }
        if (dirName != null && dirName.length() != 0 && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(dirName);
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.model.setProperty("IProjectCreationPropertiesNew.USER_DEFINED_LOCATION", (Object)selectedDirectory);
        }
    }

    public void dispose() {
        this.model.removeListener((IDataModelListener)this.synchHelper);
        this.synchHelper.dispose();
        this.model = null;
    }
}

