/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive.operations;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.application.internal.operations.AddComponentToEnterpriseApplicationDataModelProvider;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.internal.archive.operations.EARComponentSaveStrategyImpl;
import org.eclipse.jst.j2ee.internal.archive.operations.J2EEArtifactImportOperation;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class EARComponentImportOperation
extends J2EEArtifactImportOperation {
    protected EARArtifactEdit artifactEdit = null;

    public EARComponentImportOperation(IDataModel model) {
        super(model);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doExecute(IProgressMonitor monitor) throws ExecutionException {
        block12: {
            super.doExecute(monitor);
            List modelsToImport = (List)this.model.getProperty("IEnterpriseApplicationImportDataModelProperties.HANDLED_PROJECT_MODELS_LIST");
            try {
                IDataModel importModel = null;
                List allModels = (List)this.model.getProperty("IEnterpriseApplicationImportDataModelProperties.ALL_PROJECT_MODELS_LIST");
                ArrayList<IVirtualComponent> componentToAdd = new ArrayList<IVirtualComponent>();
                HashMap<IVirtualComponent, String> componentToURIMap = new HashMap<IVirtualComponent, String>();
                int i = 0;
                while (i < allModels.size()) {
                    importModel = (IDataModel)allModels.get(i);
                    if (modelsToImport.contains(importModel)) {
                        String archiveUri = ((Archive)importModel.getProperty("IJ2EEArtifactImportDataModelProperties.FILE")).getURI();
                        importModel.setProperty("IJ2EEArtifactImportDataModelProperties.closeArchiveOnDispose", (Object)Boolean.FALSE);
                        IDataModel compCreationModel = importModel.getNestedModel("IJ2EEArtifactImportDataModelProperties.NESTED_MODEL_J2EE_COMPONENT_CREATION");
                        if (compCreationModel.isProperty("IJ2EEComponentCreationDataModelProperties.MODULE_URI")) {
                            compCreationModel.setProperty("IJ2EEComponentCreationDataModelProperties.MODULE_URI", (Object)archiveUri);
                        }
                        try {
                            importModel.getDefaultOperation().execute(monitor, this.info);
                        }
                        catch (ExecutionException e) {
                            Logger.getLogger().logError((Throwable)e);
                        }
                        IVirtualComponent component = (IVirtualComponent)importModel.getProperty("IComponentCreationDataModelProperties.COMPONENT");
                        componentToAdd.add(component);
                        componentToURIMap.put(component, archiveUri);
                    }
                    ++i;
                }
                if (componentToAdd.size() > 0) {
                    IDataModel addComponentsDM = DataModelFactory.createDataModel((IDataModelProvider)new AddComponentToEnterpriseApplicationDataModelProvider());
                    addComponentsDM.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)this.virtualComponent);
                    addComponentsDM.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", componentToAdd);
                    addComponentsDM.setProperty("IAddComponentToEnterpriseApplicationDataModelProperties.TARGET_COMPONENTS_TO_URI_MAP", componentToURIMap);
                    addComponentsDM.getDefaultOperation().execute(monitor, this.info);
                }
                try {
                    this.fixupClasspaths(modelsToImport, this.virtualComponent);
                }
                catch (JavaModelException e) {
                    Logger.getLogger().logError((Throwable)e);
                }
                Object var11_16 = null;
                if (this.artifactEdit == null) break block12;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                if (this.artifactEdit != null) {
                    this.artifactEdit.dispose();
                    this.artifactEdit = null;
                }
                this.resetDisposeImportModels();
                throw throwable;
            }
            this.artifactEdit.dispose();
            this.artifactEdit = null;
        }
        this.resetDisposeImportModels();
    }

    private void resetDisposeImportModels() {
        this.resetDisposeImportModels((List)this.model.getProperty("IEnterpriseApplicationImportDataModelProperties.ALL_PROJECT_MODELS_LIST"));
    }

    private void resetDisposeImportModels(List models) {
        int i = 0;
        while (i < models.size()) {
            IDataModel model = (IDataModel)models.get(i);
            model.setProperty("IJ2EEArtifactImportDataModelProperties.closeArchiveOnDispose", (Object)Boolean.TRUE);
            ++i;
        }
    }

    private void fixupClasspaths(List selectedModels, IVirtualComponent earComponent) throws JavaModelException {
        int i = 0;
        while (i < selectedModels.size()) {
            IDataModel importModel = (IDataModel)selectedModels.get(i);
            Archive archive = (Archive)importModel.getProperty("IJ2EEArtifactImportDataModelProperties.FILE");
            String[] manifestClasspath = archive.getManifest().getClassPathTokenized();
            if (manifestClasspath.length > 0) {
                if (this.artifactEdit == null) {
                    this.artifactEdit = EARArtifactEdit.getEARArtifactEditForRead(earComponent.getProject());
                }
                List extraEntries = this.fixupClasspath(earComponent, manifestClasspath, new ArrayList(), archive, (IVirtualComponent)importModel.getProperty("IComponentCreationDataModelProperties.COMPONENT"));
                EARComponentImportOperation.addToClasspath(importModel, extraEntries);
                this.fixModuleReference(importModel, manifestClasspath);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List fixupClasspath(IVirtualComponent earComponent, String[] manifestClasspath, List computedFiles, Archive anArchive, IVirtualComponent nestedComponent) throws JavaModelException {
        ArrayList<IClasspathEntry> extraEntries = new ArrayList<IClasspathEntry>();
        int j = 0;
        while (true) {
            block14: {
                IVirtualFile vFile;
                if (j >= manifestClasspath.length) {
                    return extraEntries;
                }
                String manifestURI = ArchiveUtil.deriveEARRelativeURI((String)manifestClasspath[j], (Archive)anArchive);
                if (manifestURI != null && !computedFiles.contains(vFile = earComponent.getRootFolder().getFile(manifestURI))) {
                    computedFiles.add(vFile);
                    if (vFile.exists()) {
                        Object var13_14;
                        IFile file = vFile.getUnderlyingFile();
                        extraEntries.add(JavaCore.newLibraryEntry((IPath)file.getFullPath(), (IPath)file.getFullPath(), null, (boolean)true));
                        Archive archive = null;
                        try {
                            try {
                                archive = (Archive)this.getEarFile().getFile(manifestURI);
                                String[] nestedManifestClasspath = archive.getManifest().getClassPathTokenized();
                                extraEntries.addAll(this.fixupClasspath(earComponent, nestedManifestClasspath, computedFiles, archive, nestedComponent));
                            }
                            catch (FileNotFoundException e) {
                                Logger.getLogger().logError((Throwable)e);
                            }
                        }
                        catch (Throwable throwable) {
                            var13_14 = null;
                            if (archive != null) {
                                archive.close();
                            }
                            throw throwable;
                        }
                        {
                            var13_14 = null;
                            if (archive != null) {
                                archive.close();
                            }
                            break block14;
                        }
                    }
                    IVirtualComponent comp = this.artifactEdit.getModuleByManifestURI(manifestURI);
                    if (comp != null) {
                        IProject project = comp.getProject();
                        extraEntries.add(JavaCore.newProjectEntry((IPath)project.getFullPath(), (boolean)true));
                    } else {
                        String compSearchName = manifestURI.substring(0, manifestURI.length() - 4);
                        IVirtualReference vRef = earComponent.getReference(compSearchName);
                        if (vRef != null && nestedComponent.getProject() != vRef.getReferencedComponent().getProject()) {
                            IProject project = vRef.getReferencedComponent().getProject();
                            extraEntries.add(JavaCore.newProjectEntry((IPath)project.getFullPath(), (boolean)true));
                        }
                    }
                }
            }
            ++j;
        }
    }

    protected SaveStrategy createSaveStrategy(IProject project) {
        return null;
    }

    protected SaveStrategy createSaveStrategy(IVirtualComponent virtualComponent) {
        return new EARComponentSaveStrategyImpl(virtualComponent);
    }

    protected EARFile getEarFile() {
        return (EARFile)this.model.getProperty("IJ2EEArtifactImportDataModelProperties.FILE");
    }
}

