/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.util.ViewUtility;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class FixedOrDefaultTextPropertyDescriptor
extends PropertyDescriptor {
    protected static String choice = "";
    Element element;

    public FixedOrDefaultTextPropertyDescriptor(Object id, String displayName, Element element) {
        super(id, displayName);
        this.element = element;
    }

    public CellEditor createPropertyEditor(Composite parent) {
        FixedOrDefaultTextCellEditor editor = new FixedOrDefaultTextCellEditor(parent);
        if (this.getValidator() != null) {
            editor.setValidator(this.getValidator());
        }
        return editor;
    }

    public Object getId() {
        Attr fixedAttr = this.element.getAttributeNode("fixed");
        Attr defaultAttr = this.element.getAttributeNode("default");
        choice = fixedAttr != null ? "fixed" : (defaultAttr != null ? "default" : "");
        if (choice.equals("fixed")) {
            return "fixed";
        }
        if (choice.equals("default")) {
            return "default";
        }
        return super.getId();
    }

    public String getDisplayName() {
        Attr fixedAttr = this.element.getAttributeNode("fixed");
        Attr defaultAttr = this.element.getAttributeNode("default");
        choice = fixedAttr != null ? "fixed" : (defaultAttr != null ? "default" : "fixed/default");
        if (choice.equals("fixed")) {
            return "fixed";
        }
        if (choice.equals("default")) {
            return "default";
        }
        return super.getDisplayName();
    }

    class FixedOrDefaultTextCellEditor
    extends DialogCellEditor {
        public FixedOrDefaultTextCellEditor(Composite parent) {
            super(parent);
        }

        protected Object openDialogBox(Control cellEditorWindow) {
            Shell shell = Display.getCurrent().getActiveShell();
            FixedOrDefaultDialog dialog = new FixedOrDefaultDialog(shell);
            dialog.setBlockOnOpen(true);
            dialog.create();
            int result = dialog.open();
            if (result == 0) {
                dialog.getValue();
                this.fireApplyEditorValue();
            }
            this.deactivate();
            return null;
        }
    }

    class FixedOrDefaultDialog
    extends Dialog
    implements SelectionListener {
        private int FIXED = 0;
        private int DEFAULT = 1;
        private int type;
        protected Button fixedButton;
        protected Button defaultButton;
        protected Text valueField;
        protected String valueString = "";

        public FixedOrDefaultDialog(Shell shell) {
            super(shell);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                this.valueString = this.valueField.getText();
                this.applyEditorValueAndDeactivate();
            }
            super.buttonPressed(buttonId);
        }

        public String getValue() {
            return this.valueString;
        }

        public String getType() {
            return this.type == this.FIXED ? "fixed" : "default";
        }

        public Control createDialogArea(Composite parent) {
            Composite client = (Composite)super.createDialogArea(parent);
            this.getShell().setText(XSDEditorPlugin.getXSDString("_UI_LABEL_FIXEDORDEFAULT_VALUE"));
            GridLayout gl = new GridLayout(1, true);
            client.setLayout((Layout)gl);
            GridData gd = new GridData();
            gd.grabExcessHorizontalSpace = true;
            gd.grabExcessVerticalSpace = true;
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 4;
            gd.horizontalIndent = 0;
            client.setLayoutData((Object)gd);
            this.fixedButton = ViewUtility.createRadioButton(client, XSDEditorPlugin.getXSDString("_UI_FIXED"));
            this.defaultButton = ViewUtility.createRadioButton(client, XSDEditorPlugin.getXSDString("_UI_DEFAULT"));
            this.valueField = ViewUtility.createTextField(client, 30);
            WorkbenchHelp.setHelp((Control)this.fixedButton, (String)"org.eclipse.wst.xsd.ui.internal.xsde1030");
            WorkbenchHelp.setHelp((Control)this.defaultButton, (String)"org.eclipse.wst.xsd.ui.internal.xsde1040");
            Attr fixedAttr = FixedOrDefaultTextPropertyDescriptor.this.element.getAttributeNode("fixed");
            Attr defaultAttr = FixedOrDefaultTextPropertyDescriptor.this.element.getAttributeNode("default");
            if (fixedAttr != null) {
                this.fixedButton.setSelection(true);
                this.defaultButton.setSelection(false);
                choice = "fixed";
                this.type = this.FIXED;
                this.valueField.setText(FixedOrDefaultTextPropertyDescriptor.this.element.getAttribute("fixed"));
                this.valueField.setFocus();
                this.valueField.selectAll();
            }
            if (defaultAttr != null) {
                this.fixedButton.setSelection(false);
                this.defaultButton.setSelection(true);
                choice = "default";
                this.type = this.DEFAULT;
                this.valueField.setText(FixedOrDefaultTextPropertyDescriptor.this.element.getAttribute("default"));
                this.valueField.setFocus();
                this.valueField.selectAll();
            }
            this.fixedButton.addSelectionListener((SelectionListener)this);
            this.defaultButton.addSelectionListener((SelectionListener)this);
            return client;
        }

        void applyEditorValueAndDeactivate() {
            String value = this.valueField.getText();
            if (value != null && value.length() > 0) {
                String string = choice = this.type == this.FIXED ? "fixed" : "default";
            }
            if (value != null && value.length() > 0) {
                if (choice.equals("fixed")) {
                    FixedOrDefaultTextPropertyDescriptor.this.element.removeAttribute("default");
                    FixedOrDefaultTextPropertyDescriptor.this.element.setAttribute("fixed", value);
                } else if (choice.equals("default")) {
                    FixedOrDefaultTextPropertyDescriptor.this.element.removeAttribute("fixed");
                    FixedOrDefaultTextPropertyDescriptor.this.element.setAttribute("default", value);
                }
            }
            if (value.equals("")) {
                choice = "";
                FixedOrDefaultTextPropertyDescriptor.this.element.removeAttribute("default");
                FixedOrDefaultTextPropertyDescriptor.this.element.removeAttribute("fixed");
            }
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == this.fixedButton && this.fixedButton.getSelection()) {
                this.type = this.FIXED;
                choice = "fixed";
            } else if (e.widget == this.defaultButton && this.defaultButton.getSelection()) {
                this.type = this.DEFAULT;
                choice = "default";
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

