/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties.section;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wst.common.ui.properties.internal.provisional.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.properties.section.AbstractSection;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.w3c.dom.Element;

public class MinMaxSection
extends AbstractSection {
    CCombo minCombo;
    CCombo maxCombo;

    public void doHandleEvent(Event event) {
        if (event.widget == this.minCombo) {
            this.updateMinAttribute();
        } else if (event.widget == this.maxCombo) {
            this.updateMaxAttribute();
        }
    }

    public void doWidgetSelected(SelectionEvent e) {
        if (e.widget == this.minCombo) {
            this.updateMinAttribute();
        } else if (e.widget == this.maxCombo) {
            this.updateMaxAttribute();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateMinAttribute() {
        XSDParticle particle = null;
        Object input = this.getInput();
        if (input instanceof XSDParticleContent) {
            particle = this.getAssociatedParticle((XSDParticleContent)input);
        }
        if (particle == null) return;
        Element element = particle.getElement();
        String newValue = "";
        newValue = this.minCombo.getText();
        this.beginRecording(XSDEditorPlugin.getXSDString("_UI_MINOCCURS_CHANGE"), element);
        if (newValue.length() == 0) {
            particle.unsetMinOccurs();
        }
        try {
            block8: {
                try {
                    if (newValue.equals("unbounded") || newValue.equals("*")) {
                        particle.setMinOccurs(-1);
                        break block8;
                    }
                    int val = Integer.parseInt(newValue);
                    particle.setMinOccurs(val);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.endRecording(element);
            throw throwable;
        }
        this.endRecording(element);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateMaxAttribute() {
        XSDParticle particle = null;
        Object input = this.getInput();
        if (input instanceof XSDParticleContent) {
            particle = this.getAssociatedParticle((XSDParticleContent)input);
        }
        if (particle == null) return;
        Element element = particle.getElement();
        String newValue = "";
        newValue = this.maxCombo.getText();
        this.beginRecording(XSDEditorPlugin.getXSDString("_UI_MAXOCCURS_CHANGE"), element);
        if (newValue.length() == 0) {
            particle.unsetMaxOccurs();
        }
        try {
            block8: {
                try {
                    if (newValue.equals("unbounded") || newValue.equals("*")) {
                        particle.setMaxOccurs(-1);
                        break block8;
                    }
                    int val = Integer.parseInt(newValue);
                    particle.setMaxOccurs(val);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.endRecording(element);
            throw throwable;
        }
        this.endRecording(element);
    }

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.minCombo = this.getWidgetFactory().createCCombo(this.composite, 0x800000);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 100);
        data.right = new FormAttachment(100, -this.rightMarginSpace - 5);
        data.top = new FormAttachment(0, 0);
        this.minCombo.setLayoutData((Object)data);
        this.minCombo.add("0");
        this.minCombo.add("1");
        this.minCombo.addListener(24, (Listener)this);
        this.minCombo.addSelectionListener((SelectionListener)this);
        CLabel minLabel = this.getWidgetFactory().createCLabel(this.composite, "minOccurs:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.minCombo, -5);
        data.top = new FormAttachment((Control)this.minCombo, 0, 0x1000000);
        minLabel.setLayoutData((Object)data);
        this.maxCombo = this.getWidgetFactory().createCCombo(this.composite, 0x800000);
        data = new FormData();
        data.left = new FormAttachment(0, 100);
        data.right = new FormAttachment(100, -this.rightMarginSpace - 5);
        data.top = new FormAttachment((Control)this.minCombo, 4);
        this.maxCombo.setLayoutData((Object)data);
        this.maxCombo.add("0");
        this.maxCombo.add("1");
        this.maxCombo.add("unbounded");
        this.maxCombo.addListener(24, (Listener)this);
        this.maxCombo.addSelectionListener((SelectionListener)this);
        CLabel maxLabel = this.getWidgetFactory().createCLabel(this.composite, "maxOccurs:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.maxCombo, -5);
        data.top = new FormAttachment((Control)this.maxCombo, 0, 0x1000000);
        maxLabel.setLayoutData((Object)data);
    }

    public void refresh() {
        if (this.doRefresh) {
            Element element;
            XSDParticle particle;
            Object input;
            if (this.isReadOnly) {
                this.composite.setEnabled(false);
            } else {
                this.composite.setEnabled(true);
            }
            this.setListenerEnabled(false);
            boolean refreshMinText = true;
            boolean refreshMaxText = true;
            if (this.minCombo.isFocusControl()) {
                refreshMinText = false;
            }
            if (this.maxCombo.isFocusControl()) {
                refreshMaxText = false;
            }
            if (refreshMinText) {
                this.minCombo.setText("");
            }
            if (refreshMaxText) {
                this.maxCombo.setText("");
            }
            if ((input = this.getInput()) != null && input instanceof XSDParticleContent && (particle = this.getAssociatedParticle((XSDParticleContent)input)) != null && (element = particle.getElement()) != null) {
                String min = element.getAttribute("minOccurs");
                String max = element.getAttribute("maxOccurs");
                if (min != null && refreshMinText) {
                    this.minCombo.setText(min);
                }
                if (max != null && refreshMaxText) {
                    this.maxCombo.setText(max);
                }
            }
            this.setListenerEnabled(true);
        }
    }

    public boolean shouldUseExtraSpace() {
        return false;
    }

    private XSDParticle getAssociatedParticle(XSDParticleContent particleContent) {
        XSDConcreteComponent xsdComp = particleContent.getContainer();
        if (xsdComp instanceof XSDParticle) {
            return (XSDParticle)xsdComp;
        }
        return null;
    }
}

