/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties.section;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wst.common.ui.properties.internal.provisional.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.properties.section.AbstractSection;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDModelGroup;
import org.w3c.dom.Element;

public class ModelGroupSection
extends AbstractSection {
    CCombo modelGroupCombo;
    private String[] modelGroupComboValues = new String[]{"sequence", "choice", "all"};

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.modelGroupCombo = this.getWidgetFactory().createCCombo(this.composite, 0x800000);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 100);
        data.right = new FormAttachment(100, -this.rightMarginSpace - 5);
        data.top = new FormAttachment(0, 0);
        this.modelGroupCombo.setLayoutData((Object)data);
        this.modelGroupCombo.addSelectionListener((SelectionListener)this);
        this.modelGroupCombo.setItems(this.modelGroupComboValues);
        CLabel cLabel = this.getWidgetFactory().createCLabel(this.composite, XSDEditorPlugin.getXSDString("_UI_LABEL_KIND"));
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.modelGroupCombo, -5);
        data.top = new FormAttachment((Control)this.modelGroupCombo, 0, 0x1000000);
        cLabel.setLayoutData((Object)data);
    }

    public void refresh() {
        this.setListenerEnabled(false);
        if (this.isReadOnly) {
            this.composite.setEnabled(false);
        } else {
            this.composite.setEnabled(true);
        }
        Object input = this.getInput();
        if (input != null && input instanceof XSDModelGroup) {
            XSDModelGroup particle = (XSDModelGroup)input;
            String modelType = particle.getCompositor().getName();
            this.modelGroupCombo.setText(modelType);
        }
        this.setListenerEnabled(true);
    }

    public void widgetSelected(SelectionEvent e) {
        Object input;
        if (e.widget == this.modelGroupCombo && (input = this.getInput()) instanceof XSDModelGroup) {
            XSDModelGroup particle = (XSDModelGroup)input;
            Element element = particle.getElement();
            Element parent = (Element)element.getParentNode();
            this.beginRecording(XSDEditorPlugin.getXSDString("_UI_GROUP_SCOPE_CHANGE"), parent);
            particle.setCompositor(XSDCompositor.get((String)this.modelGroupCombo.getText()));
            this.endRecording(parent);
            this.refresh();
        }
    }
}

