/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties.section;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.common.ui.properties.internal.provisional.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.properties.section.AbstractSection;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticleContent;
import org.w3c.dom.Element;

public class ReferenceSection
extends AbstractSection {
    protected CCombo componentNameCombo;
    Button button;
    IEditorPart editorPart;
    CLabel refLabel;

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.componentNameCombo = this.getWidgetFactory().createCCombo(this.composite, 0x800000);
        this.componentNameCombo.addSelectionListener((SelectionListener)this);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 100);
        data.right = new FormAttachment(100, -this.rightMarginSpace - 5);
        data.top = new FormAttachment(0, 1);
        this.componentNameCombo.setLayoutData((Object)data);
        this.refLabel = this.getWidgetFactory().createCLabel(this.composite, "ref:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.componentNameCombo, -5);
        data.top = new FormAttachment((Control)this.componentNameCombo, 0, 0x1000000);
        this.refLabel.setLayoutData((Object)data);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        XSDAttributeUse attributeUse;
        Element element;
        super.setInput(part, selection);
        Object obj = this.getInput();
        TypesHelper helper = new TypesHelper(this.xsdSchema);
        List items = new ArrayList();
        if (obj instanceof XSDElementDeclaration) {
            XSDElementDeclaration elementDeclaration = (XSDElementDeclaration)obj;
            if (elementDeclaration.isElementDeclarationReference()) {
                items = helper.getGlobalElements();
            }
        } else if (obj instanceof XSDAttributeDeclaration) {
            items = helper.getGlobalAttributes();
        } else if (obj instanceof XSDModelGroupDefinition) {
            XSDModelGroupDefinition group = (XSDModelGroupDefinition)obj;
            if (group.isModelGroupDefinitionReference()) {
                items = helper.getModelGroups();
            }
        } else if (obj instanceof XSDNamedComponent) {
            XSDNamedComponent namedComponent = (XSDNamedComponent)obj;
            element = namedComponent.getElement();
            if (XSDDOMHelper.inputEquals(element, "attributeGroup", true)) {
                items = helper.getGlobalAttributeGroups();
            } else if (XSDDOMHelper.inputEquals(element, "element", true)) {
                items = helper.getGlobalElements();
            }
        } else if (obj instanceof XSDAttributeUse && XSDDOMHelper.inputEquals(element = (attributeUse = (XSDAttributeUse)obj).getElement(), "attribute", true)) {
            items = helper.getGlobalAttributes();
        }
        items.add(0, "");
        int size = items.size();
        String[] st = new String[size];
        System.arraycopy(items.toArray(), 0, st, 0, size);
        this.componentNameCombo.setItems(st);
        st = null;
    }

    public void refresh() {
        if (this.doRefresh) {
            this.setListenerEnabled(false);
            Object input = this.getInput();
            if (this.isReadOnly) {
                this.composite.setEnabled(false);
            } else {
                this.composite.setEnabled(true);
            }
            if (input instanceof XSDNamedComponent) {
                XSDNamedComponent namedComponent = (XSDNamedComponent)this.getInput();
                Element element = namedComponent.getElement();
                if (element != null) {
                    String attrValue = element.getAttribute("ref");
                    if (attrValue == null) {
                        attrValue = "";
                    }
                    this.componentNameCombo.setText(attrValue);
                }
            } else if (input instanceof XSDParticleContent) {
                XSDParticleContent particle = (XSDParticleContent)input;
                Element element = particle.getElement();
                String attrValue = element.getAttribute("ref");
                if (attrValue == null) {
                    attrValue = "";
                }
                this.componentNameCombo.setText(attrValue);
            } else if (input instanceof XSDAttributeUse) {
                XSDAttributeUse attributeUse = (XSDAttributeUse)this.getInput();
                Element element = attributeUse.getElement();
                String attrValue = element.getAttribute("ref");
                if (attrValue == null) {
                    attrValue = "";
                }
                this.componentNameCombo.setText(attrValue);
            }
            this.setListenerEnabled(true);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        Object input = this.getInput();
        if (e.widget == this.componentNameCombo) {
            String newValue = this.componentNameCombo.getText();
            if (input instanceof XSDNamedComponent) {
                XSDNamedComponent namedComponent = (XSDNamedComponent)this.getInput();
                Element element = namedComponent.getElement();
                if (namedComponent instanceof XSDElementDeclaration) {
                    this.beginRecording(XSDEditorPlugin.getXSDString("_UI_GROUP_REF_CHANGE"), element);
                    element.setAttribute("ref", newValue);
                    this.endRecording(element);
                } else if (namedComponent instanceof XSDAttributeDeclaration) {
                    this.beginRecording(XSDEditorPlugin.getXSDString("_UI_ATTRIBUTEGROUP_REF_CHANGE"), element);
                    element.setAttribute("ref", newValue);
                    this.endRecording(element);
                } else if (namedComponent instanceof XSDAttributeGroupDefinition) {
                    this.beginRecording(XSDEditorPlugin.getXSDString("_UI_ATTRIBUTEGROUP_REF_CHANGE"), element);
                    XSDAttributeGroupDefinition attrGroup = (XSDAttributeGroupDefinition)namedComponent;
                    Iterator iter = this.xsdSchema.getAttributeGroupDefinitions().iterator();
                    while (iter.hasNext()) {
                        XSDAttributeGroupDefinition def = (XSDAttributeGroupDefinition)iter.next();
                        if (!def.getQName((XSDConcreteComponent)this.xsdSchema).equals(this.componentNameCombo.getText())) continue;
                        attrGroup.setResolvedAttributeGroupDefinition(def);
                        attrGroup.setName(this.componentNameCombo.getText());
                        break;
                    }
                    this.endRecording(element);
                } else if (namedComponent instanceof XSDModelGroupDefinition) {
                    this.beginRecording(XSDEditorPlugin.getXSDString("_UI_GROUP_REF_CHANGE"), element);
                    element.setAttribute("ref", newValue);
                    this.endRecording(element);
                }
            } else if (input instanceof XSDAttributeUse) {
                XSDAttributeUse attributeUse = (XSDAttributeUse)this.getInput();
                Element element = attributeUse.getElement();
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_ATTRIBUTE_USE_CHANGE"), element);
                Iterator iter = this.xsdSchema.getAttributeDeclarations().iterator();
                while (iter.hasNext()) {
                    XSDAttributeDeclaration attr = (XSDAttributeDeclaration)iter.next();
                    if (!attr.getQName((XSDConcreteComponent)this.xsdSchema).equals(newValue)) continue;
                    attributeUse.setAttributeDeclaration(attr);
                    element.setAttribute("ref", newValue);
                    break;
                }
                this.endRecording(element);
            }
        }
    }

    public void setEditorPart(IEditorPart editorPart) {
        this.editorPart = editorPart;
    }
}

