/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.delete;

import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.refactor.delete.BaseGlobalCleanup;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupContent;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Element;

public class GlobalSimpleOrComplexTypeCleanup
extends BaseGlobalCleanup {
    public GlobalSimpleOrComplexTypeCleanup(XSDConcreteComponent deletedItem) {
        super(deletedItem);
    }

    public void visitElementDeclaration(XSDElementDeclaration element) {
        if (!element.isElementDeclarationReference() && this.deletedItem.equals(element.getTypeDefinition())) {
            this.resetTypeToString(element.getElement());
            String msg = "";
            if (element.isGlobal()) {
                String pattern = XSDEditorPlugin.getXSDString("_INFO_RESET_GLOBAL_ELEMENT");
                Object[] args = new Object[]{element.getName()};
                msg = MessageFormat.format(pattern, args);
            } else {
                msg = XSDEditorPlugin.getXSDString("_INFO_RESET_ELEMENT");
                msg = String.valueOf(msg) + "<" + element.getName() + "> " + XSDEditorPlugin.getXSDString("_UI_TO_TYPE_STRING");
            }
            this.addMessage(msg, (XSDConcreteComponent)element);
        }
        super.visitElementDeclaration(element);
    }

    public void visitComplexTypeDefinition(XSDComplexTypeDefinition type) {
        XSDTypeDefinition base;
        super.visitComplexTypeDefinition(type);
        if (type.getAttributeContents() != null) {
            Iterator iter = type.getAttributeContents().iterator();
            while (iter.hasNext()) {
                XSDAttributeUse attrUse;
                XSDAttributeDeclaration attrDecl;
                XSDAttributeGroupContent attrGroupContent = (XSDAttributeGroupContent)iter.next();
                if (!(attrGroupContent instanceof XSDAttributeUse) || (attrDecl = (attrUse = (XSDAttributeUse)attrGroupContent).getContent()) == null || attrDecl.isAttributeDeclarationReference() || !this.deletedItem.equals(attrDecl.getTypeDefinition())) continue;
                this.resetTypeToString(attrDecl.getElement());
                String msg = String.valueOf(XSDEditorPlugin.getXSDString("_INFO_RESET_ATTRIBUTE")) + " <" + attrDecl.getName() + "> " + XSDEditorPlugin.getXSDString("_UI_TO_TYPE_STRING");
                this.addMessage(msg, (XSDConcreteComponent)attrDecl);
                this.resetTypeToString(attrDecl.getElement());
            }
        }
        if ((base = type.getBaseTypeDefinition()) != null && base == this.deletedItem) {
            String msg = String.valueOf(XSDEditorPlugin.getXSDString("_INFO_RESET_COMPLEX_TYPE")) + " <" + this.getNamedComponentName((XSDConcreteComponent)type) + "> " + XSDEditorPlugin.getXSDString("_UI_DERIVATION");
            this.addMessage(msg, (XSDConcreteComponent)type);
            type.setBaseTypeDefinition(null);
            EList listOfCT = this.schema.getTypeDefinitions();
            XSDTypeDefinition typeDefinition = null;
            if (listOfCT.size() > 0) {
                Iterator iter = listOfCT.iterator();
                while (iter.hasNext()) {
                    typeDefinition = (XSDTypeDefinition)iter.next();
                    if (typeDefinition == this.deletedItem) continue;
                    type.setBaseTypeDefinition(typeDefinition);
                }
            }
        }
    }

    public void visitSimpleTypeDefinition(XSDSimpleTypeDefinition type) {
        if (type.getBaseTypeDefinition() == this.deletedItem) {
            type.setBaseTypeDefinition(this.schema.resolveSimpleTypeDefinition("http://www.w3.org/2001/XMLSchema", "string"));
        }
    }

    protected void resetTypeToString(Element element) {
        String prefix = element.getPrefix();
        prefix = prefix == null ? "" : String.valueOf(prefix) + ":";
        element.setAttribute("type", String.valueOf(prefix) + "string");
    }
}

