/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.rename;

import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.BaseCleanup;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupContent;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Element;

public class XSDExternalFileCleanup
extends BaseCleanup {
    protected XSDSchema deletedSchema;
    protected String oldFilename;

    public XSDExternalFileCleanup(String oldFilename) {
        this.oldFilename = oldFilename;
    }

    public XSDExternalFileCleanup(XSDSchema deletedSchema) {
        this.deletedSchema = deletedSchema;
    }

    public void visitElementDeclaration(XSDElementDeclaration element) {
        boolean addMessage = true;
        String schemaLocation = element.getSchema().getSchemaLocation();
        if (schemaLocation != null && !schemaLocation.equals(this.schema.getSchemaLocation())) {
            addMessage = false;
        }
        if (element.isElementDeclarationReference()) {
            if (this.isFromDeletedSchema((XSDConcreteComponent)element.getResolvedElementDeclaration())) {
                if (addMessage) {
                    String msg = "_INFO_REMOVE_ELEMENT_REFERENCE <" + this.getNamedComponentName(element.getContainer()) + ">";
                    this.addMessage(msg, element.getContainer());
                }
                this.childrenToRemove.add(element.getElement());
            }
        } else if (this.removeType(element)) {
            String msg = "";
            if (element.isGlobal()) {
                String pattern = "_INFO_RESET_GLOBAL_ELEMENT";
                Object[] args = new Object[]{element.getName()};
                msg = MessageFormat.format(pattern, args);
            } else {
                msg = "_INFO_RESET_ELEMENT";
                msg = String.valueOf(msg) + "<" + element.getName() + "> " + "_UI_TO_TYPE_STRING";
            }
            if (addMessage) {
                this.addMessage(msg, (XSDConcreteComponent)element);
            }
        }
        super.visitElementDeclaration(element);
    }

    protected void resetTypeToString(Element element) {
        String prefix = element.getPrefix();
        prefix = prefix == null ? "" : String.valueOf(prefix) + ":";
        element.setAttribute("type", String.valueOf(prefix) + "string");
    }

    protected boolean removeType(XSDElementDeclaration element) {
        if (this.removeType(element.getTypeDefinition())) {
            this.resetTypeToString(element.getElement());
            return true;
        }
        return false;
    }

    protected boolean isFromDeletedSchema(XSDConcreteComponent component) {
        if (component == null) {
            return false;
        }
        XSDConcreteComponent root = component.getRootContainer();
        boolean isFromDeletedSchema = false;
        if (this.deletedSchema.getContents() != null) {
            Iterator contents = this.deletedSchema.getContents().iterator();
            while (contents.hasNext()) {
                XSDSchemaContent content = (XSDSchemaContent)contents.next();
                if (!(content instanceof XSDSchemaDirective)) continue;
                XSDSchema aSchema = ((XSDSchemaDirective)content).getResolvedSchema();
                if (root == null || !root.equals(aSchema)) continue;
                isFromDeletedSchema = true;
            }
        }
        if (root != null && root.equals(this.deletedSchema)) {
            isFromDeletedSchema = true;
        }
        return isFromDeletedSchema;
    }

    protected boolean removeType(XSDTypeDefinition typeDef) {
        if (typeDef == null) {
            return false;
        }
        return this.isFromDeletedSchema((XSDConcreteComponent)typeDef);
    }

    public void visitComplexTypeDefinition(XSDComplexTypeDefinition type) {
        XSDSimpleTypeDefinition baseType;
        XSDTypeDefinition base;
        super.visitComplexTypeDefinition(type);
        if (type.getAttributeContents() != null) {
            Iterator iter = type.getAttributeContents().iterator();
            while (iter.hasNext()) {
                XSDAttributeGroupDefinition attrGroupDef;
                String msg;
                XSDAttributeGroupContent attrGroupContent = (XSDAttributeGroupContent)iter.next();
                if (attrGroupContent instanceof XSDAttributeUse) {
                    XSDAttributeUse attrUse = (XSDAttributeUse)attrGroupContent;
                    XSDAttributeDeclaration attrDecl = attrUse.getContent();
                    if (attrDecl.isAttributeDeclarationReference()) {
                        if (!this.isFromDeletedSchema((XSDConcreteComponent)attrDecl.getResolvedAttributeDeclaration())) continue;
                        String name = this.getNamedComponentName((XSDConcreteComponent)type);
                        String msg2 = "_INFO_REMOVE_ATTRIBUTE_REFERENCE <" + name + ">";
                        this.addMessage(msg2, attrDecl.getContainer());
                        this.childrenToRemove.add(attrDecl.getElement());
                        continue;
                    }
                    if (!this.removeType((XSDTypeDefinition)attrDecl.getTypeDefinition())) continue;
                    msg = "_INFO_RESET_ATTRIBUTE <" + attrDecl.getName() + "> " + "_UI_TO_TYPE_STRING";
                    this.addMessage(msg, (XSDConcreteComponent)attrDecl);
                    this.resetTypeToString(attrDecl.getElement());
                    continue;
                }
                if (!(attrGroupContent instanceof XSDAttributeGroupDefinition) || !this.isFromDeletedSchema((XSDConcreteComponent)(attrGroupDef = (XSDAttributeGroupDefinition)attrGroupContent).getResolvedAttributeGroupDefinition())) continue;
                String name = this.getNamedComponentName((XSDConcreteComponent)type);
                msg = "_INFO_REMOVE_ATTRIBUTE_GROUP_REFERENCE <" + name + ">";
                this.addMessage(msg, attrGroupDef.getContainer());
                this.childrenToRemove.add(attrGroupDef.getElement());
            }
        }
        if ((base = type.getBaseTypeDefinition()) instanceof XSDSimpleTypeDefinition && this.isFromDeletedSchema((XSDConcreteComponent)(baseType = (XSDSimpleTypeDefinition)base))) {
            String msg = "_INFO_RESET_COMPLEX_TYPE <" + this.getNamedComponentName((XSDConcreteComponent)type) + "> " + "_UI_DERIVATION";
            this.addMessage(msg, (XSDConcreteComponent)type);
            type.setBaseTypeDefinition((XSDTypeDefinition)this.schema.getSchemaForSchema().resolveSimpleTypeDefinition("string"));
        }
    }

    public void visitModelGroupDefinition(XSDModelGroupDefinition modelGroup) {
        super.visitModelGroupDefinition(modelGroup);
        if (modelGroup.isModelGroupDefinitionReference() && this.isFromDeletedSchema((XSDConcreteComponent)modelGroup.getResolvedModelGroupDefinition())) {
            String name = this.getNamedComponentName((XSDConcreteComponent)modelGroup);
            String msg = "_INFO_REMOVE_GROUP_REFERENCE <" + name + ">";
            this.addMessage(msg, modelGroup.getContainer());
            this.childrenToRemove.add(modelGroup.getElement());
        }
    }

    public void visitSimpleTypeDefinition(XSDSimpleTypeDefinition type) {
        super.visitSimpleTypeDefinition(type);
        XSDSimpleTypeDefinition baseType = type.getBaseTypeDefinition();
        if (this.isFromDeletedSchema((XSDConcreteComponent)baseType)) {
            String msg = "_INFO_RESET_SIMPLE_TYPE <" + this.getNamedComponentName((XSDConcreteComponent)type) + "> " + "_UI_DERIVATION";
            this.addMessage(msg, (XSDConcreteComponent)type);
            type.getFacetContents().clear();
            type.getFacets().clear();
            type.setBaseTypeDefinition(this.schema.getSchemaForSchema().resolveSimpleTypeDefinition("string"));
        }
    }
}

