/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.reconcile.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.osgi.framework.Bundle;

public class ValidatorMetaData {
    private String fClass = null;
    private IConfigurationElement fConfigurationElement = null;
    private String fId = null;
    private String fScope;
    private HashMap fMatrix = null;

    public ValidatorMetaData(IConfigurationElement element, String vId, String vClass, String vScope) {
        this.fId = vId;
        this.fClass = vClass;
        this.fConfigurationElement = element;
        this.fScope = vScope;
        this.fMatrix = new HashMap();
    }

    private String[] calculateParentContentTypeIds(String contentTypeId) {
        HashSet<String> parentTypes = new HashSet<String>();
        IContentTypeManager ctManager = Platform.getContentTypeManager();
        IContentType ct = ctManager.getContentType(contentTypeId);
        String id = contentTypeId;
        while (ct != null && id != null) {
            parentTypes.add(id);
            ct = ctManager.getContentType(id);
            if (ct == null) continue;
            IContentType baseType = ct.getBaseType();
            String string = id = baseType != null ? baseType.getId() : null;
        }
        return parentTypes.toArray(new String[parentTypes.size()]);
    }

    public void addContentTypeId(String contentTypeId) {
        if (!this.fMatrix.containsKey(contentTypeId)) {
            this.fMatrix.put(contentTypeId, new ArrayList());
        }
    }

    public void addParitionType(String contentTypeId, String partitionType) {
        if (!this.fMatrix.containsKey(contentTypeId)) {
            this.fMatrix.put(contentTypeId, new ArrayList());
        }
        List partitionList = (List)this.fMatrix.get(contentTypeId);
        partitionList.add(partitionType);
    }

    public boolean canHandleContentType(String contentType) {
        String[] contentHierarchy = this.calculateParentContentTypeIds(contentType);
        int i = 0;
        while (i < contentHierarchy.length) {
            if (this.fMatrix.containsKey(contentHierarchy[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean canHandleParitionType(String[] contentTypeIds, String paritionType) {
        int i = 0;
        while (i < contentTypeIds.length) {
            if (this.fMatrix.containsKey(contentTypeIds[i])) {
                List partitions = (List)this.fMatrix.get(contentTypeIds[i]);
                int j = 0;
                while (j < partitions.size()) {
                    if (paritionType.equals(partitions.get(j))) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    Object createExecutableExtension(IConfigurationElement element, String classAttribute) throws CoreException {
        Object obj = null;
        obj = element.createExecutableExtension(classAttribute);
        return obj;
    }

    public Object createExtension() {
        final IConfigurationElement element = this.getConfigurationElement();
        final Object[] result = new Object[1];
        String pluginId = element.getDeclaringExtension().getNamespace();
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle.getState() == 32) {
            try {
                return this.createExecutableExtension(element, "class");
            }
            catch (CoreException e) {
                this.handleCreateExecutableException(result, e);
            }
        } else {
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                public void run() {
                    try {
                        result[0] = ValidatorMetaData.this.createExecutableExtension(element, "class");
                    }
                    catch (Exception e) {
                        ValidatorMetaData.this.handleCreateExecutableException(result, e);
                    }
                }
            });
        }
        return result[0];
    }

    public IValidator createValidator() {
        Object obj = null;
        obj = this.createExtension();
        if (obj == null) {
            return null;
        }
        return obj instanceof IValidator ? (IValidator)obj : null;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.fConfigurationElement;
    }

    public String getValidatorClass() {
        return this.fClass;
    }

    public String getValidatorId() {
        return this.fId;
    }

    void handleCreateExecutableException(Object[] result, Throwable e) {
        Logger.logException(e);
        e.printStackTrace();
        result[0] = null;
    }

    public int getValidatorScope() {
        return this.fScope.equalsIgnoreCase("total") ? 0 : 1;
    }

    public String toString() {
        StringBuffer debugString = new StringBuffer("ValidatorMetaData:");
        if (this.fId != null) {
            debugString.append(" [id:" + this.fId + "]");
        }
        return debugString.toString();
    }
}

