/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.taginfo;

import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.preferences.EditorPreferenceNames;
import org.eclipse.wst.sse.ui.internal.taginfo.BestMatchHover;

public class TextHoverManager {
    public static final String ANNOTATION_HOVER = "annotationHover";
    public static final String COMBINATION_HOVER = "combinationHover";
    private static final String DESCRIPTION_KEY = "_desc";
    public static final String DOCUMENTATION_HOVER = "documentationHover";
    public static final String HOVER_ATTRIBUTE_SEPARATOR = "|";
    public static final String HOVER_SEPARATOR = ";";
    private static final String LABEL_KEY = "_label";
    public static final String NO_MODIFIER = "0";
    public static final String PROBLEM_HOVER = "problemHover";
    public static final String[] TEXT_HOVER_IDS = new String[]{"combinationHover", "problemHover", "documentationHover", "annotationHover"};
    private TextHoverDescriptor[] fTextHovers;

    public ITextHover createBestMatchHover(ITextHover infoHover) {
        return new BestMatchHover(infoHover);
    }

    public TextHoverDescriptor[] generateTextHoverDescriptors(String textHoverStrings) {
        StringTokenizer st = new StringTokenizer(textHoverStrings, HOVER_SEPARATOR);
        HashMap<String, TextHoverDescriptor> idToModifier = new HashMap<String, TextHoverDescriptor>(st.countTokens());
        while (st.hasMoreTokens()) {
            String textHoverString = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(textHoverString, HOVER_ATTRIBUTE_SEPARATOR);
            if (st2.countTokens() != 3) continue;
            String id = st2.nextToken();
            boolean enabled = Boolean.valueOf(st2.nextToken());
            String modifierString = st2.nextToken();
            if (modifierString.equals(NO_MODIFIER)) {
                modifierString = "";
            }
            String label = null;
            String description = null;
            try {
                label = SSEUIMessages.getResourceBundle().getString(String.valueOf(id) + LABEL_KEY);
                description = SSEUIMessages.getResourceBundle().getString(String.valueOf(id) + DESCRIPTION_KEY);
            }
            catch (Exception e) {
                Logger.log(202, e.getMessage(), e);
            }
            TextHoverDescriptor descriptor = new TextHoverDescriptor(id, label, description, enabled, modifierString);
            idToModifier.put(id, descriptor);
        }
        TextHoverDescriptor[] descriptors = new TextHoverDescriptor[TEXT_HOVER_IDS.length];
        int i = 0;
        while (i < TEXT_HOVER_IDS.length) {
            TextHoverDescriptor desc = (TextHoverDescriptor)idToModifier.get(TEXT_HOVER_IDS[i]);
            if (desc != null) {
                descriptors[i] = desc;
            } else {
                String label = null;
                String description = null;
                try {
                    label = SSEUIMessages.getResourceBundle().getString(String.valueOf(TEXT_HOVER_IDS[i]) + LABEL_KEY);
                    description = SSEUIMessages.getResourceBundle().getString(String.valueOf(TEXT_HOVER_IDS[i]) + DESCRIPTION_KEY);
                }
                catch (Exception e) {
                    Logger.log(202, e.getMessage(), e);
                }
                descriptors[i] = new TextHoverDescriptor(TEXT_HOVER_IDS[i], label, description);
            }
            ++i;
        }
        return descriptors;
    }

    private IPreferenceStore getPreferenceStore() {
        return SSEUIPlugin.getDefault().getPreferenceStore();
    }

    public TextHoverDescriptor[] getTextHovers() {
        if (this.fTextHovers == null) {
            String textHoverStrings = this.getPreferenceStore().getString(EditorPreferenceNames.EDITOR_TEXT_HOVER_MODIFIERS);
            this.fTextHovers = this.generateTextHoverDescriptors(textHoverStrings);
        }
        return this.fTextHovers;
    }

    public void resetTextHovers() {
        this.fTextHovers = null;
    }

    public class TextHoverDescriptor {
        private String fDescription;
        private boolean fEnabled;
        private String fId;
        private String fLabel;
        private String fModifierString;

        public TextHoverDescriptor(String id, String label, String desc) {
            this.fId = id;
            this.fLabel = label;
            this.fDescription = desc;
        }

        public TextHoverDescriptor(String id, String label, String desc, boolean enabled, String modifierString) {
            this.fId = id;
            this.fLabel = label;
            this.fDescription = desc;
            this.fEnabled = enabled;
            this.fModifierString = modifierString;
        }

        public String getDescription() {
            return this.fDescription;
        }

        public String getId() {
            return this.fId;
        }

        public String getLabel() {
            return this.fLabel;
        }

        public String getModifierString() {
            return this.fModifierString;
        }

        public boolean isEnabled() {
            return this.fEnabled;
        }

        public void setEnabled(boolean enabled) {
            this.fEnabled = enabled;
        }

        public void setModifierString(String modifierString) {
            this.fModifierString = modifierString;
        }
    }
}

