/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.test.internal.performance.InternalDimensions;
import org.eclipse.test.internal.performance.PerformanceMonitor;
import org.eclipse.test.internal.performance.PerformanceTestPlugin;

class PerformanceMonitorLinux
extends PerformanceMonitor {
    private static long PAGESIZE = 4096L;
    private static long JIFFIES = 10L;
    private static boolean fgHasElapsedTime = true;
    private static long fgStartupTime;

    PerformanceMonitorLinux() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void collectOperatingSystemCounters(Map scalars) {
        PerformanceMonitorLinux performanceMonitorLinux = this;
        synchronized (performanceMonitorLinux) {
            StringTokenizer st = this.readTokens("/proc/self/stat", false);
            if (st != null) {
                st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                long minflt = Long.parseLong(st.nextToken());
                st.nextToken();
                long majflt = Long.parseLong(st.nextToken());
                st.nextToken();
                long utime = Long.parseLong(st.nextToken());
                long stime = Long.parseLong(st.nextToken());
                st.nextToken();
                st.nextToken();
                this.addScalar(scalars, InternalDimensions.KERNEL_TIME, stime * JIFFIES);
                this.addScalar(scalars, InternalDimensions.CPU_TIME, (utime + stime) * JIFFIES);
                this.addScalar(scalars, InternalDimensions.SOFT_PAGE_FAULTS, minflt);
                this.addScalar(scalars, InternalDimensions.HARD_PAGE_FAULTS, majflt);
            }
            if ((st = this.readTokens("/proc/self/statm", false)) != null) {
                st.nextToken();
                int resident = Integer.parseInt(st.nextToken());
                st.nextToken();
                int trs = Integer.parseInt(st.nextToken());
                int drs = Integer.parseInt(st.nextToken());
                int lrs = Integer.parseInt(st.nextToken());
                this.addScalar(scalars, InternalDimensions.WORKING_SET, (long)resident * PAGESIZE);
                this.addScalar(scalars, InternalDimensions.TRS, (long)trs * PAGESIZE);
                this.addScalar(scalars, InternalDimensions.DRS, (long)drs * PAGESIZE);
                this.addScalar(scalars, InternalDimensions.LRS, (long)lrs * PAGESIZE);
            }
            long currentTime = System.currentTimeMillis();
            if (!PerformanceTestPlugin.isOldDB()) {
                this.addScalar(scalars, InternalDimensions.SYSTEM_TIME, currentTime);
            }
            if (fgHasElapsedTime) {
                if (fgStartupTime == 0L) {
                    String t = System.getProperty("eclipse.startTime");
                    if (t != null) {
                        try {
                            fgStartupTime = Long.parseLong(t);
                        }
                        catch (NumberFormatException numberFormatException) {
                            fgHasElapsedTime = false;
                        }
                    } else {
                        fgHasElapsedTime = false;
                    }
                }
                if (fgHasElapsedTime) {
                    this.addScalar(scalars, InternalDimensions.ELAPSED_PROCESS, currentTime - fgStartupTime);
                }
            }
            super.collectOperatingSystemCounters(scalars);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void collectGlobalPerformanceInfo(Map scalars) {
        PerformanceMonitorLinux performanceMonitorLinux = this;
        synchronized (performanceMonitorLinux) {
            StringTokenizer st = this.readOutput("free -b", true);
            if (st != null) {
                st.nextToken();
                long total = Long.parseLong(st.nextToken());
                long used = Long.parseLong(st.nextToken());
                long free = Long.parseLong(st.nextToken());
                st.nextToken();
                long buffers = Long.parseLong(st.nextToken());
                long cache = Long.parseLong(st.nextToken());
                this.addScalar(scalars, InternalDimensions.PHYSICAL_TOTAL, total);
                this.addScalar(scalars, InternalDimensions.USED_LINUX_MEM, used);
                this.addScalar(scalars, InternalDimensions.FREE_LINUX_MEM, free);
                this.addScalar(scalars, InternalDimensions.BUFFERS_LINUX, buffers);
                this.addScalar(scalars, InternalDimensions.SYSTEM_CACHE, cache);
            }
            super.collectGlobalPerformanceInfo(scalars);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StringTokenizer readTokens(String procPath, boolean skipFirst) {
        BufferedReader rdr;
        block11: {
            StringTokenizer stringTokenizer;
            rdr = null;
            try {
                try {
                    rdr = new BufferedReader(new FileReader(procPath));
                    if (skipFirst) {
                        rdr.readLine();
                    }
                    stringTokenizer = new StringTokenizer(rdr.readLine());
                    Object var5_5 = null;
                }
                catch (IOException e) {
                    PerformanceTestPlugin.log(e);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                try {
                    if (rdr == null) throw throwable;
                    rdr.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            if (rdr == null) return stringTokenizer;
            rdr.close();
            return stringTokenizer;
        }
        Object var5_7 = null;
        try {}
        catch (IOException iOException) {
            return null;
        }
        if (rdr == null) return null;
        rdr.close();
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StringTokenizer readOutput(String cmd, boolean skipFirst) {
        BufferedReader rdr;
        block11: {
            StringTokenizer stringTokenizer;
            rdr = null;
            try {
                try {
                    Process process = Runtime.getRuntime().exec(cmd);
                    rdr = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    if (skipFirst) {
                        rdr.readLine();
                    }
                    stringTokenizer = new StringTokenizer(rdr.readLine());
                    Object var5_7 = null;
                }
                catch (IOException e) {
                    PerformanceTestPlugin.log(e);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                try {
                    if (rdr == null) throw throwable;
                    rdr.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            if (rdr == null) return stringTokenizer;
            rdr.close();
            return stringTokenizer;
        }
        Object var5_9 = null;
        try {}
        catch (IOException iOException) {
            return null;
        }
        if (rdr == null) return null;
        rdr.close();
        return null;
    }
}

