/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.eval;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import junit.framework.Assert;
import org.eclipse.test.internal.performance.data.DataPoint;
import org.eclipse.test.internal.performance.data.Dim;
import org.eclipse.test.internal.performance.data.Scalar;

public class StatisticsSession {
    private final DataPoint[] fDataPoints;
    private final Map fStatistics = new HashMap();

    public StatisticsSession(DataPoint[] datapoints) {
        this.fDataPoints = datapoints;
    }

    public double getAverage(Dim dimension) {
        return this.getStats((Dim)dimension).average;
    }

    public long getSum(Dim dimension) {
        return this.getStats((Dim)dimension).sum;
    }

    public long getCount(Dim dimension) {
        return this.getStats((Dim)dimension).count;
    }

    public double getStddev(Dim dimension) {
        return this.getStats((Dim)dimension).stddev;
    }

    private Statistics getStats(Dim dimension) {
        Statistics stats = (Statistics)this.fStatistics.get(dimension);
        if (stats == null) {
            stats = this.computeStats(dimension);
            this.fStatistics.put(dimension, stats);
        }
        return stats;
    }

    private Statistics computeStats(Dim dimension) {
        Statistics stats = new Statistics();
        HashSet<Integer> set = new HashSet<Integer>();
        int j = 0;
        while (j < this.fDataPoints.length) {
            DataPoint dp = this.fDataPoints[j];
            set.add(new Integer(dp.getStep()));
            ++j;
        }
        long[] mags = new long[this.fDataPoints.length];
        switch (set.size()) {
            case 1: {
                int i = 0;
                while (i < this.fDataPoints.length) {
                    Scalar sc = this.fDataPoints[i].getScalar(dimension);
                    if (sc != null) {
                        long magnitude;
                        mags[i] = magnitude = sc.getMagnitude();
                        stats.sum += magnitude;
                        ++stats.count;
                    }
                    ++i;
                }
                if (stats.count <= 0L) break;
                stats.average = stats.sum / stats.count;
                i = 0;
                while (i < this.fDataPoints.length) {
                    stats.stddev += (stats.average - (double)mags[i]) * (stats.average - (double)mags[i]);
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < this.fDataPoints.length - 1) {
                    long magnitude;
                    DataPoint before = this.fDataPoints[i];
                    Assert.assertTrue((String)"wrong order of steps", (before.getStep() == 0 ? 1 : 0) != 0);
                    DataPoint after = this.fDataPoints[i + 1];
                    Assert.assertTrue((String)"wrong order of steps", (after.getStep() == 1 ? 1 : 0) != 0);
                    Scalar delta = this.getDelta(before, after, dimension);
                    mags[i] = magnitude = delta.getMagnitude();
                    stats.sum += magnitude;
                    ++stats.count;
                    i += 2;
                }
                if (stats.count <= 0L) break;
                stats.average = stats.sum / stats.count;
                i = 0;
                while (i < this.fDataPoints.length - 1) {
                    stats.stddev += (stats.average - (double)mags[i]) * (stats.average - (double)mags[i]);
                    i += 2;
                }
                break;
            }
            default: {
                Assert.assertTrue((String)"cannot handle more than two steps", (boolean)false);
            }
        }
        stats.stddev = Math.sqrt(stats.stddev / (double)stats.count);
        return stats;
    }

    private Scalar getDelta(DataPoint before, DataPoint after, Dim dimension) {
        Scalar one = before.getScalar(dimension);
        Assert.assertTrue((String)("reference has no value for dimension " + dimension), (one != null ? 1 : 0) != 0);
        Scalar two = after.getScalar(dimension);
        Assert.assertTrue((String)("reference has no value for dimension " + dimension), (two != null ? 1 : 0) != 0);
        return new Scalar(one.getDimension(), two.getMagnitude() - one.getMagnitude());
    }

    public boolean contains(Dim dimension) {
        if (this.fDataPoints.length > 0) {
            return this.fDataPoints[0].contains(dimension);
        }
        return false;
    }

    static final class Statistics {
        public long count;
        public long sum;
        public double average;
        public double stddev;

        Statistics() {
        }
    }
}

