/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.IClient;
import org.eclipse.wst.server.core.internal.ILaunchableAdapter;
import org.eclipse.wst.server.core.internal.PublishServerJob;
import org.eclipse.wst.server.core.internal.RestartServerJob;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.ServerType;
import org.eclipse.wst.server.core.internal.StartServerJob;
import org.eclipse.wst.server.ui.internal.EclipseUtil;
import org.eclipse.wst.server.ui.internal.LaunchClientJob;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.actions.RunOnServerActionDelegate;
import org.eclipse.wst.server.ui.internal.wizard.ClosableWizardDialog;
import org.eclipse.wst.server.ui.internal.wizard.RunOnServerWizard;
import org.eclipse.wst.server.ui.internal.wizard.SelectClientWizard;
import org.eclipse.wst.server.ui.internal.wizard.SelectTasksWizard;

public class RunOnServerActionDelegate
implements IWorkbenchWindowActionDelegate {
    protected static final String[] launchModes = new String[]{"run", "debug", "profile"};
    protected Object selection;
    protected IWorkbenchWindow window;
    protected static Object globalSelection;
    protected static Map globalLaunchMode;
    protected boolean tasksRun;

    public void dispose() {
        this.window = null;
    }

    public void init(IWorkbenchWindow newWindow) {
        this.window = newWindow;
    }

    public IServer getServer(IModule module, String launchMode, IProgressMonitor monitor) {
        IServer server = ServerCore.getDefaultServer((IModule)module);
        if (server != null && !ServerUIPlugin.isCompatibleWithLaunchMode(server, launchMode)) {
            server = null;
        }
        if (server != null && !ServerUtil.containsModule((IServer)server, (IModule)module, (IProgressMonitor)monitor)) {
            IServerWorkingCopy wc = server.createWorkingCopy();
            try {
                ServerUtil.modifyModules((IServerWorkingCopy)wc, (IModule[])new IModule[]{module}, (IModule[])new IModule[0], (IProgressMonitor)monitor);
                wc.save(false, monitor);
            }
            catch (CoreException ce) {
                Trace.trace(Trace.SEVERE, "Could not add module to server", ce);
                server = null;
            }
        }
        Shell shell = this.window != null ? this.window.getShell() : ServerUIPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getShell();
        if (server == null) {
            RunOnServerWizard wizard = new RunOnServerWizard(module, launchMode);
            ClosableWizardDialog dialog = new ClosableWizardDialog(shell, wizard);
            if (dialog.open() == 1) {
                monitor.setCanceled(true);
                return null;
            }
            try {
                Platform.getJobManager().join((Object)"org.eclipse.wst.server.ui.family", null);
            }
            catch (Exception e) {
                Trace.trace(Trace.WARNING, "Error waiting for job", e);
            }
            server = wizard.getServer();
            boolean preferred = wizard.isPreferredServer();
            this.tasksRun = true;
            if (server != null && preferred) {
                try {
                    ServerCore.setDefaultServer((IModule)module, (IServer)server, (IProgressMonitor)monitor);
                }
                catch (CoreException ce) {
                    String message = Messages.errorCouldNotSavePreference;
                    ErrorDialog.openError((Shell)shell, (String)Messages.errorDialogTitle, (String)message, (IStatus)ce.getStatus());
                }
            }
        }
        try {
            Platform.getJobManager().join((Object)"org.eclipse.wst.server.ui.family", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            Trace.trace(Trace.WARNING, "Error waiting for job", e);
        }
        return server;
    }

    protected void run(IProgressMonitor monitor) {
        final String launchMode2 = this.getLaunchMode();
        final IModuleArtifact moduleArtifact = ServerPlugin.loadModuleArtifact((Object)this.selection);
        Shell shell2 = null;
        if (this.window != null) {
            shell2 = this.window.getShell();
        } else {
            try {
                shell2 = ServerUIPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getShell();
            }
            catch (Exception exception) {}
            if (shell2 == null) {
                shell2 = Display.getDefault().getActiveShell();
            }
        }
        final Shell shell = shell2;
        if (moduleArtifact == null || moduleArtifact.getModule() == null) {
            EclipseUtil.openError(Messages.errorNoModules);
            Trace.trace(Trace.FINEST, "No modules");
            return;
        }
        final IModule module = moduleArtifact.getModule();
        IServer[] servers = ServerCore.getServers();
        boolean found = false;
        if (servers != null) {
            int size = servers.length;
            int i = 0;
            while (i < size && !found) {
                if (ServerUIPlugin.isCompatibleWithLaunchMode(servers[i], launchMode2)) {
                    try {
                        IModule[] parents = servers[i].getRootModules(module, monitor);
                        if (parents != null && parents.length > 0) {
                            found = true;
                        }
                    }
                    catch (Exception exception) {}
                }
                ++i;
            }
        }
        if (!found) {
            IServerType[] serverTypes = ServerCore.getServerTypes();
            boolean found2 = false;
            if (serverTypes != null) {
                int size = serverTypes.length;
                int i = 0;
                while (i < size && !found2) {
                    IServerType type = serverTypes[i];
                    IModuleType[] moduleTypes = type.getRuntimeType().getModuleTypes();
                    if (type.supportsLaunchMode(launchMode2) && ServerUtil.isSupportedModule((IModuleType[])moduleTypes, (IModuleType)module.getModuleType())) {
                        found2 = true;
                    }
                    ++i;
                }
            }
            if (!found2) {
                EclipseUtil.openError(Messages.errorNoServer);
                Trace.trace(Trace.FINEST, "No server for start mode");
                return;
            }
        }
        if (!ServerUIPlugin.saveEditors()) {
            return;
        }
        this.tasksRun = false;
        final IServer server = this.getServer(module, launchMode2, monitor);
        if (monitor.isCanceled()) {
            return;
        }
        Trace.trace(Trace.FINEST, "Server: " + server);
        if (server == null) {
            EclipseUtil.openError(Messages.errorNoServer);
            Trace.trace(Trace.SEVERE, "No server found");
            return;
        }
        if (!ServerUIPlugin.promptIfDirty(shell, server)) {
            return;
        }
        if (!this.tasksRun) {
            SelectTasksWizard wizard = new SelectTasksWizard(server);
            wizard.addPages();
            if (wizard.hasTasks() && wizard.hasOptionalTasks()) {
                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                if (dialog.open() == 1) {
                    return;
                }
            } else {
                wizard.performFinish();
            }
        }
        Thread t = new Thread("Server launch shortcut"){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                String launchMode = launchMode2;
                ILaunchableAdapter launchableAdapter = null;
                Object launchable = null;
                ILaunchableAdapter[] adapters = ServerPlugin.getLaunchableAdapters();
                if (adapters != null) {
                    int size2 = adapters.length;
                    int j = 0;
                    while (j < size2) {
                        ILaunchableAdapter adapter = adapters[j];
                        try {
                            Object launchable2 = adapter.getLaunchable(server, moduleArtifact);
                            Trace.trace(Trace.FINEST, "adapter= " + adapter + ", launchable= " + launchable2);
                            if (launchable2 != null) {
                                launchableAdapter = adapter;
                                launchable = launchable2;
                            }
                        }
                        catch (Exception e) {
                            Trace.trace(Trace.SEVERE, "Error in launchable adapter", e);
                        }
                        ++j;
                    }
                }
                IClient[] clients = new IClient[]{};
                if (launchable != null) {
                    clients = RunOnServerActionDelegate.getClients(server, launchable, launchMode);
                }
                Trace.trace(Trace.FINEST, "Launchable clients: " + clients);
                IClient client = null;
                if (clients == null || clients.length == 0) {
                    EclipseUtil.openError(Messages.errorNoClient);
                    Trace.trace(Trace.SEVERE, "No launchable clients!");
                    return;
                }
                if (clients.length == 1) {
                    client = clients[0];
                } else {
                    SelectClientWizard wizard = new SelectClientWizard(clients);
                    ClosableWizardDialog dialog = new ClosableWizardDialog(shell, wizard);
                    shell.getDisplay().syncExec(new Runnable(this, dialog){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ ClosableWizardDialog val$dialog;
                        {
                            this.this$1 = var1_1;
                            this.val$dialog = closableWizardDialog;
                        }

                        public void run() {
                            this.val$dialog.open();
                        }
                    });
                    client = wizard.getSelectedClient();
                    if (client == null) {
                        return;
                    }
                }
                Trace.trace(Trace.FINEST, "Ready to launch");
                IModule[] modules = new IModule[]{module};
                int state = server.getServerState();
                if (state == 1) {
                    LaunchClientJob clientJob = new LaunchClientJob(server, modules, launchMode, moduleArtifact, launchableAdapter, client);
                    clientJob.schedule();
                    return;
                } else if (state == 2) {
                    int result;
                    boolean restart = false;
                    String mode = server.getMode();
                    if (!"debug".equals(mode) && "debug".equals(launchMode)) {
                        result = RunOnServerActionDelegate.this.openWarningDialog(shell, Messages.dialogModeWarningDebug);
                        if (result == 1) {
                            launchMode = mode;
                        } else {
                            if (result != 0) return;
                            restart = true;
                        }
                    } else if (!"profile".equals(mode) && "profile".equals(launchMode)) {
                        result = RunOnServerActionDelegate.this.openWarningDialog(shell, Messages.dialogModeWarningProfile);
                        if (result == 1) {
                            launchMode = mode;
                        } else {
                            if (result != 0) return;
                            restart = true;
                        }
                    }
                    PublishServerJob publishJob = new PublishServerJob(server, 1, false);
                    LaunchClientJob clientJob = new LaunchClientJob(server, modules, launchMode, moduleArtifact, launchableAdapter, client);
                    publishJob.setNextJob((Job)clientJob);
                    if (restart) {
                        RestartServerJob restartJob = new RestartServerJob(server, launchMode);
                        restartJob.setNextJob((Job)publishJob);
                        restartJob.schedule();
                        return;
                    } else {
                        publishJob.schedule();
                    }
                    return;
                } else {
                    if (state == 3) return;
                    PublishServerJob publishJob = new PublishServerJob(server);
                    StartServerJob startServerJob = new StartServerJob(server, launchMode);
                    LaunchClientJob clientJob = new LaunchClientJob(server, modules, launchMode, moduleArtifact, launchableAdapter, client);
                    if (((ServerType)server.getServerType()).startBeforePublish()) {
                        startServerJob.setNextJob((Job)publishJob);
                        publishJob.setNextJob((Job)clientJob);
                        startServerJob.schedule();
                        return;
                    } else {
                        publishJob.setNextJob((Job)startServerJob);
                        startServerJob.setNextJob((Job)clientJob);
                        publishJob.schedule();
                    }
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    public static IClient[] getClients(IServer server, Object launchable, String launchMode) {
        ArrayList<IClient> list = new ArrayList<IClient>();
        IClient[] clients = ServerPlugin.getClients();
        if (clients != null) {
            int size = clients.length;
            int i = 0;
            while (i < size) {
                Trace.trace(Trace.FINEST, "client= " + clients[i]);
                if (clients[i].supports(server, launchable, launchMode)) {
                    list.add(clients[i]);
                }
                ++i;
            }
        }
        IClient[] clients2 = new IClient[list.size()];
        list.toArray(clients2);
        return clients2;
    }

    protected int openWarningDialog(final Shell shell, final String message) {
        class Int {
            int i;
            final /* synthetic */ RunOnServerActionDelegate this$0;

            Int(RunOnServerActionDelegate runOnServerActionDelegate) {
                this.this$0 = runOnServerActionDelegate;
            }
        }
        final Int in = new Int(this);
        shell.getDisplay().syncExec(new Runnable(){
            {
            }

            public void run() {
                MessageDialog dialog = new MessageDialog(shell, Messages.errorDialogTitle, null, message, 4, new String[]{Messages.dialogModeWarningRestart, Messages.dialogModeWarningContinue, IDialogConstants.CANCEL_LABEL}, 0);
                in.i = dialog.open();
            }
        });
        return in.i;
    }

    public void run(IAction action) {
        Trace.trace(Trace.FINEST, "Running on Server...");
        try {
            this.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Run on Server Error", e);
        }
    }

    protected boolean isEnabled() {
        try {
            Boolean b = (Boolean)globalLaunchMode.get(this.getLaunchMode());
            return b;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected String getLaunchMode() {
        return "run";
    }

    public void selectionChanged(IAction action, ISelection sel) {
        Trace.trace(Trace.FINEST, "> selectionChanged");
        this.selection = null;
        long time = System.currentTimeMillis();
        if (sel == null || sel.isEmpty() || !(sel instanceof IStructuredSelection)) {
            action.setEnabled(false);
            globalSelection = null;
            return;
        }
        IStructuredSelection select = (IStructuredSelection)sel;
        Iterator iterator = select.iterator();
        if (iterator.hasNext()) {
            this.selection = iterator.next();
        }
        if (iterator.hasNext()) {
            action.setEnabled(false);
            this.selection = null;
            globalSelection = null;
            return;
        }
        if (this.selection != globalSelection) {
            Trace.trace(Trace.FINEST, "Selection: " + this.selection);
            if (this.selection != null) {
                Trace.trace(Trace.FINEST, "Selection type: " + this.selection.getClass().getName());
            }
            globalSelection = this.selection;
            globalLaunchMode = new HashMap();
            if (!ServerPlugin.hasModuleArtifact((Object)globalSelection)) {
                action.setEnabled(false);
                return;
            }
            Trace.trace(Trace.FINEST, "checking for module artifact");
            IModuleArtifact moduleArtifact = ServerPlugin.getModuleArtifact((Object)globalSelection);
            IModule module = null;
            if (moduleArtifact != null) {
                module = moduleArtifact.getModule();
            }
            Trace.trace(Trace.FINEST, "moduleArtifact= " + moduleArtifact + ", module= " + module);
            if (module != null) {
                this.findGlobalLaunchModes(module);
            } else {
                globalLaunchMode.put("run", new Boolean(true));
                globalLaunchMode.put("debug", new Boolean(true));
                globalLaunchMode.put("profile", new Boolean(true));
            }
        }
        action.setEnabled(this.isEnabled());
        Trace.trace(Trace.FINEST, "< selectionChanged " + (System.currentTimeMillis() - time));
    }

    protected void findGlobalLaunchModes(IModule module) {
        IServerType[] serverTypes = ServerCore.getServerTypes();
        if (serverTypes != null) {
            int size = serverTypes.length;
            int i = 0;
            while (i < size) {
                IServerType type = serverTypes[i];
                if (this.isValidServerType(type, module)) {
                    int b = 0;
                    while (b < launchModes.length) {
                        if (type.supportsLaunchMode(launchModes[b])) {
                            globalLaunchMode.put(launchModes[b], new Boolean(true));
                        }
                        b = (byte)(b + 1);
                    }
                }
                ++i;
            }
        }
    }

    protected boolean isValidServerType(IServerType type, IModule module) {
        try {
            IRuntimeType runtimeType = type.getRuntimeType();
            ServerUtil.isSupportedModule((IModuleType[])runtimeType.getModuleTypes(), (IModuleType)module.getModuleType());
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    protected boolean supportsLaunchMode(IServer server, String launchMode) {
        return server.getServerType().supportsLaunchMode(launchMode);
    }
}

