/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaExceptionBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.refactoring.JavaBreakpointTypeChange;
import org.eclipse.jdt.internal.debug.core.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.ltk.core.refactoring.Change;

public class JavaExceptionBreakpointTypeChange
extends JavaBreakpointTypeChange {
    private boolean fIsCaught;
    private boolean fIsUncaught;
    private boolean fIsChecked;

    public JavaExceptionBreakpointTypeChange(IJavaExceptionBreakpoint classPrepareBreakpoint, Object changedElement, Object argument, int changeType) throws CoreException {
        super((IJavaBreakpoint)classPrepareBreakpoint, changedElement, argument, changeType);
        this.fIsCaught = classPrepareBreakpoint.isCaught();
        this.fIsUncaught = classPrepareBreakpoint.isUncaught();
        this.fIsChecked = classPrepareBreakpoint.isChecked();
    }

    public String getErrorMessageNoMoreExists() {
        return MessageFormat.format(RefactoringMessages.JavaExceptionBreakpointTypeChange_0, this.getDeclaringType().getElementName());
    }

    public String getName() {
        return MessageFormat.format(RefactoringMessages.JavaExceptionBreakpointTypeChange_1, this.getDeclaringType().getElementName());
    }

    public Change performChange(IType newType, Object undoChangedElement, Object undoArgument, int changeType) throws CoreException {
        Map attributes = this.getAttributes();
        BreakpointUtils.addJavaBreakpointAttributes(attributes, (IJavaElement)newType);
        IJavaExceptionBreakpoint newExceptionBreakpoint = JDIDebugModel.createExceptionBreakpoint((IResource)BreakpointUtils.getBreakpointResource((IMember)newType), (String)newType.getFullyQualifiedName(), (boolean)this.fIsCaught, (boolean)this.fIsUncaught, (boolean)this.fIsChecked, (boolean)true, (Map)attributes);
        this.getBreakpoint().delete();
        return new JavaExceptionBreakpointTypeChange(newExceptionBreakpoint, undoChangedElement, undoArgument, changeType);
    }
}

