/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.ExpressionInputDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class StringValueInputDialog
extends ExpressionInputDialog {
    private TextViewer fTextViewer;
    private Button fTextButton;
    private Button fEvaluationButton;
    private Button fWrapText;
    private Group fTextGroup;
    private boolean fUseLiteralValue = true;
    private static final String USE_EVALUATION = "USE_EVALUATION";
    private static final String WRAP_TEXT = "WRAP_TEXT";

    protected StringValueInputDialog(Shell parentShell, IJavaVariable variable) {
        super(parentShell, variable);
    }

    protected void createInputArea(Composite parent) {
        super.createInputArea(parent);
        this.createRadioButtons(parent);
        Dialog.applyDialogFont((Control)parent);
    }

    protected void populateInputArea() {
        boolean useEvaluation = false;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            useEvaluation = settings.getBoolean(USE_EVALUATION);
        }
        if (useEvaluation) {
            this.createSourceViewer();
            this.fUseLiteralValue = false;
            this.fEvaluationButton.setSelection(true);
        } else {
            this.createTextViewer();
            this.fTextButton.setSelection(true);
        }
    }

    private void createTextViewer() {
        this.fTextGroup = new Group(this.fInputArea, 0);
        this.fTextGroup.setLayout((Layout)new GridLayout());
        this.fTextGroup.setLayoutData((Object)new GridData(1808));
        this.fTextGroup.setText(ActionMessages.StringValueInputDialog_0);
        Group parent = this.fTextGroup;
        this.fTextViewer = new TextViewer((Composite)parent, 2818);
        this.fTextViewer.setDocument((IDocument)new Document());
        GridData gridData = new GridData(1808);
        gridData.widthHint = 300;
        gridData.heightHint = 150;
        this.fTextViewer.getTextWidget().setLayoutData((Object)gridData);
        try {
            String valueString = this.fVariable.getValue().getValueString();
            this.fTextViewer.getDocument().set(valueString);
            this.fTextViewer.setSelectedRange(0, valueString.length());
        }
        catch (DebugException e) {
            JDIDebugUIPlugin.log(e);
        }
        this.fTextViewer.getControl().setFocus();
        this.fWrapText = new Button((Composite)parent, 32);
        this.fWrapText.setText(ActionMessages.StringValueInputDialog_4);
        boolean wrap = true;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            wrap = settings.getBoolean(WRAP_TEXT);
        }
        this.fWrapText.setSelection(wrap);
        this.updateWordWrap();
        this.fWrapText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringValueInputDialog.this.updateWordWrap();
            }
        });
        Dialog.applyDialogFont((Control)this.fInputArea);
    }

    private void updateWordWrap() {
        this.fTextViewer.getTextWidget().setWordWrap(this.fWrapText.getSelection());
    }

    protected void createRadioButtons(Composite parent) {
        this.fTextButton = new Button(parent, 16);
        this.fTextButton.setText(ActionMessages.StringValueInputDialog_1);
        this.fTextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringValueInputDialog.this.handleRadioSelectionChanged();
            }
        });
        this.fEvaluationButton = new Button(parent, 16);
        this.fEvaluationButton.setText(ActionMessages.StringValueInputDialog_2);
    }

    private void handleRadioSelectionChanged() {
        this.fUseLiteralValue = this.fTextButton.getSelection();
        if (this.fUseLiteralValue) {
            this.disposeSourceViewer();
            this.createTextViewer();
        } else {
            this.disposeTextViewer();
            this.createSourceViewer();
        }
        this.fInputArea.layout(true, true);
    }

    protected void disposeTextViewer() {
        if (this.fTextGroup != null) {
            this.fTextGroup.dispose();
            this.fTextGroup = null;
        }
        if (this.fTextViewer != null) {
            StyledText textWidget = this.fTextViewer.getTextWidget();
            if (textWidget != null) {
                textWidget.dispose();
            }
            this.fTextViewer = null;
        }
        if (this.fWrapText != null) {
            this.fWrapText.dispose();
            this.fWrapText = null;
        }
    }

    protected void refreshValidState() {
        boolean valid;
        if (this.fSourceViewer != null) {
            super.refreshValidState();
            return;
        }
        String errorMessage = null;
        String text = this.getText();
        boolean bl = valid = text != null && text.trim().length() > 0;
        if (!valid) {
            errorMessage = ActionMessages.StringValueInputDialog_3;
        }
        this.setErrorMessage(errorMessage);
    }

    protected void okPressed() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings == null) {
            settings = JDIDebugUIPlugin.getDefault().getDialogSettings().addNewSection(this.getDialogSettingsSectionName());
        }
        settings.put(USE_EVALUATION, this.fEvaluationButton.getSelection());
        if (this.fWrapText != null) {
            settings.put(WRAP_TEXT, this.fWrapText.getSelection());
        }
        super.okPressed();
    }

    public boolean isUseLiteralValue() {
        return this.fUseLiteralValue;
    }

    protected String getText() {
        if (this.fTextButton.getSelection()) {
            return this.fTextViewer.getDocument().get();
        }
        return super.getText();
    }

    protected void dispose() {
        if (this.fTextButton.getSelection()) {
            this.disposeTextViewer();
        } else {
            super.dispose();
        }
    }

    protected IDialogSettings getDialogSettings() {
        return JDIDebugUIPlugin.getDefault().getDialogSettings().getSection(this.getDialogSettingsSectionName());
    }

    protected String getDialogSettingsSectionName() {
        return "STRING_VALUE_INPUT_DIALOG";
    }
}

