/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.breakpoints;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.debug.core.IJavaExceptionBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.breakpoints.BreakpointMessages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.TypeSelectionDialog2;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class AddExceptionDialog
extends TypeSelectionDialog2 {
    private Button fCaughtButton;
    private Button fUncaughtButton;
    private IJavaExceptionBreakpoint[] fExisting;
    private Point fLocation;
    private Point fSize;
    public static final int CHECKED_EXCEPTION = 0;
    public static final int UNCHECKED_EXCEPTION = 1;
    public static final int NO_EXCEPTION = -1;
    private static final String DIALOG_SETTINGS = "AddExceptionDialog";
    private static final String SETTING_CAUGHT_CHECKED = "caughtChecked";
    private static final String SETTING_UNCAUGHT_CHECKED = "uncaughtChecked";

    public AddExceptionDialog(Shell parent, IRunnableContext context) {
        super(parent, false, context, null, 5);
        this.setFilter("*Exception*", 1);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, IJavaDebugHelpContextIds.ADD_EXCEPTION_DIALOG);
    }

    public Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        this.createExceptionArea(contents);
        return contents;
    }

    private void createExceptionArea(Composite contents) {
        IDialogSettings section = this.getDialogSettings();
        boolean c = section.getBoolean(SETTING_CAUGHT_CHECKED);
        boolean u = section.getBoolean(SETTING_UNCAUGHT_CHECKED);
        this.fCaughtButton = new Button(contents, 32);
        this.fCaughtButton.setLayoutData((Object)new GridData(768));
        this.fCaughtButton.setFont(contents.getFont());
        this.fCaughtButton.setText(BreakpointMessages.AddExceptionDialog_15);
        this.fCaughtButton.setSelection(c);
        this.fUncaughtButton = new Button(contents, 32);
        this.fUncaughtButton.setLayoutData((Object)new GridData(768));
        this.fUncaughtButton.setFont(contents.getFont());
        this.fUncaughtButton.setText(BreakpointMessages.AddExceptionDialog_16);
        this.fUncaughtButton.setSelection(u);
    }

    protected boolean createBreakpoint() {
        TypeInfo[] selection = this.getSelectedTypes();
        if (selection.length != 1) {
            return false;
        }
        TypeInfo typeRef = selection[0];
        IType type = null;
        try {
            type = typeRef.resolveType(SearchEngine.createWorkspaceScope());
        }
        catch (JavaModelException e) {
            this.updateStatus(e.getStatus());
            return false;
        }
        if (type == null) {
            this.updateStatus((IStatus)new StatusInfo(4, BreakpointMessages.AddExceptionDialog_17));
            return false;
        }
        final int exType = AddExceptionDialog.getExceptionType(type);
        if (exType == -1) {
            this.updateStatus((IStatus)new StatusInfo(4, BreakpointMessages.AddExceptionDialog_17));
            return false;
        }
        final HashMap attributes = new HashMap(10);
        BreakpointUtils.addJavaBreakpointAttributes(attributes, (IJavaElement)type);
        final IType finalType = type;
        final boolean caught = this.fCaughtButton.getSelection();
        final boolean uncaught = this.fUncaughtButton.getSelection();
        new Job(BreakpointMessages.AddExceptionDialog_0){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IJavaExceptionBreakpoint breakpoint = JDIDebugModel.createExceptionBreakpoint((IResource)BreakpointUtils.getBreakpointResource((IMember)finalType), (String)finalType.getFullyQualifiedName(), (boolean)caught, (boolean)uncaught, (exType == 0 ? 1 : 0) != 0, (boolean)true, (Map)attributes);
                    ArrayList<IJavaExceptionBreakpoint> list = new ArrayList<IJavaExceptionBreakpoint>(1);
                    list.add(breakpoint);
                    Runnable r = new Runnable(this, list){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ List val$list;
                        {
                            this.this$1 = var1_1;
                            this.val$list = list;
                        }

                        public void run() {
                            Viewer viewer;
                            IViewPart part = JDIDebugUIPlugin.getActivePage().findView("org.eclipse.debug.ui.BreakpointView");
                            if (part instanceof IDebugView && (viewer = ((IDebugView)part).getViewer()) instanceof StructuredViewer) {
                                StructuredViewer sv = (StructuredViewer)viewer;
                                sv.setSelection((ISelection)new StructuredSelection(this.val$list), true);
                            }
                        }
                    };
                    JDIDebugUIPlugin.getStandardDisplay().asyncExec(r);
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    AddExceptionDialog.this.updateStatus(e.getStatus());
                    return Status.CANCEL_STATUS;
                }
            }
        }.schedule();
        return true;
    }

    protected boolean validateBreakpoint() {
        TypeInfo[] selection = this.getSelectedTypes();
        if (selection.length != 1) {
            return false;
        }
        TypeInfo typeRef = selection[0];
        if (typeRef == null) {
            return false;
        }
        IType type = null;
        try {
            type = typeRef.resolveType(SearchEngine.createWorkspaceScope());
        }
        catch (JavaModelException e) {
            this.updateStatus(e.getStatus());
            return false;
        }
        if (type == null) {
            this.updateStatus((IStatus)new StatusInfo(4, BreakpointMessages.AddExceptionDialog_17));
            return false;
        }
        int exType = AddExceptionDialog.getExceptionType(type);
        if (exType == -1) {
            this.updateStatus((IStatus)new StatusInfo(4, BreakpointMessages.AddExceptionDialog_17));
            return false;
        }
        String name = type.getFullyQualifiedName();
        IJavaExceptionBreakpoint[] breakpoints = this.getExistingBreakpoints();
        int i = 0;
        while (i < breakpoints.length) {
            IJavaExceptionBreakpoint breakpoint = breakpoints[i];
            try {
                if (breakpoint.getTypeName().equals(name)) {
                    this.updateStatus((IStatus)new StatusInfo(1, BreakpointMessages.AddExceptionDialog_21));
                    return false;
                }
            }
            catch (CoreException e) {
                this.updateStatus(e.getStatus());
                return false;
            }
            ++i;
        }
        this.updateStatus((IStatus)new StatusInfo(0, null));
        return true;
    }

    public static int getExceptionType(final IType type) {
        final int[] exceptionType = new int[]{-1};
        BusyIndicatorRunnableContext context = new BusyIndicatorRunnableContext();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) {
                try {
                    ITypeHierarchy hierarchy = type.newSupertypeHierarchy(pm);
                    IType curr = type;
                    while (curr != null) {
                        String name = JavaModelUtil.getFullyQualifiedName((IType)curr);
                        if ("java.lang.Throwable".equals(name)) {
                            exceptionType[0] = 0;
                            return;
                        }
                        if ("java.lang.RuntimeException".equals(name) || "java.lang.Error".equals(name)) {
                            exceptionType[0] = 1;
                            return;
                        }
                        curr = hierarchy.getSuperclass(curr);
                    }
                }
                catch (JavaModelException e) {
                    JDIDebugUIPlugin.log(e);
                }
            }
        };
        try {
            context.run(false, false, runnable);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            JDIDebugUIPlugin.log(e);
        }
        return exceptionType[0];
    }

    protected void okPressed() {
        if (this.createBreakpoint()) {
            super.okPressed();
        }
    }

    protected void updateOkState() {
        this.getButton(0).setEnabled(this.validateBreakpoint());
    }

    private void writeSettings() {
        IDialogSettings s = this.getDialogSettings();
        Point location = this.getShell().getLocation();
        s.put("x", location.x);
        s.put("y", location.y);
        Point size = this.getShell().getSize();
        s.put("width", size.x);
        s.put("height", size.y);
        s.put(SETTING_CAUGHT_CHECKED, this.fCaughtButton.getSelection());
        s.put(SETTING_UNCAUGHT_CHECKED, this.fUncaughtButton.getSelection());
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings allSetttings = JDIDebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = allSetttings.getSection(DIALOG_SETTINGS);
        if (section == null) {
            section = allSetttings.addNewSection(DIALOG_SETTINGS);
            section.put(SETTING_CAUGHT_CHECKED, true);
            section.put(SETTING_UNCAUGHT_CHECKED, true);
        }
        return section;
    }

    private void readSettings() {
        IDialogSettings s = this.getDialogSettings();
        try {
            int x = s.getInt("x");
            int y = s.getInt("y");
            this.fLocation = new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            this.fLocation = null;
        }
        try {
            int width = s.getInt("width");
            int height = s.getInt("height");
            this.fSize = new Point(width, height);
        }
        catch (NumberFormatException numberFormatException) {
            this.fSize = new Point(420, 460);
        }
    }

    protected Point getInitialSize() {
        Point result = super.getInitialSize();
        if (this.fSize != null) {
            result.x = Math.max(result.x, this.fSize.x);
            result.y = Math.max(result.y, this.fSize.y);
            Rectangle display = this.getShell().getDisplay().getClientArea();
            result.x = Math.min(result.x, display.width);
            result.y = Math.min(result.y, display.height);
        }
        return result;
    }

    protected Point getInitialLocation(Point initialSize) {
        Point result = super.getInitialLocation(initialSize);
        if (this.fLocation != null) {
            int ye;
            result.x = this.fLocation.x;
            result.y = this.fLocation.y;
            Rectangle display = this.getShell().getDisplay().getClientArea();
            int xe = result.x + initialSize.x;
            if (xe > display.width) {
                result.x -= xe - display.width;
            }
            if ((ye = result.y + initialSize.y) > display.height) {
                result.y -= ye - display.height;
            }
        }
        return result;
    }

    public boolean close() {
        this.writeSettings();
        return super.close();
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.readSettings();
        return control;
    }

    protected void computeResult() {
    }

    protected IJavaExceptionBreakpoint[] getExistingBreakpoints() {
        if (this.fExisting == null) {
            ArrayList<IBreakpoint> list = new ArrayList<IBreakpoint>();
            IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(JDIDebugModel.getPluginIdentifier());
            int i = 0;
            while (i < breakpoints.length) {
                IBreakpoint breakpoint = breakpoints[i];
                if (breakpoint instanceof IJavaExceptionBreakpoint) {
                    list.add(breakpoint);
                }
                ++i;
            }
            this.fExisting = list.toArray(new IJavaExceptionBreakpoint[list.size()]);
        }
        return this.fExisting;
    }

    protected void handleDefaultSelected(TypeInfo[] selection) {
        if (this.getButton(0).isEnabled()) {
            super.handleDefaultSelected(selection);
        }
    }

    protected void handleWidgetSelected(TypeInfo[] selection) {
        this.updateStatus((IStatus)new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 0, "", null));
        super.handleWidgetSelected(selection);
    }
}

