/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.archive.operations;

import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jst.j2ee.application.internal.operations.AddComponentToEnterpriseApplicationDataModelProvider;
import org.eclipse.jst.j2ee.application.internal.operations.AddWebComponentToEARDataModelProvider;
import org.eclipse.jst.j2ee.application.internal.operations.J2EEComponentCreationDataModelProvider;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebComponentCreationFacetOperation;
import org.eclipse.jst.j2ee.web.datamodel.properties.IWebComponentCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class WebComponentCreationDataModelProvider
extends J2EEComponentCreationDataModelProvider
implements IWebComponentCreationDataModelProperties {
    public IDataModelOperation getDefaultOperation() {
        return new WebComponentCreationFacetOperation(this.model);
    }

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("IAnnotationsDataModel.useAnnotations");
        propertyNames.add("IAddWebComponentToEnterpriseApplicationDataModelProperties.CONTEXT_ROOT");
        propertyNames.add("IWebComponentCreationDataModelProperties.WEBCONTENT_FOLDER");
        return propertyNames;
    }

    protected Integer getDefaultComponentVersion() {
        int highestJ2EEPref = J2EEPlugin.getDefault().getJ2EEPreferences().getHighestJ2EEVersionID();
        switch (highestJ2EEPref) {
            case 14: {
                return new Integer(24);
            }
            case 13: {
                return new Integer(23);
            }
            case 12: {
                return new Integer(22);
            }
        }
        return new Integer(24);
    }

    public AddComponentToEnterpriseApplicationDataModelProvider createAddComponentToEAR() {
        return new AddWebComponentToEARDataModelProvider();
    }

    public void init() {
        super.init();
        this.updateOutputLocation();
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean retVal = super.propertySet(propertyName, propertyValue);
        if (propertyName.equals("IAnnotationsDataModel.useAnnotations")) {
            this.model.notifyPropertyChange("IComponentCreationDataModelProperties.COMPONENT_VERSION", 3);
        } else if (propertyName.equals("IAddWebComponentToEnterpriseApplicationDataModelProperties.CONTEXT_ROOT")) {
            this.getAddComponentToEARDataModel().setProperty("IAddWebComponentToEnterpriseApplicationDataModelProperties.CONTEXT_ROOT", propertyValue);
        } else if (propertyName.equals("IComponentCreationDataModelProperties.COMPONENT_NAME")) {
            if (!this.isPropertySet("IAddWebComponentToEnterpriseApplicationDataModelProperties.CONTEXT_ROOT")) {
                this.model.notifyPropertyChange("IAddWebComponentToEnterpriseApplicationDataModelProperties.CONTEXT_ROOT", 1);
                this.getAddComponentToEARDataModel().setProperty("IAddWebComponentToEnterpriseApplicationDataModelProperties.CONTEXT_ROOT", propertyValue);
                this.getAddComponentToEARDataModel().notifyPropertyChange("IAddWebComponentToEnterpriseApplicationDataModelProperties.CONTEXT_ROOT", 2);
            }
        } else if (propertyName.equals("IWebComponentCreationDataModelProperties.WEBCONTENT_FOLDER")) {
            this.model.setProperty("IJ2EEComponentCreationDataModelProperties.DD_FOLDER", (Object)("/" + propertyValue + '/' + "WEB-INF"));
            this.model.setProperty("IJavaComponentCreationDataModelProperties.MANIFEST_FOLDER", (Object)("/" + propertyValue + '/' + "META-INF"));
        }
        return retVal;
    }

    private void updateOutputLocation() {
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IAddWebComponentToEnterpriseApplicationDataModelProperties.CONTEXT_ROOT")) {
            return this.getProperty("IComponentCreationDataModelProperties.COMPONENT_NAME");
        }
        if (propertyName.equals("IJ2EEComponentCreationDataModelProperties.DD_FOLDER")) {
            return "/WebContent/WEB-INF";
        }
        if (propertyName.equals("IJavaComponentCreationDataModelProperties.JAVASOURCE_FOLDER")) {
            return "src";
        }
        if (propertyName.equals("IJavaComponentCreationDataModelProperties.MANIFEST_FOLDER")) {
            return "/WebContent/META-INF";
        }
        if (propertyName.equals("IWebComponentCreationDataModelProperties.WEBCONTENT_FOLDER")) {
            return "WebContent";
        }
        if (propertyName.equals("IJ2EEComponentCreationDataModelProperties.MODULE_URI")) {
            return String.valueOf(this.getProject().getName()) + ".war";
        }
        return super.getDefaultProperty(propertyName);
    }

    public DataModelPropertyDescriptor getPropertyDescriptor(String propertyName) {
        if (propertyName.equals("IComponentCreationDataModelProperties.COMPONENT_VERSION")) {
            Integer propertyValue = (Integer)this.getProperty(propertyName);
            String description = null;
            switch (propertyValue) {
                case 22: {
                    description = "2.2";
                    break;
                }
                case 23: {
                    description = "2.3";
                    break;
                }
                default: {
                    description = "2.4";
                }
            }
            return new DataModelPropertyDescriptor((Object)propertyValue, description);
        }
        return super.getPropertyDescriptor(propertyName);
    }

    protected DataModelPropertyDescriptor[] getValidComponentVersionDescriptors() {
        int highestJ2EEPref = J2EEPlugin.getDefault().getJ2EEPreferences().getHighestJ2EEVersionID();
        DataModelPropertyDescriptor[] descriptors = null;
        switch (highestJ2EEPref) {
            case 12: {
                descriptors = new DataModelPropertyDescriptor[]{new DataModelPropertyDescriptor((Object)new Integer(22), "2.2")};
                break;
            }
            case 13: {
                descriptors = new DataModelPropertyDescriptor[]{new DataModelPropertyDescriptor((Object)new Integer(22), "2.2"), new DataModelPropertyDescriptor((Object)new Integer(23), "2.3")};
                break;
            }
            default: {
                descriptors = new DataModelPropertyDescriptor[]{new DataModelPropertyDescriptor((Object)new Integer(22), "2.2"), new DataModelPropertyDescriptor((Object)new Integer(23), "2.3"), new DataModelPropertyDescriptor((Object)new Integer(24), "2.4")};
            }
        }
        return descriptors;
    }

    protected int convertModuleVersionToJ2EEVersion(int moduleVersion) {
        switch (moduleVersion) {
            case 22: {
                return 12;
            }
            case 23: {
                return 13;
            }
            case 24: {
                return 14;
            }
        }
        return -1;
    }

    protected Integer convertJ2EEVersionToModuleVersion(Integer j2eeVersion) {
        switch (j2eeVersion) {
            case 12: {
                return new Integer(22);
            }
            case 13: {
                return new Integer(23);
            }
            case 14: {
                return new Integer(24);
            }
        }
        return super.convertJ2EEVersionToModuleVersion(j2eeVersion);
    }

    protected EClass getComponentType() {
        return CommonarchivePackage.eINSTANCE.getWARFile();
    }

    protected String getComponentExtension() {
        return ".war";
    }

    public boolean isPropertyEnabled(String propertyName) {
        if ("IAnnotationsDataModel.useAnnotations".equals(propertyName)) {
            return this.getJ2EEVersion() >= 13;
        }
        return super.isPropertyEnabled(propertyName);
    }

    public IStatus validate(String propertyName) {
        if (propertyName.equals("IAddWebComponentToEnterpriseApplicationDataModelProperties.CONTEXT_ROOT")) {
            if (this.getBooleanProperty("IJ2EEComponentCreationDataModelProperties.ADD_TO_EAR")) {
                return this.getAddComponentToEARDataModel().validateProperty("IAddWebComponentToEnterpriseApplicationDataModelProperties.CONTEXT_ROOT");
            }
            return OK_STATUS;
        }
        if (propertyName.equals("IWebComponentCreationDataModelProperties.WEBCONTENT_FOLDER")) {
            IStatus status = OK_STATUS;
            String webFolderName = this.model.getStringProperty("IWebComponentCreationDataModelProperties.WEBCONTENT_FOLDER");
            if (webFolderName == null || webFolderName.length() == 0) {
                String errorMessage = WTPCommonPlugin.getResourceString((String)"40");
                status = WTPCommonPlugin.createErrorStatus((String)errorMessage);
                return status;
            }
        }
        return super.validate(propertyName);
    }

    public void propertyChanged(DataModelEvent event) {
        super.propertyChanged(event);
        if (event.getDataModel() == this.getAddComponentToEARDataModel() && event.getPropertyName().equals("IAddWebComponentToEnterpriseApplicationDataModelProperties.CONTEXT_ROOT") && event.getDataModel().isPropertySet("IAddWebComponentToEnterpriseApplicationDataModelProperties.CONTEXT_ROOT")) {
            this.setProperty("IAddWebComponentToEnterpriseApplicationDataModelProperties.CONTEXT_ROOT", event.getProperty());
        }
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        return super.getValidPropertyDescriptors(propertyName);
    }

    protected String getJ2EEProjectType() {
        return "jst.web";
    }
}

