/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.data.internal.core.load;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import org.eclipse.wst.rdb.data.internal.core.load.DataFormatException;

public class DataFileTokenizer {
    protected String filePath;
    protected String delims;
    protected static final String ENDL = System.getProperty("line.separator");
    protected BufferedReader reader;
    protected StringTokenizer st = null;
    protected String nextToken = null;

    public DataFileTokenizer(String filePath, String delims) {
        this.filePath = filePath;
        this.delims = delims;
    }

    public void open() throws IOException {
        this.reader = new BufferedReader(new FileReader(this.filePath));
        String line = this.reader.readLine();
        if (line != null) {
            this.st = new StringTokenizer(line, this.delims, true);
        }
    }

    public String peek() throws IOException {
        if (this.nextToken == null) {
            this.nextToken = this.nextToken();
        }
        return this.nextToken;
    }

    public void consume(String s) throws Exception {
        String token = this.nextToken();
        if (!token.equals(s)) {
            throw new DataFormatException("Unexpected token (found " + token + ", expected " + s + ")");
        }
    }

    public String nextToken() throws IOException {
        if (this.nextToken != null) {
            String s = this.nextToken;
            this.nextToken = null;
            return s;
        }
        if (this.st == null || !this.st.hasMoreTokens()) {
            String line = this.reader.readLine();
            if (line == null) {
                return null;
            }
            this.st = new StringTokenizer(line, this.delims, true);
            return ENDL;
        }
        return this.st.nextToken();
    }

    public void close() throws IOException {
        this.reader.close();
    }
}

