/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.command;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class OpenJavaEditorCommand
extends AbstractDataModelOperation {
    private List classNames;
    private IProject project;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        OpenJavaEditorJob job = new OpenJavaEditorJob(this.classNames, this.project);
        job.setPriority(30);
        job.schedule();
        return Status.OK_STATUS;
    }

    public void setClassNames(List classNames) {
        this.classNames = classNames;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    private class OpenJavaEditorJob
    extends UIJob {
        private List classNames;
        private IProject project;

        public OpenJavaEditorJob(List classNames, IProject project) {
            super("org.eclipse.jst.ws.internal.consumption.ui.command.OpenJavaEditorJob");
            this.classNames = classNames;
            this.project = project;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (this.project != null && this.classNames != null) {
                IJavaProject javaProject = JavaCore.create((IProject)this.project);
                Iterator it = this.classNames.iterator();
                while (it.hasNext()) {
                    String className = (String)it.next();
                    try {
                        IType type = javaProject.findType(className);
                        JavaUI.openInEditor((IJavaElement)type);
                    }
                    catch (Throwable t) {
                        return new Status(4, "org.eclipse.jst.ws.consumption.ui", 0, NLS.bind((String)ConsumptionUIMessages.MSG_ERROR_UNABLE_TO_OPEN_JAVA_EDITOR, (Object[])new String[]{className, this.project.getName()}), t);
                    }
                }
                return new Status(0, "org.eclipse.jst.ws.consumption.ui", 0, "", null);
            }
            return new Status(4, "org.eclipse.jst.ws.consumption.ui", 0, NLS.bind((String)ConsumptionUIMessages.MSG_ERROR_UNABLE_TO_OPEN_JAVA_EDITOR, (Object[])new String[]{this.classNames != null ? this.classNames.toString() : "", this.project != null ? this.project.getName() : ""}), null);
        }
    }
}

