/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.sourcelookup;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.internal.ui.InstructionPointerManager;
import org.eclipse.debug.internal.ui.sourcelookup.CommonSourceNotFoundEditorInput;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupResult;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.internal.ui.views.launch.DecorationManager;
import org.eclipse.debug.internal.ui.views.launch.SourceNotFoundEditorInput;
import org.eclipse.debug.internal.ui.views.launch.StandardDecoration;
import org.eclipse.debug.ui.IDebugEditorPresentation;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.ISourcePresentation;
import org.eclipse.debug.ui.sourcelookup.ISourceLookupResult;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class SourceLookupFacility
implements IPageListener,
IPartListener2,
IPropertyChangeListener {
    private static SourceLookupFacility fgDefault;
    private Map fEditorsByPage;
    private boolean fReuseEditor = DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IDebugUIConstants.PREF_REUSE_EDITOR);
    static /* synthetic */ Class class$0;

    public static SourceLookupFacility getDefault() {
        if (fgDefault == null) {
            fgDefault = new SourceLookupFacility();
        }
        return fgDefault;
    }

    public static void shutdown() {
        if (fgDefault != null) {
            fgDefault.dispose();
        }
    }

    private SourceLookupFacility() {
        this.fEditorsByPage = new HashMap();
        DebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public SourceLookupResult lookup(Object artifact, ISourceLocator locator) {
        SourceLookupResult result = new SourceLookupResult(artifact, null, null, null);
        IDebugElement debugElement = null;
        if (artifact instanceof IDebugElement) {
            debugElement = (IDebugElement)artifact;
        }
        if (locator == null) {
            ILaunch launch = null;
            if (debugElement != null) {
                launch = debugElement.getLaunch();
            }
            if (launch != null) {
                locator = launch.getSourceLocator();
            }
        }
        if (locator != null) {
            String editorId = null;
            PlatformObject editorInput = null;
            Object sourceElement = null;
            if (locator instanceof ISourceLookupDirector) {
                ISourceLookupDirector director = (ISourceLookupDirector)locator;
                sourceElement = director.getSourceElement(artifact);
            } else if (artifact instanceof IStackFrame) {
                sourceElement = locator.getSourceElement((IStackFrame)artifact);
            }
            if (sourceElement == null) {
                if (locator instanceof AbstractSourceLookupDirector) {
                    editorInput = new CommonSourceNotFoundEditorInput(artifact);
                    editorId = "org.eclipse.debug.ui.sourcelookup.CommonSourceNotFoundEditor";
                } else if (artifact instanceof IStackFrame) {
                    IStackFrame frame = (IStackFrame)artifact;
                    editorInput = new SourceNotFoundEditorInput(frame);
                    editorId = "org.eclipse.debug.ui.NoSourceFoundEditor";
                }
            } else {
                ISourcePresentation presentation = null;
                if (locator instanceof ISourcePresentation) {
                    presentation = (ISourcePresentation)locator;
                } else if (debugElement != null) {
                    presentation = this.getPresentation(debugElement.getModelIdentifier());
                }
                if (presentation != null) {
                    editorInput = presentation.getEditorInput(sourceElement);
                }
                if (editorInput != null) {
                    editorId = presentation.getEditorId((IEditorInput)editorInput, sourceElement);
                }
            }
            result.setEditorInput((IEditorInput)editorInput);
            result.setEditorId(editorId);
            result.setSourceElement(sourceElement);
        }
        return result;
    }

    protected IDebugModelPresentation getPresentation(String id) {
        return ((DelegatingModelPresentation)DebugUIPlugin.getModelPresentation()).getPresentation(id);
    }

    protected IDebugEditorPresentation getEditorPresentation() {
        return (DelegatingModelPresentation)DebugUIPlugin.getModelPresentation();
    }

    public void display(ISourceLookupResult result, IWorkbenchPage page) {
        IEditorPart editor = this.openEditor(result, page);
        if (editor == null) {
            return;
        }
        IStackFrame frame = null;
        if (result.getArtifact() instanceof IStackFrame) {
            frame = (IStackFrame)result.getArtifact();
        }
        if (frame != null) {
            IDebugEditorPresentation editorPresentation = this.getEditorPresentation();
            if (editorPresentation.addAnnotations(editor, frame)) {
                StandardDecoration decoration = new StandardDecoration(editorPresentation, editor, frame.getThread());
                DecorationManager.addDecoration(decoration);
            } else {
                ITextEditor textEditor = null;
                if (editor instanceof ITextEditor) {
                    textEditor = (ITextEditor)editor;
                } else {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    textEditor = (ITextEditor)editor.getAdapter((Class)clazz);
                }
                if (textEditor != null) {
                    this.positionEditor(textEditor, frame);
                    InstructionPointerManager.getDefault().addAnnotation(textEditor, frame);
                }
            }
        }
    }

    private IEditorPart openEditor(ISourceLookupResult result, IWorkbenchPage page) {
        IEditorPart editor = null;
        IEditorInput input = result.getEditorInput();
        String id = result.getEditorId();
        if (input == null || id == null) {
            return null;
        }
        if (this.fReuseEditor) {
            editor = page.getActiveEditor();
            if (editor != null && !editor.getEditorInput().equals(input)) {
                editor = null;
            }
            if (editor == null) {
                IEditorReference[] refs = page.getEditorReferences();
                int i = 0;
                while (i < refs.length) {
                    IEditorPart refEditor = refs[i].getEditor(false);
                    if (refEditor != null && input.equals(refEditor.getEditorInput())) {
                        editor = refEditor;
                        page.bringToTop((IWorkbenchPart)editor);
                        break;
                    }
                    ++i;
                }
            }
            if (editor == null) {
                IEditorPart editorForPage = this.getEditor(page);
                if (editorForPage == null || editorForPage.isDirty() || page.isEditorPinned(editorForPage)) {
                    editorForPage = editor = this.openEditor(page, input, id);
                } else if (editorForPage instanceof IReusableEditor && editorForPage.getSite().getId().equals(id)) {
                    ((IReusableEditor)editorForPage).setInput(input);
                    editor = editorForPage;
                    if (!page.isPartVisible((IWorkbenchPart)editor)) {
                        page.bringToTop((IWorkbenchPart)editor);
                    }
                } else {
                    editor = this.openEditor(page, input, id);
                    page.closeEditor(editorForPage, false);
                    editorForPage = editor;
                }
                this.setEditor(page, editorForPage);
            }
        } else {
            editor = this.openEditor(page, input, id);
        }
        return editor;
    }

    private void positionEditor(ITextEditor editor, IStackFrame frame) {
        try {
            IRegion region;
            int charStart = frame.getCharStart();
            if (charStart > 0) {
                int length = 0;
                int charEnd = frame.getCharEnd();
                if (charEnd > 0) {
                    length = charEnd - charStart;
                }
                editor.selectAndReveal(charStart, length);
                return;
            }
            int lineNumber = frame.getLineNumber();
            if ((region = this.getLineInformation(editor, --lineNumber)) != null) {
                editor.selectAndReveal(region.getOffset(), 0);
            }
        }
        catch (DebugException debugException) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IRegion getLineInformation(ITextEditor editor, int lineNumber) {
        IEditorInput input;
        IDocumentProvider provider;
        block7: {
            IRegion iRegion;
            provider = editor.getDocumentProvider();
            input = editor.getEditorInput();
            try {
                provider.connect((Object)input);
            }
            catch (CoreException coreException) {
                return null;
            }
            try {
                try {
                    IDocument document = provider.getDocument((Object)input);
                    if (document == null) break block7;
                    iRegion = document.getLineInformation(lineNumber);
                    Object var6_7 = null;
                }
                catch (BadLocationException badLocationException) {
                    break block7;
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                provider.disconnect((Object)input);
                throw throwable;
            }
            provider.disconnect((Object)input);
            return iRegion;
        }
        Object var6_9 = null;
        provider.disconnect((Object)input);
        return null;
    }

    private IEditorPart openEditor(final IWorkbenchPage page, final IEditorInput input, final String id) {
        final IEditorPart[] editor = new IEditorPart[1];
        Runnable r = new Runnable(){

            public void run() {
                try {
                    editor[0] = page.openEditor(input, id, false);
                }
                catch (PartInitException e) {
                    DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), DebugUIViewsMessages.LaunchView_Error_1, DebugUIViewsMessages.LaunchView_Exception_occurred_opening_editor_for_debugger__2, e);
                }
            }
        };
        BusyIndicator.showWhile((Display)DebugUIPlugin.getStandardDisplay(), (Runnable)r);
        return editor[0];
    }

    public void pageActivated(IWorkbenchPage page) {
    }

    public void pageClosed(IWorkbenchPage page) {
        this.fEditorsByPage.remove(page);
        page.removePartListener((IPartListener2)this);
    }

    public void pageOpened(IWorkbenchPage page) {
        page.addPartListener((IPartListener2)this);
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        IWorkbenchPage page = partRef.getPage();
        IEditorPart editor = this.getEditor(page);
        IWorkbenchPart part = partRef.getPart(false);
        if (part != null && part.equals(editor)) {
            this.fEditorsByPage.remove(page);
        }
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals(IDebugUIConstants.PREF_REUSE_EDITOR)) {
            this.fReuseEditor = DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IDebugUIConstants.PREF_REUSE_EDITOR);
        }
    }

    protected IEditorPart getEditor(IWorkbenchPage page) {
        return (IEditorPart)this.fEditorsByPage.get(page);
    }

    protected void setEditor(IWorkbenchPage page, IEditorPart editorPart) {
        if (editorPart == null) {
            this.fEditorsByPage.remove(page);
        } else {
            this.fEditorsByPage.put(page, editorPart);
        }
        page.addPartListener((IPartListener2)this);
        page.getWorkbenchWindow().addPageListener((IPageListener)this);
    }

    protected void dispose() {
        DebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.fEditorsByPage.clear();
    }
}

