/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import java.math.BigInteger;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.memory.AbstractTableRendering;

public class HexRendering
extends AbstractTableRendering {
    public HexRendering(String renderingId) {
        super(renderingId);
    }

    public String getString(String dataType, BigInteger address, MemoryByte[] data) {
        StringBuffer strBuffer = new StringBuffer();
        String paddedStr = DebugUIPlugin.getDefault().getPreferenceStore().getString(IDebugUIConstants.PREF_PADDED_STR);
        int i = 0;
        while (i < data.length) {
            if (data[i].isReadable()) {
                strBuffer.append(new String(HexRendering.convertByteToCharArray(data[i].getValue())));
            } else {
                strBuffer.append(paddedStr);
            }
            ++i;
        }
        return strBuffer.toString().toUpperCase();
    }

    public byte[] getBytes(String dataType, BigInteger address, MemoryByte[] currentValues, String data) {
        byte[] bytes = this.convertHexStringToByteArray(data, currentValues.length);
        return bytes;
    }

    public int getNumCharsPerByte() {
        return 2;
    }

    public static String convertByteArrayToHexString(byte[] byteArray) {
        StringBuffer strBuffer = new StringBuffer();
        int i = 0;
        while (i < byteArray.length) {
            char[] charArray = HexRendering.convertByteToCharArray(byteArray[i]);
            strBuffer.append(charArray);
            ++i;
        }
        return strBuffer.toString();
    }

    private static char[] convertByteToCharArray(byte aByte) {
        char[] charArray = new char[2];
        int val = aByte;
        if (val < 0) {
            val += 256;
        }
        charArray[0] = Character.forDigit(val / 16, 16);
        charArray[1] = Character.forDigit(val % 16, 16);
        return charArray;
    }

    public byte[] convertHexStringToByteArray(String str, int numBytes) throws NumberFormatException {
        if (str.length() == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer(str);
        int requiredPadding = numBytes * this.getNumCharsPerByte() - str.length();
        while (requiredPadding > 0) {
            buf.insert(0, "0");
            --requiredPadding;
        }
        byte[] bytes = new byte[numBytes];
        str = buf.toString();
        int i = 0;
        while (i < bytes.length) {
            String oneByte = str.substring(i * 2, i * 2 + 2);
            Integer number = Integer.valueOf(oneByte, 16);
            if (number.compareTo(Integer.valueOf(Byte.toString((byte)127))) > 0) {
                int temp = number;
                String tempStr = Integer.toString(temp -= 256);
                Byte myByte = Byte.valueOf(tempStr);
                bytes[i] = myByte;
            } else {
                Byte myByte = Byte.valueOf(oneByte, 16);
                bytes[i] = myByte;
            }
            ++i;
        }
        return bytes;
    }
}

