/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.util.CommonXML;
import org.eclipse.wst.sse.core.internal.util.JarUtilities;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DocumentProvider {
    private Document document = null;
    private ErrorHandler errorHandler = null;
    private String fBaseReference;
    private String fileName = null;
    private boolean fValidating = true;
    private InputStream inputStream = null;
    private String jarFileName = null;
    private EntityResolver resolver = null;
    private Node rootElement = null;
    private String rootElementName = null;

    private String _getFileName() {
        if (this.inputStream != null) {
            return null;
        }
        if (this.isJAR()) {
            return this.getJarFileName();
        }
        return this.getFileName();
    }

    /*
     * Exception decompiling
     */
    private Document _getParsedDocumentDOM2() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 149->152)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getBaseReference() {
        return this.fBaseReference;
    }

    public Document getDocument() {
        if (this.document == null) {
            this.load();
        }
        return this.document;
    }

    private DocumentBuilder getDocumentBuilder() {
        return CommonXML.getDocumentBuilder(this.isValidating());
    }

    private DOMImplementation getDomImplementation() {
        DocumentBuilder builder = null;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e1) {
            Logger.logException(e1);
        }
        catch (FactoryConfigurationError e1) {
            Logger.logException(e1);
        }
        DOMImplementation impl = builder.getDOMImplementation();
        return impl;
    }

    public Element getElement(String name) {
        Element result = null;
        if (this.document == null) {
            this.load();
        }
        if (this.document != null) {
            result = (Element)this.getNode(this.getRootElement(), name);
        }
        return result;
    }

    private EntityResolver getEntityResolver() {
        if (this.resolver == null) {
            this.resolver = new EntityResolver(){

                public InputSource resolveEntity(String publicID, String systemID) throws SAXException, IOException {
                    InputSource result = null;
                    if (DocumentProvider.this.getBaseReference() != null) {
                        try {
                            URL spec = new URL("file://" + DocumentProvider.this.getBaseReference());
                            URL url = new URL(spec, systemID);
                            if (url.getProtocol().startsWith("file:")) {
                                URLConnection connection = url.openConnection();
                                result = new InputSource(systemID != null ? systemID : "/_" + this.toString());
                                result.setPublicId(publicID);
                                result.setByteStream(connection.getInputStream());
                            }
                        }
                        catch (Exception exception) {
                            result = null;
                        }
                    }
                    if (result == null) {
                        result = new InputSource(new StringReader(""));
                        result.setPublicId(publicID);
                        result.setSystemId(systemID != null ? systemID : "/_" + this.getClass().getName());
                    }
                    return result;
                }
            };
        }
        return this.resolver;
    }

    public String getFileName() {
        return this.fileName;
    }

    public InputStream getInputStream() throws FileNotFoundException {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        if (this.isJAR()) {
            return JarUtilities.getInputStream((String)this.getJarFileName(), (String)this.getFileName());
        }
        return new FileInputStream(this.getFileName());
    }

    public String getJarFileName() {
        return this.jarFileName;
    }

    private Node getNamedChild(Node parent, String childName) {
        if (parent == null) {
            return null;
        }
        NodeList childList = parent.getChildNodes();
        int i = 0;
        while (i < childList.getLength()) {
            if (childList.item(i).getNodeName().equals(childName)) {
                return childList.item(i);
            }
            ++i;
        }
        return null;
    }

    private Document getNewDocument() {
        Document result = null;
        try {
            result = this.getDomImplementation().createDocument("http://www.w3.org/XML/1998/namespace", this.getRootElementName(), null);
            NodeList children = result.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                result.removeChild(children.item(i));
                ++i;
            }
            Element settings = result.createElementNS("http://www.w3.org/XML/1998/namespace", this.getRootElementName());
            result.appendChild(settings);
            return result;
        }
        catch (DOMException e) {
            Logger.logException(e);
            return null;
        }
    }

    private Node getNode(Node node, String name) {
        StringTokenizer tokenizer = new StringTokenizer(name, "/");
        String token = null;
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            if (this.getNamedChild(node, token) == null) {
                node.appendChild(this.document.createElement(token));
            }
            node = this.getNamedChild(node, token);
        }
        return node;
    }

    private ErrorHandler getNullErrorHandler() {
        if (this.errorHandler == null) {
            this.errorHandler = new ErrorHandler(){

                public void error(SAXParseException exception) throws SAXException {
                    Logger.log(2, "SAXParseException with " + DocumentProvider.this.getJarFileName() + "/" + DocumentProvider.this.getFileName() + " (error) while reading descriptor: " + exception.getMessage());
                }

                public void fatalError(SAXParseException exception) throws SAXException {
                    Logger.log(2, "SAXParseException with " + DocumentProvider.this.getJarFileName() + "/" + DocumentProvider.this.getFileName() + " (fatalError) while reading descriptor: " + exception.getMessage());
                }

                public void warning(SAXParseException exception) throws SAXException {
                    Logger.log(2, "SAXParseException with " + DocumentProvider.this.getJarFileName() + "/" + DocumentProvider.this.getFileName() + " (warning) while reading descriptor: " + exception.getMessage());
                }
            };
        }
        return this.errorHandler;
    }

    private Document getParsedDocument() {
        Document result = null;
        if (this.inputStream == null) {
            File existenceTester = null;
            existenceTester = this.isJAR() ? new File(this.getJarFileName()) : new File(this.getFileName());
            if (!existenceTester.exists()) {
                return null;
            }
        }
        result = this._getParsedDocumentDOM2();
        return result;
    }

    public Node getRootElement() {
        return this.getRootElement(this.getDocument());
    }

    private Node getRootElement(Document doc) {
        if (doc == null) {
            return null;
        }
        if (doc.getDocumentElement() != null) {
            return doc.getDocumentElement();
        }
        try {
            Element newRootElement = doc.createElement(this.getRootElementName());
            doc.appendChild(newRootElement);
            return newRootElement;
        }
        catch (DOMException e) {
            Logger.logException(e);
            return null;
        }
    }

    public String getRootElementName() {
        return this.rootElementName;
    }

    private boolean isJAR() {
        return this.getJarFileName() != null;
    }

    public boolean isValidating() {
        return this.fValidating;
    }

    public void load() {
        this.document = this.getParsedDocument();
        if (this.document != null) {
            this.rootElement = this.rootElementName != null ? this.getRootElement(this.document) : this.document.getDocumentElement();
        }
        if (this.document == null || this.rootElement == null) {
            this.document = this.getNewDocument();
            if (this.document != null) {
                NodeList children = this.document.getChildNodes();
                int i = 0;
                while (i < children.getLength()) {
                    if (children.item(i).getNodeType() == 1 && children.item(i).getNodeName().equals(this.getRootElementName())) {
                        this.rootElement = children.item(i);
                    }
                    ++i;
                }
                if (this.rootElement == null) {
                    i = 0;
                    while (i < children.getLength()) {
                        if (children.item(i).getNodeType() == 1) {
                            this.rootElement = children.item(i);
                            break;
                        }
                        ++i;
                    }
                }
            }
        }
    }

    public void setBaseReference(String string) {
        this.fBaseReference = string;
    }

    public void setFileName(String newFileName) {
        this.fileName = newFileName;
    }

    public void setInputStream(InputStream iStream) {
        this.inputStream = iStream;
    }

    public void setJarFileName(String newJarFileName) {
        this.jarFileName = newJarFileName;
    }

    public void setRootElementName(String newRootElementName) {
        this.rootElementName = newRootElementName;
    }

    public void setValidating(boolean b) {
        this.fValidating = b;
    }
}

