/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.taglib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.taglib.IJarRecord;
import org.eclipse.jst.jsp.core.taglib.ITLDRecord;
import org.eclipse.jst.jsp.core.taglib.ITaglibIndexListener;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecordEvent;
import org.eclipse.jst.jsp.core.taglib.IURLRecord;
import org.eclipse.jst.jsp.core.taglib.ProjectDescription;
import org.eclipse.wst.sse.core.internal.util.StringUtils;

public final class TaglibIndex {
    static final boolean _debugChangeListener = false;
    static boolean _debugEvents = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/taglib/events"));
    static boolean _debugIndexCreation = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/taglib/indexcreation"));
    static final boolean _debugResolution = "true".equals(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/taglib/resolve"));
    static TaglibIndex _instance;
    static boolean ENABLED;
    private ClasspathChangeListener fClasspathChangeListener = null;
    Map fProjectDescriptions;
    private ResourceChangeListener fResourceChangeListener = new ResourceChangeListener();
    private ITaglibIndexListener[] fTaglibIndexListeners = null;
    static /* synthetic */ Class class$0;

    static {
        ENABLED = true;
    }

    public static void addTaglibIndexListener(ITaglibIndexListener listener) {
        _instance.internalAddTaglibIndexListener(listener);
    }

    static void fireTaglibRecordEvent(ITaglibRecordEvent event) {
        ITaglibIndexListener[] listeners;
        if (_debugEvents) {
            Logger.log(201, "TaglibIndex fired event:" + event);
        }
        if ((listeners = TaglibIndex._instance.fTaglibIndexListeners) != null) {
            int i = 0;
            while (i < listeners.length) {
                try {
                    listeners[i].indexChanged(event);
                }
                catch (Exception e) {
                    Logger.log(2, e.getMessage());
                }
                ++i;
            }
        }
    }

    public static ITaglibRecord[] getAvailableTaglibRecords(IPath fullPath) {
        ITaglibRecord[] records = _instance.internalGetAvailableTaglibRecords(fullPath);
        return records;
    }

    public static IPath getContextRoot(IPath path) {
        return _instance.internalGetContextRoot(path);
    }

    public static void removeTaglibIndexListener(ITaglibIndexListener listener) {
        _instance.internalRemoveTaglibIndexListener(listener);
    }

    public static ITaglibRecord resolve(String basePath, String reference, boolean crossProjects) {
        ITaglibRecord result = _instance.internalResolve(basePath, reference, crossProjects);
        if (_debugResolution) {
            if (result == null) {
                Logger.log(201, "TaglibIndex could not resolve \"" + reference + "\" from " + basePath);
            } else {
                switch (result.getRecordType()) {
                    case 1: {
                        ITLDRecord record = (ITLDRecord)result;
                        Logger.log(201, "TaglibIndex resolved " + basePath + ":" + reference + " = " + record.getPath());
                        break;
                    }
                    case 2: {
                        IJarRecord record = (IJarRecord)result;
                        Logger.log(201, "TaglibIndex resolved " + basePath + ":" + reference + " = " + record.getLocation());
                        break;
                    }
                    case 8: {
                        break;
                    }
                    case 4: {
                        IURLRecord record = (IURLRecord)result;
                        Logger.log(201, "TaglibIndex resolved " + basePath + ":" + reference + " = " + record.getURL());
                    }
                }
            }
        }
        return result;
    }

    public static synchronized void shutdown() {
        if (_instance != null) {
            _instance.stop();
        }
        _instance = null;
    }

    public static synchronized void startup() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.jsp.core.taglib.TaglibIndex");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ENABLED = !"false".equalsIgnoreCase(System.getProperty(clazz.getName()));
        _instance = new TaglibIndex();
    }

    private TaglibIndex() {
        this.fClasspathChangeListener = new ClasspathChangeListener();
        if (ENABLED) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fResourceChangeListener, 1);
            JavaCore.addElementChangedListener((IElementChangedListener)this.fClasspathChangeListener);
        }
        this.fProjectDescriptions = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ProjectDescription createDescription(IProject project) {
        ProjectDescription description = null;
        IProject iProject = project;
        synchronized (iProject) {
            description = (ProjectDescription)this.fProjectDescriptions.get(project);
            if (description == null) {
                description = new ProjectDescription(project);
                if (ENABLED) {
                    description.index();
                    description.indexClasspath();
                }
                this.fProjectDescriptions.put(project, description);
            }
        }
        return description;
    }

    private synchronized void internalAddTaglibIndexListener(ITaglibIndexListener listener) {
        if (this.fTaglibIndexListeners == null) {
            this.fTaglibIndexListeners = new ITaglibIndexListener[]{listener};
        } else {
            ArrayList<ITaglibIndexListener> listeners = new ArrayList<ITaglibIndexListener>(Arrays.asList(this.fTaglibIndexListeners));
            listeners.add(listener);
            this.fTaglibIndexListeners = listeners.toArray(new ITaglibIndexListener[0]);
        }
    }

    private ITaglibRecord[] internalGetAvailableTaglibRecords(IPath path) {
        ITaglibRecord[] records = new ITaglibRecord[]{};
        if (path.segmentCount() > 0) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
            ProjectDescription description = this.createDescription(project);
            List availableRecords = description.getAvailableTaglibRecords(path);
            records = availableRecords.toArray(records);
        }
        return records;
    }

    private IPath internalGetContextRoot(IPath path) {
        IFile baseResource = FileBuffers.getWorkspaceFileAtLocation((IPath)path);
        if (baseResource != null) {
            IProject project = baseResource.getProject();
            ProjectDescription description = _instance.createDescription(project);
            IPath rootPath = description.getLocalRoot(baseResource.getFullPath());
            return ResourcesPlugin.getWorkspace().getRoot().getLocation().append(rootPath);
        }
        IPath root = path;
        while (root != null && !root.isRoot()) {
            root = root.removeLastSegments(1);
        }
        if (root == null) {
            root = path;
        }
        return root;
    }

    private synchronized void internalRemoveTaglibIndexListener(ITaglibIndexListener listener) {
        if (this.fTaglibIndexListeners != null) {
            ArrayList<ITaglibIndexListener> listeners = new ArrayList<ITaglibIndexListener>(Arrays.asList(this.fTaglibIndexListeners));
            listeners.remove(listener);
            this.fTaglibIndexListeners = listeners.toArray(new ITaglibIndexListener[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ITaglibRecord internalResolve(String basePath, String reference, boolean crossProjects) {
        IFile[] files;
        IProject project = null;
        ITaglibRecord resolved = null;
        IFile baseResource = FileBuffers.getWorkspaceFileAtLocation((IPath)new Path(basePath));
        if (baseResource == null && (files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(basePath))).length > 0) {
            baseResource = files[0];
        }
        if (baseResource != null) {
            IProject iProject = project = baseResource.getProject();
            synchronized (iProject) {
                ProjectDescription description = this.createDescription(project);
                resolved = description.resolve(basePath, reference);
            }
        }
        return resolved;
    }

    boolean isIndexAvailable() {
        return _instance != null;
    }

    private void stop() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fResourceChangeListener);
        JavaCore.removeElementChangedListener((IElementChangedListener)this.fClasspathChangeListener);
        this.fProjectDescriptions.clear();
    }

    class ClasspathChangeListener
    implements IElementChangedListener {
        Stack classpathStack = new Stack();
        List projectsIndexed = new ArrayList(1);

        ClasspathChangeListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            if (!TaglibIndex.this.isIndexAvailable()) {
                return;
            }
            this.classpathStack.clear();
            this.projectsIndexed.clear();
            this.elementChanged(event.getDelta());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void elementChanged(IJavaElementDelta delta) {
            if (delta.getElement().getElementType() == 1) {
                IJavaElementDelta[] changed = delta.getChangedChildren();
                int i = 0;
                while (i < changed.length) {
                    this.elementChanged(changed[i]);
                    ++i;
                }
            } else if (delta.getElement().getElementType() == 2 && (delta.getFlags() & 0x20000) != 0) {
                IJavaElement proj;
                IJavaElement iJavaElement = proj = delta.getElement();
                synchronized (iJavaElement) {
                    this.handleClasspathChange((IJavaProject)proj);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleClasspathChange(IJavaProject project) {
            if (this.classpathStack.contains(project.getElementName())) {
                return;
            }
            IJavaProject iJavaProject = project;
            synchronized (iJavaProject) {
                this.classpathStack.push(project.getElementName());
                try {
                    IResource resource = project.getCorrespondingResource();
                    if (resource.getType() == 4 && !this.projectsIndexed.contains(resource)) {
                        this.projectsIndexed.add(resource);
                        boolean classpathIndexIsOld = TaglibIndex.this.fProjectDescriptions.containsKey(resource);
                        ProjectDescription description = TaglibIndex.this.createDescription((IProject)resource);
                        if (classpathIndexIsOld) {
                            description.indexClasspath();
                        }
                    }
                    IJavaProject[] projects = project.getJavaModel().getJavaProjects();
                    int i = 0;
                    while (i < projects.length) {
                        IJavaProject otherProject = projects[i];
                        if (StringUtils.contains((String[])otherProject.getRequiredProjectNames(), (String)project.getElementName(), (boolean)false) && !this.classpathStack.contains(otherProject.getElementName())) {
                            this.handleClasspathChange(otherProject);
                        }
                        ++i;
                    }
                }
                catch (JavaModelException javaModelException) {}
                this.classpathStack.pop();
            }
        }
    }

    class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resourceChanged(IResourceChangeEvent event) {
            if (!TaglibIndex.this.isIndexAvailable()) {
                return;
            }
            switch (event.getType()) {
                case 2: 
                case 4: {
                    ProjectDescription description;
                    int i;
                    IResource resource;
                    IProject[] projects;
                    IResourceDelta[] deltas;
                    try {
                        deltas = new IResourceDelta[]{event.getDelta()};
                        projects = null;
                        if (deltas != null && deltas.length > 0) {
                            resource = null;
                            resource = deltas[0] != null ? deltas[0].getResource() : event.getResource();
                            if (resource != null) {
                                if (resource.getType() == 8) {
                                    deltas = deltas[0].getAffectedChildren();
                                    projects = new IProject[deltas.length];
                                    i = 0;
                                    while (i < deltas.length) {
                                        if (deltas[i].getResource().getType() == 4) {
                                            projects[i] = (IProject)deltas[i].getResource();
                                        }
                                        ++i;
                                    }
                                } else {
                                    projects = new IProject[]{resource.getType() != 4 ? resource.getProject() : (IProject)resource};
                                }
                            }
                            i = 0;
                            while (i < projects.length) {
                                if (_debugIndexCreation) {
                                    Logger.log(201, "TaglibIndex noticed " + projects[i].getName() + " is about to be deleted/closed");
                                }
                                if ((description = (ProjectDescription)TaglibIndex.this.fProjectDescriptions.remove(projects[i])) != null) {
                                    if (_debugIndexCreation) {
                                        Logger.log(201, "removing index of " + description.fProject.getName());
                                    }
                                    description.clear();
                                }
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        Logger.logException("Exception while processing resource deletion", e);
                    }
                }
                case 1: {
                    ProjectDescription description;
                    int i;
                    IResource resource;
                    IProject[] projects;
                    IResourceDelta[] deltas;
                    try {
                        deltas = new IResourceDelta[]{event.getDelta()};
                        projects = null;
                        if (deltas == null || deltas.length <= 0) break;
                        resource = null;
                        resource = deltas[0] != null ? deltas[0].getResource() : event.getResource();
                        if (resource != null) {
                            if (resource.getType() == 8) {
                                deltas = deltas[0].getAffectedChildren();
                                projects = new IProject[deltas.length];
                                i = 0;
                                while (i < deltas.length) {
                                    if (deltas[i].getResource().getType() == 4) {
                                        projects[i] = (IProject)deltas[i].getResource();
                                    }
                                    ++i;
                                }
                            } else {
                                projects = new IProject[]{resource.getType() != 4 ? resource.getProject() : (IProject)resource};
                            }
                        }
                        i = 0;
                        while (i < projects.length) {
                            try {
                                if (deltas[i] != null && deltas[i].getKind() != 2 && projects[i].isAccessible()) {
                                    description = TaglibIndex.this.createDescription(projects[i]);
                                    IProject iProject = projects[i];
                                    synchronized (iProject) {
                                        deltas[i].accept(description.getVisitor());
                                    }
                                }
                                if (!projects[i].isAccessible() || deltas[i] != null && deltas[i].getKind() == 2) {
                                    if (_debugIndexCreation) {
                                        Logger.log(201, "TaglibIndex noticed " + projects[i].getName() + " was removed or is no longer accessible");
                                    }
                                    if ((description = (ProjectDescription)TaglibIndex.this.fProjectDescriptions.remove(projects[i])) != null) {
                                        if (_debugIndexCreation) {
                                            Logger.log(201, "removing index of " + description.fProject.getName());
                                        }
                                        description.clear();
                                    }
                                }
                            }
                            catch (CoreException e) {
                                Logger.logException(e);
                            }
                            ++i;
                        }
                        break;
                    }
                    catch (Exception e) {
                        Logger.logException("Exception while processing resource change", e);
                    }
                }
            }
        }
    }
}

