/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.tags;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.util.Assert;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.tags.TagConfigurationDialog;
import org.eclipse.team.internal.ccvs.ui.tags.TagSource;
import org.eclipse.team.internal.ui.PixelConverter;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.team.internal.ui.dialogs.DialogArea;
import org.eclipse.ui.PlatformUI;

public class TagRefreshButtonArea
extends DialogArea {
    private TagSource tagSource;
    private final Shell shell;
    private Button refreshButton;
    private IRunnableContext context;
    private Label fMessageLabel;
    private final Listener addDateTagListener;

    public TagRefreshButtonArea(Shell shell, TagSource tagSource, Listener addDateTagListener) {
        this.addDateTagListener = addDateTagListener;
        Assert.isNotNull((Object)shell);
        Assert.isNotNull((Object)tagSource);
        this.shell = shell;
        this.tagSource = tagSource;
    }

    public void createArea(Composite parent) {
        int buttonWidth;
        PixelConverter converter = SWTUtils.createDialogPixelConverter((Control)parent);
        Composite buttonComp = new Composite(parent, 0);
        buttonComp.setLayoutData((Object)SWTUtils.createHFillGridData());
        buttonComp.setLayout((Layout)SWTUtils.createGridLayout((int)4, (PixelConverter)converter, (int)0));
        this.fMessageLabel = SWTUtils.createLabel((Composite)buttonComp, null);
        this.refreshButton = new Button(buttonComp, 8);
        this.refreshButton.setText(CVSUIMessages.TagConfigurationDialog_20);
        Button configureTagsButton = new Button(buttonComp, 8);
        configureTagsButton.setText(CVSUIMessages.TagConfigurationDialog_21);
        Button addDateTagButton = null;
        if (this.addDateTagListener != null) {
            addDateTagButton = new Button(buttonComp, 8);
            addDateTagButton.setText(CVSUIMessages.TagConfigurationDialog_AddDateTag);
            Dialog.applyDialogFont((Control)buttonComp);
            buttonWidth = SWTUtils.calculateControlSize((PixelConverter)converter, (Control[])new Button[]{addDateTagButton, configureTagsButton, this.refreshButton});
            addDateTagButton.setLayoutData((Object)SWTUtils.createGridData((int)buttonWidth, (int)-1, (int)0x1000008, (int)0x1000000, (boolean)false, (boolean)false));
            addDateTagButton.addListener(13, this.addDateTagListener);
        } else {
            Dialog.applyDialogFont((Control)buttonComp);
            buttonWidth = SWTUtils.calculateControlSize((PixelConverter)converter, (Control[])new Button[]{configureTagsButton, this.refreshButton});
        }
        this.refreshButton.setLayoutData((Object)SWTUtils.createGridData((int)buttonWidth, (int)-1, (int)0x1000008, (int)0x1000000, (boolean)false, (boolean)false));
        configureTagsButton.setLayoutData((Object)SWTUtils.createGridData((int)buttonWidth, (int)-1, (int)0x1000008, (int)0x1000000, (boolean)false, (boolean)false));
        this.refreshButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TagRefreshButtonArea.this.refresh(false);
            }
        });
        configureTagsButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TagConfigurationDialog d = new TagConfigurationDialog(TagRefreshButtonArea.this.shell, TagRefreshButtonArea.this.tagSource);
                d.open();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.refreshButton, "org.eclipse.team.cvs.ui.tag_configuration_refreshaction");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)configureTagsButton, "org.eclipse.team.cvs.ui.tag_configuration_overview");
        Dialog.applyDialogFont((Control)buttonComp);
    }

    public void refresh(final boolean background) {
        try {
            this.getRunnableContext().run(true, true, new IRunnableWithProgress(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            TagRefreshButtonArea.this.setBusy(true);
                            Display.getDefault().asyncExec(new Runnable(this){
                                final /* synthetic */ 3 this$1;
                                {
                                    this.this$1 = var1_1;
                                }

                                public void run() {
                                    TagRefreshButtonArea.access$3(3.access$0(this.this$1)).setText(CVSUIMessages.TagRefreshButtonArea_6);
                                }
                            });
                            monitor.beginTask(CVSUIMessages.TagRefreshButtonArea_5, 100);
                            CVSTag[] tags = TagRefreshButtonArea.this.tagSource.refresh(false, Policy.subMonitorFor(monitor, 70));
                            Display.getDefault().asyncExec(new Runnable(this, background, tags){
                                final /* synthetic */ 3 this$1;
                                private final /* synthetic */ boolean val$background;
                                private final /* synthetic */ CVSTag[] val$tags;
                                {
                                    this.this$1 = var1_1;
                                    this.val$background = bl;
                                    this.val$tags = cVSTagArray;
                                }

                                public void run() {
                                    TagRefreshButtonArea.access$3(3.access$0(this.this$1)).setText(this.val$background && this.val$tags.length == 0 ? CVSUIMessages.TagRefreshButtonArea_7 : "");
                                }
                            });
                            if (!background && tags.length == 0 && TagRefreshButtonArea.this.promptForBestEffort()) {
                                TagRefreshButtonArea.this.tagSource.refresh(true, Policy.subMonitorFor(monitor, 30));
                            }
                        }
                        catch (TeamException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_5 = null;
                        TagRefreshButtonArea.this.setBusy(false);
                        monitor.done();
                        throw throwable;
                    }
                    {
                        Object var3_6 = null;
                    }
                    TagRefreshButtonArea.this.setBusy(false);
                    monitor.done();
                }

                static /* synthetic */ TagRefreshButtonArea access$0(3 var0) {
                    return var0.TagRefreshButtonArea.this;
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            CVSUIPlugin.openError(this.shell, CVSUIMessages.TagConfigurationDialog_14, null, e);
        }
    }

    private void setBusy(final boolean busy) {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    TagRefreshButtonArea.this.refreshButton.setEnabled(!busy);
                }
            });
        }
    }

    private boolean promptForBestEffort() {
        final boolean[] prompt = new boolean[1];
        this.shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                MessageDialog dialog = new MessageDialog(TagRefreshButtonArea.this.shell, CVSUIMessages.TagRefreshButtonArea_0, null, TagRefreshButtonArea.this.getNoTagsFoundMessage(), 2, new String[]{CVSUIMessages.TagRefreshButtonArea_1, CVSUIMessages.TagRefreshButtonArea_2, CVSUIMessages.TagRefreshButtonArea_3}, 1);
                int code = dialog.open();
                if (code == 0) {
                    prompt[0] = true;
                } else if (code == 1) {
                    TagConfigurationDialog d = new TagConfigurationDialog(TagRefreshButtonArea.this.shell, TagRefreshButtonArea.this.tagSource);
                    d.open();
                }
            }
        });
        return prompt[0];
    }

    private String getNoTagsFoundMessage() {
        return NLS.bind((String)CVSUIMessages.TagRefreshButtonArea_4, (Object[])new String[]{this.tagSource.getShortDescription()});
    }

    public void setTagSource(TagSource tagSource) {
        Assert.isNotNull((Object)tagSource);
        this.tagSource = tagSource;
    }

    public IRunnableContext getRunnableContext() {
        if (this.context == null) {
            return PlatformUI.getWorkbench().getProgressService();
        }
        return this.context;
    }

    public void setRunnableContext(IRunnableContext context) {
        this.context = context;
    }

    static /* synthetic */ Label access$3(TagRefreshButtonArea tagRefreshButtonArea) {
        return tagRefreshButtonArea.fMessageLabel;
    }
}

