/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor.quickdiff.compare.rangedifferencer;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.Assert;
import org.eclipse.ui.internal.texteditor.quickdiff.compare.rangedifferencer.IRangeComparator;
import org.eclipse.ui.internal.texteditor.quickdiff.compare.rangedifferencer.RangeDifference;

public final class Levenstein {
    private static final boolean DEBUG = false;
    private static final boolean MATRIX = false;
    private static final int COST_DELETE = 1;
    private static final int COST_INSERT = 1;
    private static final int COST_CHANGE = 1;
    private static final int SKIP = Integer.MAX_VALUE;
    private static final RangeDifference[] EMPTY_DIFFERENCES = new RangeDifference[0];
    private static final int NO_DISTANCE = 0;
    private IRangeComparator fLeft;
    private IRangeComparator fRight;
    private IProgressMonitor fProgressMonitor;
    int[][] fMatrix;
    int[] fPreviousRow;
    int[] fCurrentRow;
    private int[] fResultRow;
    private int fStep;
    private int fRow;
    private int fRowStart;
    private int fRowEnd;
    private int fColStart;
    private int fColEnd;
    private int fMaxCost;
    private long fComparisons;
    private int[] fOptimalSplitColumn;
    private boolean[] fOptimalSplitValues;
    private List fDiffs;
    final CellComputer fStandardCC = new DefaultCellComputer();
    final CellComputer fOptimizedCC = new OptimizedCellComputer();
    CellComputer fCellComputer = this.fStandardCC;

    public static RangeDifference[] findDifferences(IRangeComparator left, IRangeComparator right) {
        Levenstein levenstein = new Levenstein(left, right);
        return levenstein.editScriptHirschberg();
    }

    public static RangeDifference[] findDifferences(IProgressMonitor pm, IRangeComparator left, IRangeComparator right) {
        Levenstein levenstein = new Levenstein(pm, left, right);
        return levenstein.editScriptHirschberg();
    }

    public Levenstein(IRangeComparator left, IRangeComparator right) {
        this(null, left, right);
    }

    public Levenstein(IProgressMonitor pm, IRangeComparator left, IRangeComparator right) {
        if (left == null || right == null) {
            throw new NullPointerException();
        }
        this.fLeft = left;
        this.fRight = right;
        this.fProgressMonitor = pm != null ? pm : new NullProgressMonitor();
    }

    public int editDistance() {
        block3: {
            try {
                this.fCellComputer = this.fOptimizedCC;
                this.initRows();
                this.internalEditDistance(1, this.fRight.getRangeCount(), 1, this.fLeft.getRangeCount());
                if (!this.fProgressMonitor.isCanceled()) break block3;
                Object var1_1 = null;
                this.clear();
                return 0;
            }
            catch (Throwable throwable) {
                Object var1_3 = null;
                this.clear();
                throw throwable;
            }
        }
        int n = this.getAt(this.fRowEnd, this.fColEnd);
        Object var1_2 = null;
        this.clear();
        return n;
    }

    public RangeDifference[] editScript() {
        RangeDifference[] script;
        block3: {
            try {
                this.fCellComputer = this.fOptimizedCC;
                this.initMatrix();
                this.internalEditDistance(1, this.fRight.getRangeCount(), 1, this.fLeft.getRangeCount());
                if (!this.fProgressMonitor.isCanceled()) break block3;
                RangeDifference[] rangeDifferenceArray = EMPTY_DIFFERENCES;
                Object var2_3 = null;
                this.clear();
                return rangeDifferenceArray;
            }
            catch (Throwable throwable) {
                Object var2_5 = null;
                this.clear();
                throw throwable;
            }
        }
        RangeDifference[] rangeDifferenceArray = script = this.walkback();
        Object var2_4 = null;
        this.clear();
        return rangeDifferenceArray;
    }

    public RangeDifference[] editScriptHirschberg() {
        RangeDifference[] script;
        block3: {
            try {
                this.fCellComputer = this.fStandardCC;
                this.initRows();
                this.fResultRow = new int[this.fCurrentRow.length];
                this.fOptimalSplitColumn = new int[this.fRight.getRangeCount() + 1];
                this.fOptimalSplitValues = new boolean[this.fRight.getRangeCount() + 1];
                this.hirschberg(1, this.fRight.getRangeCount(), 1, this.fLeft.getRangeCount());
                if (!this.fProgressMonitor.isCanceled()) break block3;
                RangeDifference[] rangeDifferenceArray = EMPTY_DIFFERENCES;
                Object var2_3 = null;
                this.clear();
                return rangeDifferenceArray;
            }
            catch (Throwable throwable) {
                Object var2_5 = null;
                this.clear();
                throw throwable;
            }
        }
        RangeDifference[] rangeDifferenceArray = script = this.buildDifferencesHirschberg();
        Object var2_4 = null;
        this.clear();
        return rangeDifferenceArray;
    }

    public int editDistanceHirschberg() {
        int dist;
        block3: {
            try {
                this.fCellComputer = this.fStandardCC;
                this.initRows();
                this.fResultRow = new int[this.fLeft.getRangeCount() + 1];
                this.fOptimalSplitColumn = new int[this.fRight.getRangeCount() + 1];
                this.fOptimalSplitValues = new boolean[this.fRight.getRangeCount() + 1];
                dist = this.hirschberg(1, this.fRight.getRangeCount(), 1, this.fLeft.getRangeCount());
                if (!this.fProgressMonitor.isCanceled()) break block3;
                Object var2_2 = null;
                this.clear();
                return 0;
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                this.clear();
                throw throwable;
            }
        }
        int n = dist;
        Object var2_3 = null;
        this.clear();
        return n;
    }

    void initMatrix() {
        this.initMatrix(this.fRight.getRangeCount() + 1, this.fLeft.getRangeCount() + 1);
    }

    void initMatrix(int rows, int columns) {
        if (this.fMatrix == null || this.fMatrix.length < rows || this.fMatrix[0].length < columns) {
            this.fMatrix = new int[rows][columns];
        }
    }

    void initRows() {
        this.initRows(this.fLeft.getRangeCount() + 1);
    }

    void initRows(int columns) {
        if (this.fCurrentRow == null || this.fCurrentRow.length < columns) {
            this.fCurrentRow = new int[columns];
        }
        if (this.fPreviousRow == null || this.fPreviousRow.length < columns) {
            this.fPreviousRow = new int[columns];
        }
    }

    void internalEditDistance(int rStart, int rEnd, int lStart, int lEnd) {
        Assert.isTrue((rStart <= rEnd + 1 ? 1 : 0) != 0);
        Assert.isTrue((lStart <= lEnd + 1 ? 1 : 0) != 0);
        this.fStep = 1;
        this.fRowStart = rStart - this.fStep;
        this.fRowEnd = rEnd;
        this.fColStart = lStart - this.fStep;
        this.fColEnd = lEnd;
        this.fMaxCost = this.maxCost(this.fRowStart, this.fColStart, 0);
        this.fRow = this.fRowStart;
        while (this.fRow <= this.fRowEnd) {
            this.fProgressMonitor.worked(1);
            int col = this.fColStart;
            while (col <= this.fColEnd) {
                if (this.fProgressMonitor.isCanceled()) {
                    return;
                }
                this.setAt(this.fRow, col, this.fCellComputer.computeCell(this.fRow, col));
                col += this.fStep;
            }
            this.swapRows();
            this.fRow += this.fStep;
        }
    }

    void internalReverseEditDistance(int rStart, int rEnd, int lStart, int lEnd) {
        Assert.isTrue((rStart <= rEnd + 1 ? 1 : 0) != 0);
        Assert.isTrue((lStart <= lEnd + 1 ? 1 : 0) != 0);
        this.fStep = -1;
        this.fRowStart = rEnd - this.fStep;
        this.fRowEnd = rStart;
        this.fColStart = lEnd - this.fStep;
        this.fColEnd = lStart;
        this.fMaxCost = this.maxCost(this.fRowStart, this.fColStart, 0);
        this.fRow = this.fRowStart;
        while (this.fRow >= this.fRowEnd) {
            this.fProgressMonitor.worked(1);
            int col = this.fColStart;
            while (col >= this.fColEnd) {
                if (this.fProgressMonitor.isCanceled()) {
                    return;
                }
                this.setAt(this.fRow, col, this.fCellComputer.computeCell(this.fRow, col));
                col += this.fStep;
            }
            this.swapRows();
            this.fRow += this.fStep;
        }
    }

    private void swapRows() {
        int[] tmp = this.fPreviousRow;
        this.fPreviousRow = this.fCurrentRow;
        this.fCurrentRow = tmp;
    }

    private void clear() {
        this.fPreviousRow = null;
        this.fCurrentRow = null;
        this.fMatrix = null;
        this.fDiffs = null;
        this.fResultRow = null;
        this.fOptimalSplitColumn = null;
        this.fOptimalSplitValues = null;
    }

    private int getAt(int row, int column) {
        if (this.fStep < 0) {
            --column;
        }
        if (this.fMatrix != null) {
            return this.fMatrix[row][column];
        }
        if (row == this.fRow) {
            return this.fCurrentRow[column];
        }
        if (row == this.fRow - this.fStep && (this.fStep > 0 && row >= this.fRowStart && row <= this.fRowEnd || this.fStep < 0 && row <= this.fRowStart && row >= this.fRowEnd)) {
            return this.fPreviousRow[column];
        }
        Assert.isTrue((boolean)false, (String)"random access to matrix not allowed");
        return Integer.MAX_VALUE;
    }

    private void setAt(int row, int column, int value) {
        if (this.fStep < 0) {
            --column;
        }
        if (this.fMatrix != null) {
            this.fMatrix[row][column] = value;
        } else if (row == this.fRow) {
            this.fCurrentRow[column] = value;
        } else if (row == this.fRow - this.fStep && (this.fStep > 0 && row >= this.fRowStart && row <= this.fRowEnd || this.fStep < 0 && row <= this.fRowStart && row >= this.fRowEnd)) {
            this.fPreviousRow[column] = value;
        } else {
            Assert.isTrue((boolean)false, (String)"random access to matrix not allowed");
        }
    }

    private boolean rangesEqual(int r, int l) {
        ++this.fComparisons;
        return this.fLeft.rangesEqual(l - 1, this.fRight, r - 1);
    }

    private static int sum(int c1, int c2) {
        int sum = c1 + c2;
        if (sum < 0) {
            return Integer.MAX_VALUE;
        }
        return sum;
    }

    private int minCost(int r, int l, int cCur) {
        if (cCur == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return cCur + Math.abs(this.fRowEnd - r - (this.fColEnd - l)) * 1;
    }

    private int maxCost(int r, int l, int cCur) {
        if (cCur == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return cCur + Math.max(Math.abs(this.fRowEnd - r), Math.abs(this.fColEnd - l)) * 1;
    }

    private RangeDifference[] walkback() {
        this.fDiffs = new LinkedList();
        int row = this.fRowEnd;
        int col = this.fColEnd;
        RangeDifference difference = null;
        int cell = this.fMatrix[row][col];
        while (row > 0 || col > 0) {
            int left;
            int above;
            int diag;
            if (row == 0) {
                diag = Integer.MAX_VALUE;
                above = Integer.MAX_VALUE;
                left = col - 1;
            } else if (col == 0) {
                diag = Integer.MAX_VALUE;
                above = row - 1;
                left = Integer.MAX_VALUE;
            } else {
                diag = this.fMatrix[row - 1][col - 1];
                above = this.fMatrix[row - 1][col];
                left = this.fMatrix[row][col - 1];
            }
            if (left == cell - 1 && left <= diag && left <= above) {
                difference = this.getChange(difference);
                difference.fLeftStart = --col;
                ++difference.fLeftLength;
                difference.fRightStart = row;
                cell = left;
                continue;
            }
            if (above == cell - 1 && above <= diag) {
                difference = this.getChange(difference);
                difference.fLeftStart = col;
                difference.fRightStart = --row;
                ++difference.fRightLength;
                cell = above;
                continue;
            }
            --col;
            --row;
            if (cell == diag) {
                difference = null;
            } else if (cell == diag + 1) {
                difference = this.getChange(difference);
                difference.fLeftStart = col;
                ++difference.fLeftLength;
                difference.fRightStart = row;
                ++difference.fRightLength;
            } else {
                Assert.isTrue((boolean)false, (String)"illegal matrix");
            }
            cell = diag;
        }
        return this.fDiffs.toArray(new RangeDifference[this.fDiffs.size()]);
    }

    private RangeDifference getChange(RangeDifference difference) {
        if (difference != null) {
            return difference;
        }
        difference = new RangeDifference(2);
        this.fDiffs.add(0, difference);
        return difference;
    }

    private int hirschberg(int rStart, int rEnd, int lStart, int lEnd) {
        if (rEnd < rStart) {
            return lEnd - lStart + 1;
        }
        if (rStart == rEnd) {
            this.internalEditDistance(rStart, rEnd, lStart, lEnd);
            int distance = Integer.MAX_VALUE;
            int col = lStart - 1;
            while (col <= lEnd) {
                distance = this.fPreviousRow[col];
                if (distance == 0) {
                    this.fOptimalSplitColumn[rStart] = col;
                    this.fOptimalSplitValues[rStart] = true;
                    return 0;
                }
                ++col;
            }
            this.fOptimalSplitColumn[rStart] = lEnd;
            this.fOptimalSplitValues[rStart] = false;
            if (distance == Integer.MAX_VALUE) {
                return 1;
            }
            return distance;
        }
        int rowSplit = (rStart + rEnd + 1) / 2 - 1;
        this.internalEditDistance(rStart, rowSplit, lStart, lEnd);
        int[] tmp = this.fPreviousRow;
        this.fPreviousRow = this.fResultRow;
        this.fResultRow = tmp;
        this.internalReverseEditDistance(rowSplit + 1, rEnd, lStart, lEnd);
        int columnSplit = Integer.MAX_VALUE;
        int distance = Integer.MAX_VALUE;
        int col = lStart - 1;
        while (col <= lEnd) {
            int sum = Levenstein.sum(this.fResultRow[col], this.fPreviousRow[col]);
            if (sum < distance) {
                distance = sum;
                columnSplit = col;
            }
            ++col;
        }
        if (this.fProgressMonitor.isCanceled()) {
            return 0;
        }
        Assert.isTrue((distance != Integer.MAX_VALUE ? 1 : 0) != 0);
        Assert.isTrue((columnSplit != Integer.MAX_VALUE ? 1 : 0) != 0);
        if (distance == 0) {
            Assert.isTrue((rEnd - rStart == lEnd - lStart ? 1 : 0) != 0);
            col = lStart;
            int row = rStart;
            while (row <= rEnd) {
                this.fOptimalSplitColumn[row] = col++;
                this.fOptimalSplitValues[row] = true;
                ++row;
            }
            return distance;
        }
        this.fOptimalSplitColumn[rowSplit] = columnSplit;
        this.fOptimalSplitValues[rowSplit] = false;
        this.hirschberg(rStart, rowSplit, lStart, columnSplit);
        this.hirschberg(rowSplit + 1, rEnd, columnSplit + 1, lEnd);
        return distance;
    }

    private RangeDifference[] buildDifferencesHirschberg() {
        this.fDiffs = new LinkedList();
        RangeDifference difference = null;
        int previousColumn = 0;
        int row = 1;
        while (row < this.fOptimalSplitColumn.length) {
            int previousRow = row - 1;
            int column = this.fOptimalSplitColumn[row];
            if (column == previousColumn + 1) {
                if (this.fOptimalSplitValues[row]) {
                    difference = null;
                } else {
                    difference = this.getChange(difference, previousRow, previousColumn);
                    ++difference.fLeftLength;
                    ++difference.fRightLength;
                }
            } else if (column == previousColumn) {
                difference = this.getChange(difference, previousRow, previousColumn);
                ++difference.fRightLength;
            } else if (column > previousColumn) {
                difference = this.getChange(difference, previousRow, previousColumn);
                difference.fLeftLength += column - previousColumn - 1;
            } else {
                Assert.isTrue((boolean)false, (String)"Illegal edit description");
            }
            previousColumn = column;
            ++row;
        }
        if (previousColumn < this.fLeft.getRangeCount()) {
            difference = this.getChange(difference, this.fOptimalSplitColumn.length - 1, previousColumn);
            difference.fLeftLength += this.fLeft.getRangeCount() - previousColumn;
        }
        return this.fDiffs.toArray(new RangeDifference[this.fDiffs.size()]);
    }

    private RangeDifference getChange(RangeDifference difference, int row, int column) {
        if (difference != null) {
            return difference;
        }
        difference = new RangeDifference(2, row, 0, column, 0);
        this.fDiffs.add(difference);
        return difference;
    }

    private void printRow() {
        if (this.fMatrix != null) {
            Levenstein.print(this.fMatrix[this.fRow]);
        } else {
            Levenstein.print(this.fCurrentRow);
        }
    }

    private static void printHeader(IRangeComparator left, IRangeComparator right) {
        System.out.println("=============================");
        System.out.println("= s1: " + left.toString());
        System.out.println("= s2: " + right.toString());
        System.out.println();
    }

    private static void print(int[] row) {
        int i = 0;
        while (i < row.length) {
            System.out.print("\t" + (row[i] == Integer.MAX_VALUE ? "-" : "" + row[i]));
            ++i;
        }
        System.out.println();
    }

    private static interface CellComputer {
        public int computeCell(int var1, int var2);
    }

    private final class DefaultCellComputer
    implements CellComputer {
        DefaultCellComputer() {
        }

        public int computeCell(int row, int column) {
            if (row == Levenstein.this.fRowStart) {
                return this.computeNullRow(column);
            }
            if (column == Levenstein.this.fColStart) {
                return this.computeNullColumn(row);
            }
            return this.computeInnerCell(row, column);
        }

        private int computeNullRow(int column) {
            return Math.abs(column - Levenstein.this.fColStart);
        }

        private int computeNullColumn(int row) {
            return Math.abs(row - Levenstein.this.fRowStart);
        }

        private int computeInnerCell(int row, int col) {
            int fromAbove = Levenstein.sum(Levenstein.this.getAt(row - Levenstein.this.fStep, col), 1);
            int fromLeft = Levenstein.sum(Levenstein.this.getAt(row, col - Levenstein.this.fStep), 1);
            int minDiag = Levenstein.this.getAt(row - Levenstein.this.fStep, col - Levenstein.this.fStep);
            int minCellValue = Math.min(Math.min(fromAbove, fromLeft), minDiag);
            int minCost = Levenstein.this.minCost(row, col, minCellValue);
            if (minCellValue == fromAbove || minCellValue == fromLeft) {
                return minCellValue;
            }
            Assert.isTrue((minCellValue == minDiag && fromAbove >= minDiag && fromLeft >= minDiag ? 1 : 0) != 0);
            int nextCharCost = Levenstein.this.rangesEqual(row, col) ? 0 : 1;
            minCost = Levenstein.sum(minCost, nextCharCost);
            int cost = minDiag + nextCharCost;
            return cost;
        }
    }

    private final class OptimizedCellComputer
    implements CellComputer {
        OptimizedCellComputer() {
        }

        public int computeCell(int row, int column) {
            if (row == Levenstein.this.fRowStart) {
                return this.computeNullRow(column);
            }
            if (column == Levenstein.this.fColStart) {
                return this.computeNullColumn(row);
            }
            return this.computeInnerCell(row, column);
        }

        private int computeNullRow(int column) {
            if (Levenstein.this.minCost(Levenstein.this.fRowStart, column, Math.abs(column - Levenstein.this.fColStart)) > Levenstein.this.fMaxCost) {
                return Integer.MAX_VALUE;
            }
            return Math.abs(column - Levenstein.this.fColStart);
        }

        private int computeNullColumn(int row) {
            if (Levenstein.this.minCost(row, Levenstein.this.fColStart, Math.abs(row - Levenstein.this.fRowStart)) > Levenstein.this.fMaxCost) {
                return Integer.MAX_VALUE;
            }
            return Math.abs(row - Levenstein.this.fRowStart);
        }

        private int computeInnerCell(int row, int col) {
            int fromAbove = Levenstein.sum(Levenstein.this.getAt(row - Levenstein.this.fStep, col), 1);
            int fromLeft = Levenstein.sum(Levenstein.this.getAt(row, col - Levenstein.this.fStep), 1);
            int minDiag = Levenstein.this.getAt(row - Levenstein.this.fStep, col - Levenstein.this.fStep);
            int minCellValue = Math.min(Math.min(fromAbove, fromLeft), minDiag);
            int minCost = Levenstein.this.minCost(row, col, minCellValue);
            if (minCost > Levenstein.this.fMaxCost) {
                return Integer.MAX_VALUE;
            }
            if (minCellValue == fromAbove || minCellValue == fromLeft) {
                return minCellValue;
            }
            Assert.isTrue((minCellValue == minDiag && fromAbove >= minDiag && fromLeft >= minDiag ? 1 : 0) != 0);
            int nextCharCost = Levenstein.this.rangesEqual(row, col) ? 0 : 1;
            minCost = Levenstein.sum(minCost, nextCharCost);
            if (minCost > Levenstein.this.fMaxCost) {
                return Integer.MAX_VALUE;
            }
            int cost = minDiag + nextCharCost;
            Levenstein.this.fMaxCost = Math.min(Levenstein.this.fMaxCost, Levenstein.this.maxCost(row, col, cost));
            return cost;
        }
    }
}

