/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteWithMirrors;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.standalone.InstallCommand;
import org.eclipse.wst.server.core.internal.IInstallableRuntime;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.Trace;
import org.osgi.framework.Bundle;

public class InstallableRuntime
implements IInstallableRuntime {
    private IConfigurationElement element;

    public InstallableRuntime(IConfigurationElement element) {
        this.element = element;
    }

    public String getId() {
        try {
            return this.element.getAttribute("id");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getFeatureVersion() {
        try {
            return this.element.getAttribute("featureVersion");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getFeatureId() {
        try {
            return this.element.getAttribute("featureId");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getBundleId() {
        try {
            return this.element.getAttribute("bundleId");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getPath() {
        try {
            return this.element.getAttribute("path");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getFromSite() {
        try {
            return this.element.getAttribute("featureSite");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void install(final IPath path) {
        Job installRuntimeJob = new Job(Messages.jobInstallingRuntime){

            public boolean belongsTo(Object family) {
                return "org.eclipse.wst.server.core".equals(family);
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    InstallableRuntime.this.install(path, monitor);
                }
                catch (CoreException ce) {
                    return ce.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        installRuntimeJob.schedule();
    }

    public static ISite getSite(String fromSite, IProgressMonitor monitor) {
        try {
            URL siteURL = new URL(fromSite);
            return SiteManager.getSite((URL)siteURL, (IProgressMonitor)monitor);
        }
        catch (MalformedURLException e) {
            Trace.trace(Trace.WARNING, "Could not parse site", e);
        }
        catch (CoreException e) {
            Trace.trace(Trace.WARNING, "Could not parse site", e);
        }
        catch (Exception e) {
            Trace.trace(Trace.WARNING, "Could not parse site", e);
        }
        return null;
    }

    public static String getMirror(String fromSite, ISite site) {
        String mirrorSite;
        if (site != null && (mirrorSite = InstallableRuntime.getMirror(site)) != null) {
            return mirrorSite;
        }
        return fromSite;
    }

    public static String getMirror(ISite site) {
        if (site != null && site instanceof ISiteWithMirrors) {
            try {
                IURLEntry[] urlEntries = ((ISiteWithMirrors)site).getMirrorSiteEntries();
                if (urlEntries.length > 0) {
                    return urlEntries[0].getURL().toExternalForm();
                }
            }
            catch (CoreException e) {
                Trace.trace(Trace.WARNING, "Could not find mirror site", e);
            }
        }
        return null;
    }

    public void install(IPath path, IProgressMonitor monitor) throws CoreException {
        String featureId = this.getFeatureId();
        String featureVersion = this.getFeatureVersion();
        String fromSite = this.getFromSite();
        if (featureId == null || featureVersion == null || fromSite == null) {
            return;
        }
        ISite site = InstallableRuntime.getSite(fromSite, monitor);
        fromSite = InstallableRuntime.getMirror(fromSite, site);
        Bundle bundle = Platform.getBundle((String)this.getBundleId());
        if (bundle == null) {
            try {
                monitor.setTaskName("Installing feature");
                InstallCommand command = new InstallCommand(featureId, featureVersion, fromSite, null, "false");
                boolean b = command.run(monitor);
                if (!b) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorInstallingServerFeature, null));
                }
                command.applyChangesNow();
            }
            catch (Exception e) {
                Trace.trace(Trace.SEVERE, "Error installing feature", e);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorInstallingServer, (Object)e.getLocalizedMessage()), (Throwable)e));
            }
        }
        try {
            byte[] buf = new byte[8192];
            bundle = Platform.getBundle((String)this.getBundleId());
            URL url = bundle.getEntry(this.getPath());
            url = Platform.resolve((URL)url);
            InputStream in = url.openStream();
            BufferedInputStream bin = new BufferedInputStream(in);
            ZipInputStream zin = new ZipInputStream(bin);
            ZipEntry entry = zin.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                monitor.setTaskName("Unzipping: " + name);
                if (entry.isDirectory()) {
                    path.append(name).toFile().mkdirs();
                } else {
                    FileOutputStream fout = new FileOutputStream(path.append(name).toFile());
                    int r = zin.read(buf);
                    while (r >= 0) {
                        fout.write(buf, 0, r);
                        r = zin.read(buf);
                    }
                }
                zin.closeEntry();
                entry = zin.getNextEntry();
            }
            zin.close();
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error unzipping runtime", e);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorInstallingServer, (Object)e.getLocalizedMessage()), (Throwable)e));
        }
    }

    public String toString() {
        return "InstallableRuntime[" + this.getId() + "]";
    }
}

