/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.navigator.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.navigator.internal.EMFModelManager;
import org.eclipse.jst.j2ee.navigator.internal.EMFModelManagerFactory;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;

public class EMFRootObjectProvider
implements IResourceChangeListener,
IResourceDeltaVisitor {
    private final HashMap emfModelCache = new HashMap();
    private final List listeners = new ArrayList();

    public EMFRootObjectProvider() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getModels(IProject project) {
        try {
            EMFModelManager modelManager = (EMFModelManager)this.emfModelCache.get(project);
            if (modelManager == null) {
                HashMap hashMap = this.emfModelCache;
                synchronized (hashMap) {
                    modelManager = EMFModelManagerFactory.createEMFModelManager(project, this);
                    this.emfModelCache.put(project, modelManager);
                }
            }
            return modelManager.getModels();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                delta.accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException e) {
                Logger.getLogger().logError((Throwable)e);
            }
            catch (SWTException swte) {
                Logger.getLogger().logError((Throwable)swte);
            }
            catch (SWTError swte) {
                Logger.getLogger().logError((Throwable)swte);
            }
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource != null) {
            switch (resource.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    boolean projectOpenStateChanged;
                    boolean bl = projectOpenStateChanged = (delta.getFlags() & 0x4000) != 0;
                    if (delta.getKind() == 2 || projectOpenStateChanged) {
                        IProject project = (IProject)resource;
                        this.dispose(project);
                    }
                    return false;
                }
            }
        }
        return false;
    }

    private void dispose(IProject project) {
        if (project == null) {
            return;
        }
        EMFModelManager modelManager = (EMFModelManager)this.emfModelCache.remove(project);
        if (modelManager != null) {
            modelManager.dispose();
            modelManager = null;
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        EMFModelManager modelManager = null;
        Object[] keys = this.emfModelCache.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            modelManager = (EMFModelManager)this.emfModelCache.remove(keys[i]);
            if (modelManager != null) {
                modelManager.dispose();
            }
            ++i;
        }
    }

    public void notifyListeners(IProject aProject) {
        int x = 0;
        while (x < this.listeners.size()) {
            IRefreshHandlerListener refreshHandler = (IRefreshHandlerListener)this.listeners.get(x);
            refreshHandler.onRefresh(aProject);
            ++x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRefreshHandlerListener(IRefreshHandlerListener aListener) {
        List list = this.getListeners();
        synchronized (list) {
            if (aListener != null && !this.getListeners().contains(aListener)) {
                this.getListeners().add(aListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRefreshHandlerListener(IRefreshHandlerListener aListener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(aListener);
        }
    }

    protected List getListeners() {
        return this.listeners;
    }

    public static interface IRefreshHandlerListener {
        public void onRefresh(Object var1);
    }
}

