/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.navigator.internal.workingsets;

import java.util.ArrayList;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.AbstractWorkingSetManager;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.ICommonWorkingSet;
import org.eclipse.jst.j2ee.navigator.internal.workingsets.ComponentWorkingSetDescriptor;
import org.eclipse.jst.j2ee.navigator.internal.workingsets.ComponentWorkingSetRegistry;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.WorkingSetDescriptor;
import org.eclipse.ui.internal.registry.WorkingSetRegistry;

public class ComponentWorkingSet
implements ICommonWorkingSet,
IActionFilter {
    static final String FACTORY_ID = "org.eclipse.jst.j2ee.navigator.internal.workingsets.ComponentWorkingSetFactory";
    private static final String COMPONENT_TYPE_ID = "componentTypeId";
    private static final String EDIT_PAGE_ID = "editPageId";
    public static final String COMPONENT_WORKING_SET_ID = "org.eclipse.jst.j2ee.navigator.ui.ComponentWorkingSetPage";
    private String name;
    private String label;
    private ArrayList elements;
    private String editPageId;
    private IMemento workingSetMemento;
    private IWorkingSetManager manager;
    private String typeId;
    public static final String TAG_TYPE_ID = "typeId";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ComponentWorkingSet(String aName, IAdaptable[] elements) {
        this.name = aName;
        this.internalSetElements(elements);
    }

    ComponentWorkingSet(String aName, String aTypeId, IMemento memento) {
        this.name = aName;
        this.typeId = aTypeId;
        this.workingSetMemento = memento;
        this.internalSetElements(new IAdaptable[0]);
    }

    public ComponentWorkingSet(ComponentWorkingSetDescriptor aDescriptor) {
        this.name = aDescriptor.getLabel();
        this.typeId = aDescriptor.getTypeId();
        this.editPageId = aDescriptor.getId();
        this.internalSetElements(new IAdaptable[0]);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ComponentWorkingSet) {
            boolean typeIdEqual;
            ComponentWorkingSet workingSet = (ComponentWorkingSet)object;
            String objectPageId = workingSet.getId();
            String pageId = this.getId();
            boolean pageIdEqual = objectPageId == null && pageId == null || objectPageId != null && objectPageId.equals(pageId);
            String objectTypeId = workingSet.getTypeId();
            String typeId = this.getTypeId();
            boolean bl = typeIdEqual = objectTypeId == null && typeId == null || objectTypeId != null && objectTypeId.equals(typeId);
            return workingSet.getName().equals(this.getName()) && workingSet.getElementsArray().equals(this.getElementsArray()) && pageIdEqual && typeIdEqual;
        }
        return false;
    }

    public boolean isEditable() {
        WorkingSetRegistry registry = WorkbenchPlugin.getDefault().getWorkingSetRegistry();
        String id = this.getId();
        if (id == null) {
            return false;
        }
        WorkingSetDescriptor descriptor = registry.getWorkingSetDescriptor(id);
        if (descriptor == null) {
            return false;
        }
        return descriptor.isEditable();
    }

    public Object getAdapter(Class adapter) {
        block12: {
            block11: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.IWorkingSet");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (adapter == clazz) break block11;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.ui.IPersistableElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (adapter != clazz2) break block12;
            }
            return this;
        }
        return InternalPlatform.getDefault().getAdapterManager().getAdapter((Object)this, adapter);
    }

    public IAdaptable[] getElements() {
        ArrayList list = this.getElementsArray();
        return list.toArray(new IAdaptable[list.size()]);
    }

    private ArrayList getElementsArray() {
        if (this.elements == null) {
            this.restoreWorkingSet();
            this.workingSetMemento = null;
        }
        return this.elements;
    }

    public String getFactoryId() {
        return FACTORY_ID;
    }

    public String getId() {
        if (this.editPageId == null) {
            this.editPageId = COMPONENT_WORKING_SET_ID;
        }
        return this.editPageId;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int hashCode = this.name.hashCode() & this.typeId.hashCode();
        if (this.editPageId != null) {
            hashCode &= this.editPageId.hashCode();
        }
        return hashCode;
    }

    private void restoreWorkingSet() {
    }

    public void saveState(IMemento memento) {
        if (this.workingSetMemento != null) {
            memento.putMemento(this.workingSetMemento);
        } else {
            memento.putString("name", this.getName());
            memento.putString(EDIT_PAGE_ID, this.getId());
            memento.putString(TAG_TYPE_ID, this.typeId);
        }
    }

    public void setElements(IAdaptable[] newElements) {
        this.internalSetElements(newElements);
        this.fireWorkingSetChanged("workingSetContentChange", null);
    }

    private void internalSetElements(IAdaptable[] newElements) {
        Assert.isNotNull((Object)newElements, (String)"Working set elements array must not be null");
        this.elements = new ArrayList(newElements.length);
        int i = 0;
        while (i < newElements.length) {
            this.elements.add(newElements[i]);
            ++i;
        }
    }

    public void setId(String pageId) {
        this.editPageId = pageId;
    }

    public void setName(String newName) {
        Assert.isNotNull((Object)newName, (String)"Working set name must not be null");
        this.name = newName;
        this.fireWorkingSetChanged("workingSetNameChange", null);
    }

    public void connect(IWorkingSetManager manager) {
        Assert.isTrue((this.manager == null ? 1 : 0) != 0, (String)"A working set can only be connected to one manager");
        this.manager = manager;
    }

    public void disconnect() {
        this.manager = null;
    }

    private void fireWorkingSetChanged(String property, Object oldValue) {
        AbstractWorkingSetManager receiver = this.manager != null ? (AbstractWorkingSetManager)this.manager : (AbstractWorkingSetManager)WorkbenchPlugin.getDefault().getWorkingSetManager();
        receiver.workingSetChanged((IWorkingSet)this, property, oldValue);
    }

    public ImageDescriptor getImage() {
        ComponentWorkingSetRegistry registry = ComponentWorkingSetRegistry.getInstance();
        ComponentWorkingSetDescriptor descriptor = null;
        descriptor = registry.getWorkingSetDescriptor(this.getId(), this.typeId);
        if (descriptor == null) {
            return null;
        }
        return descriptor.getIcon();
    }

    public String getTypeId() {
        return this.typeId;
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (COMPONENT_TYPE_ID.equals(name)) {
            return this.getTypeId().equals(value);
        }
        if (EDIT_PAGE_ID.equals(name)) {
            return this.getId().equals(value);
        }
        return false;
    }

    public boolean isVisible() {
        return true;
    }

    public String getLabel() {
        String result = this.label;
        if (result == null) {
            result = this.getName();
        }
        return result;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isSelfUpdating() {
        return false;
    }

    public boolean isAggregateWorkingSet() {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }
}

